/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.bundle;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.onebusaway.transit_data_federation.impl.bundle.AbstractBundleStoreImpl;
import org.onebusaway.transit_data_federation.model.bundle.BundleItem;
import org.onebusaway.transit_data_federation.services.bundle.BundleStoreService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalBundleStoreImpl
extends AbstractBundleStoreImpl
implements BundleStoreService {
    private static Logger _log = LoggerFactory.getLogger(LocalBundleStoreImpl.class);
    private boolean legacyBundle = false;

    public LocalBundleStoreImpl(String bundleRootPath) {
        super(bundleRootPath);
    }

    @Override
    public List<BundleItem> getBundles() {
        ArrayList<BundleItem> output = new ArrayList<BundleItem>();
        if (this._bundleRootPath == null) {
            return output;
        }
        File bundleRoot = new File(this._bundleRootPath);
        if (!bundleRoot.isDirectory()) {
            return output;
        }
        for (String filename : bundleRoot.list()) {
            File possibleBundle = new File(bundleRoot, filename);
            if (possibleBundle.isDirectory()) {
                File calendarServiceObjectFile = new File(possibleBundle, "CalendarServiceData.obj");
                File metadataFile = new File(possibleBundle, "metadata.json");
                if (!calendarServiceObjectFile.exists()) {
                    _log.warn("Could not find CalendarServiceData.obj in local bundle '" + filename + "'; skipping. Not a bundle?");
                    continue;
                }
                if (!metadataFile.exists()) {
                    _log.warn("Could not find metadata.json in local bundle '" + filename + "'; skipping. Not a bundle?");
                    continue;
                }
                try {
                    BundleItem validLocalBundle = this.createBundleItem(calendarServiceObjectFile, metadataFile, filename);
                    output.add(validLocalBundle);
                }
                catch (Exception e) {}
                continue;
            }
            if (!possibleBundle.isFile() || !possibleBundle.getName().equalsIgnoreCase("CalendarServiceData.obj")) continue;
            try {
                String parentFilename = bundleRoot.getName();
                BundleItem validLocalBundle = this.createBundleItem(possibleBundle, parentFilename);
                output.add(validLocalBundle);
                this.setLegacyBundle(true);
                break;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return output;
    }

    @Override
    public boolean isLegacyBundle() {
        return this.legacyBundle;
    }

    public void setLegacyBundle(boolean legacyBundle) {
        this.legacyBundle = legacyBundle;
    }
}

