/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.bundle;

import org.onebusaway.transit_data_federation.impl.bundle.BundleScheduler;
import org.onebusaway.transit_data_federation.services.bundle.BundleManagementService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

public class IntervalBundleSchedulerImpl
implements BundleScheduler {
    private static Logger _log = LoggerFactory.getLogger(IntervalBundleSchedulerImpl.class);
    private BundleManagementService _service;
    private ThreadPoolTaskScheduler _taskScheduler;
    private long intervalInMillis;

    public IntervalBundleSchedulerImpl(int intervalInMinutes) {
        this.intervalInMillis = intervalInMinutes * 60 * 1000;
    }

    @Override
    public void setup(BundleManagementService service, ThreadPoolTaskScheduler taskScheduler) {
        this._service = service;
        this._taskScheduler = taskScheduler;
        if (this._taskScheduler != null) {
            _log.info("Starting bundle discovery and switch threads...");
            BundleDiscoveryUpdateThread thread = new BundleDiscoveryUpdateThread();
            this._taskScheduler.scheduleWithFixedDelay((Runnable)thread, this.intervalInMillis);
        }
    }

    protected class BundleDiscoveryUpdateThread
    implements Runnable {
        protected BundleDiscoveryUpdateThread() {
        }

        @Override
        public void run() {
            try {
                IntervalBundleSchedulerImpl.this._service.discoverBundles();
                IntervalBundleSchedulerImpl.this._service.refreshApplicableBundles();
                IntervalBundleSchedulerImpl.this._service.reevaluateBundleAssignment();
            }
            catch (Exception e) {
                _log.error("Error updating bundle list: " + e.getMessage(), (Throwable)e);
                e.printStackTrace();
            }
        }
    }
}

