/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.bundle;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimerTask;
import org.onebusaway.transit_data_federation.impl.bundle.BundleScheduler;
import org.onebusaway.transit_data_federation.services.bundle.BundleManagementService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.TriggerContext;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

public class HourlyBundleSchedulerImpl
implements BundleScheduler {
    private static Logger _log = LoggerFactory.getLogger(HourlyBundleSchedulerImpl.class);
    private BundleManagementService _service;
    private ThreadPoolTaskScheduler _taskScheduler;

    @Override
    public void setup(BundleManagementService service, ThreadPoolTaskScheduler taskScheduler) {
        this._service = service;
        this._taskScheduler = taskScheduler;
        if (this._taskScheduler != null) {
            _log.info("Starting bundle discovery and switch threads...");
            BundleDiscoveryUpdateThread discoveryThread = new BundleDiscoveryUpdateThread();
            this._taskScheduler.schedule((Runnable)discoveryThread, (Trigger)discoveryThread);
            BundleSwitchUpdateThread switchThread = new BundleSwitchUpdateThread();
            this._taskScheduler.schedule((Runnable)switchThread, (Trigger)switchThread);
        }
    }

    protected class BundleSwitchUpdateThread
    extends TimerTask
    implements Trigger {
        @Override
        public void run() {
            try {
                HourlyBundleSchedulerImpl.this._service.refreshApplicableBundles();
                HourlyBundleSchedulerImpl.this._service.reevaluateBundleAssignment();
            }
            catch (Exception e) {
                _log.error("Error re-evaluating bundle assignment: " + e.getMessage());
                e.printStackTrace();
            }
        }

        public Date nextExecutionTime(TriggerContext arg0) {
            Date lastTime = arg0.lastScheduledExecutionTime();
            if (lastTime == null) {
                lastTime = new Date();
            }
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(lastTime);
            calendar.set(14, 0);
            calendar.set(13, 1);
            if (HourlyBundleSchedulerImpl.this._service.getApplicableBundlesSize() > 0 && HourlyBundleSchedulerImpl.this._service.getCurrentBundleId() == null) {
                int minutes = calendar.get(12);
                calendar.set(12, minutes + 1);
            } else {
                calendar.set(12, 0);
                int hour = calendar.get(10);
                calendar.set(10, hour + 1);
            }
            return calendar.getTime();
        }
    }

    protected class BundleDiscoveryUpdateThread
    extends TimerTask
    implements Trigger {
        @Override
        public void run() {
            try {
                HourlyBundleSchedulerImpl.this._service.discoverBundles();
            }
            catch (Exception e) {
                _log.error("Error updating bundle list: " + e.getMessage(), (Throwable)e);
                e.printStackTrace();
            }
        }

        public Date nextExecutionTime(TriggerContext arg0) {
            Date lastTime = arg0.lastScheduledExecutionTime();
            if (lastTime == null) {
                lastTime = new Date();
            }
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(lastTime);
            calendar.set(14, 0);
            calendar.set(13, 0);
            int minute = calendar.get(12);
            calendar.set(12, minute + 15);
            return calendar.getTime();
        }
    }
}

