/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.bundle;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.onebusaway.container.refresh.Refreshable;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.transit_data.model.ListBean;
import org.onebusaway.transit_data.model.RouteBean;
import org.onebusaway.transit_data.model.StopBean;
import org.onebusaway.transit_data.services.TransitDataService;
import org.onebusaway.transit_data_federation.impl.beans.RouteBeanIdComparator;
import org.onebusaway.transit_data_federation.impl.beans.StopBeanIdComparator;
import org.onebusaway.transit_data_federation.services.bundle.BundleSearchService;
import org.onebusaway.util.AgencyAndIdLibrary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

@Component
public class BundleSearchServiceImpl
implements BundleSearchService,
ApplicationListener {
    private static final int MAX_TYPE_AHEAD_LENGTH = 32;
    @Autowired
    private TransitDataService _transitDataService = null;
    private Map<String, List<String>> suggestions = Collections.synchronizedMap(new HashMap());
    private Map<String, List<StopBean>> stopSuggestions = Collections.synchronizedMap(new HashMap());
    private Map<String, List<RouteBean>> routeSuggestions = Collections.synchronizedMap(new HashMap());
    private boolean _initialized = false;
    private static Logger _log = LoggerFactory.getLogger(BundleSearchServiceImpl.class);

    @PostConstruct
    @Refreshable(dependsOn={"routeCollectionsData", "transitGraph"})
    public void init() {
        Runnable initThread = new Runnable(){

            @Override
            public void run() {
                while (!BundleSearchServiceImpl.this._initialized) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
                _log.info("building cache");
                SearchState searchState = BundleSearchServiceImpl.this.createSearchState();
                Map agencies = BundleSearchServiceImpl.this._transitDataService.getAgencyIdsWithCoverageArea();
                for (String agency : agencies.keySet()) {
                    ListBean routes = BundleSearchServiceImpl.this._transitDataService.getRoutesForAgencyId(agency);
                    for (RouteBean route : routes.getList()) {
                        String shortName = route.getShortName();
                        String hint = route.getLongName();
                        if (hint == null) {
                            hint = route.getId();
                        }
                        BundleSearchServiceImpl.this.generateInputsForString(BundleSearchServiceImpl.this.createRouteSuggestionState(searchState, shortName, hint, route));
                    }
                    ListBean stopIds = BundleSearchServiceImpl.this._transitDataService.getStopIdsForAgencyId(agency);
                    for (String stopId : stopIds.getList()) {
                        if (!BundleSearchServiceImpl.this._transitDataService.stopHasRevenueService(agency, stopId).booleanValue()) continue;
                        AgencyAndId agencyAndId = AgencyAndIdLibrary.convertFromString((String)stopId);
                        StopBean stop = BundleSearchServiceImpl.this._transitDataService.getStop(stopId);
                        String hint = null;
                        if (stop != null) {
                            hint = stop.getName();
                        }
                        if (hint == null) {
                            hint = stop.getId();
                        }
                        BundleSearchServiceImpl.this.generateInputsForString(BundleSearchServiceImpl.this.createStopSuggestionState(searchState, agencyAndId.getId(), hint, stop));
                    }
                }
                BundleSearchServiceImpl.this.suggestions = searchState.getSuggestions();
                BundleSearchServiceImpl.this.stopSuggestions = searchState.getStopSuggestions();
                BundleSearchServiceImpl.this.routeSuggestions = searchState.getRouteSuggestions();
                _log.info("complete with suggestions {}, stopSuggestions {}, and routeSuggestions {}", new Object[]{BundleSearchServiceImpl.this.suggestions.size(), BundleSearchServiceImpl.this.stopSuggestions.size(), BundleSearchServiceImpl.this.routeSuggestions.size()});
            }
        };
        new Thread(initThread).start();
    }

    private SearchState createSearchState() {
        SearchState state = new SearchState();
        return state;
    }

    private SuggestionState createStopSuggestionState(SearchState searchState, String name, String hint, StopBean stop) {
        SuggestionState state = new SuggestionState(searchState, name, hint);
        state.setStop(stop);
        return state;
    }

    private SuggestionState createRouteSuggestionState(SearchState searchState, String name, String hint, RouteBean route) {
        SuggestionState state = new SuggestionState(searchState, name, hint);
        state.setRoute(route);
        return state;
    }

    private void generateInputsForString(SuggestionState state) {
        String string = state.getString();
        String splitRegex = state.getRegex();
        String hint = state.getHint();
        List<String> generalSearchParts = this.splitParts(splitRegex, string);
        for (String searchPart : generalSearchParts) {
            state.addSuggestion(searchPart, string + " [" + hint + "]");
        }
        if (state.getRoute() != null) {
            List<String> routeSearchParts = this.splitParts(splitRegex, hint);
            for (String routeSearchPart : routeSearchParts) {
                state.addRouteSuggestion(routeSearchPart, state.getRoute());
            }
        }
        if (state.getStop() != null) {
            List<String> stopSearchParts = this.splitParts(splitRegex, hint);
            for (String stopSearchPart : stopSearchParts) {
                state.addStopSuggestion(stopSearchPart, state.getStop());
            }
        }
    }

    List<String> splitParts(String splitRegex, String string) {
        ArrayList<String> results = new ArrayList<String>();
        if (string == null) {
            return results;
        }
        String[] parts = splitRegex != null ? string.split(splitRegex) : new String[]{string};
        for (String part : parts) {
            int length = part.length();
            for (int i = 0; i < length; ++i) {
                String key = part.substring(0, i + 1).toLowerCase();
                results.add(key);
            }
        }
        if (parts.length > 1) {
            int startPos;
            for (int i = startPos = parts[0].length(); i < Math.min(string.length(), 32); ++i) {
                String key = string.substring(0, i + 1).toLowerCase();
                results.add(key);
            }
            if (string.length() > 32) {
                results.add(string.toLowerCase());
            }
        }
        return results;
    }

    @Override
    public List<String> getSuggestions(String input) {
        List<String> tmpSuggestions = this.suggestions.get(input);
        if (tmpSuggestions == null) {
            tmpSuggestions = new ArrayList<String>();
        }
        if (tmpSuggestions.size() > 10) {
            tmpSuggestions = tmpSuggestions.subList(0, 10);
        }
        return tmpSuggestions;
    }

    @Override
    public ListBean<StopBean> getStopSuggestions(String input, int maxCount) {
        List<StopBean> tmpStopSuggestions = this.stopSuggestions.get(input);
        boolean limitExceeded = false;
        if (tmpStopSuggestions == null) {
            tmpStopSuggestions = new ArrayList<StopBean>();
        }
        if (tmpStopSuggestions.size() > maxCount) {
            limitExceeded = true;
            tmpStopSuggestions = tmpStopSuggestions.subList(0, maxCount);
        }
        return new ListBean(tmpStopSuggestions, limitExceeded);
    }

    @Override
    public ListBean<RouteBean> getRouteSuggestions(String input, int maxCount) {
        List<RouteBean> tmpRouteSuggestions = this.routeSuggestions.get(input);
        boolean limitExceeded = false;
        if (tmpRouteSuggestions == null) {
            tmpRouteSuggestions = new ArrayList<RouteBean>();
        }
        if (tmpRouteSuggestions.size() > maxCount) {
            limitExceeded = true;
            tmpRouteSuggestions = tmpRouteSuggestions.subList(0, maxCount);
        }
        return new ListBean(tmpRouteSuggestions, limitExceeded);
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextRefreshedEvent) {
            this._initialized = true;
        }
    }

    private class SearchState {
        private Map<String, List<String>> stateSuggestions = Collections.synchronizedMap(new HashMap());
        private Map<String, List<StopBean>> stopSuggestions = Collections.synchronizedMap(new HashMap());
        private Map<String, List<RouteBean>> routeSuggestions = Collections.synchronizedMap(new HashMap());

        public Map<String, List<String>> getSuggestions() {
            return this.stateSuggestions;
        }

        public Map<String, List<StopBean>> getStopSuggestions() {
            return this.stopSuggestions;
        }

        public Map<String, List<RouteBean>> getRouteSuggestions() {
            return this.routeSuggestions;
        }

        public void addSuggestion(String key, String value) {
            List<String> suggestion = this.getSuggestions().get(key);
            if (suggestion == null) {
                suggestion = new ArrayList<String>();
            }
            suggestion.add(value);
            Collections.sort(suggestion);
            this.stateSuggestions.put(key, suggestion);
        }

        public void addRouteSuggestions(String key, RouteBean route) {
            List<RouteBean> suggestion = this.getRouteSuggestions().get(key);
            if (suggestion == null) {
                suggestion = new ArrayList<RouteBean>();
            }
            suggestion.add(route);
            Collections.sort(suggestion, new RouteBeanIdComparator());
            this.routeSuggestions.put(key, suggestion);
        }

        public void addStopSuggestions(String key, StopBean stop) {
            List<StopBean> suggestion = this.getStopSuggestions().get(key);
            if (suggestion == null) {
                suggestion = new ArrayList<StopBean>();
            }
            suggestion.add(stop);
            Collections.sort(suggestion, new StopBeanIdComparator());
            this.stopSuggestions.put(key, suggestion);
        }
    }

    private class SuggestionState {
        private SearchState searchState;
        private String name;
        private String hint;
        private String regex = "\\s+|-|/|\\(|\\)|&";
        private RouteBean route;
        private StopBean stop;

        public SuggestionState(SearchState searchState, String name, String hint) {
            this.searchState = searchState;
            this.name = name;
            this.hint = hint;
        }

        public String getString() {
            return this.name;
        }

        public String getRegex() {
            return this.regex;
        }

        public Map<String, List<String>> getSuggestions() {
            return this.searchState.getSuggestions();
        }

        public String getHint() {
            return this.hint;
        }

        public void setRoute(RouteBean route) {
            this.route = route;
        }

        public RouteBean getRoute() {
            return this.route;
        }

        public void setStop(StopBean stop) {
            this.stop = stop;
        }

        public StopBean getStop() {
            return this.stop;
        }

        public void addSuggestion(String key, String suggestion) {
            this.searchState.addSuggestion(key, suggestion);
        }

        public void addStopSuggestion(String key, StopBean stop) {
            this.searchState.addStopSuggestions(key, stop);
        }

        public void addRouteSuggestion(String key, RouteBean route) {
            this.searchState.addRouteSuggestions(key, route);
        }
    }
}

