/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.bundle;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.util.Date;
import org.joda.time.DateTime;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.calendar.CalendarServiceData;
import org.onebusaway.gtfs.model.calendar.ServiceDate;
import org.onebusaway.transit_data.model.config.BundleMetadata;
import org.onebusaway.transit_data_federation.model.bundle.BundleItem;
import org.onebusaway.utility.ObjectSerializationLibrary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractBundleStoreImpl {
    private static Logger _log = LoggerFactory.getLogger(AbstractBundleStoreImpl.class);
    public final String CALENDAR_DATA = "CalendarServiceData.obj";
    protected final String METADATA = "metadata.json";
    protected String _bundleRootPath = null;

    public AbstractBundleStoreImpl(String bundleRootPath) {
        this._bundleRootPath = bundleRootPath;
    }

    protected BundleItem createBundleItem(File calendarServiceObjectFile, File metadataFile, String filename) throws Exception {
        ServiceDate minServiceDate = null;
        ServiceDate maxServiceDate = null;
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            BundleMetadata meta = null;
            meta = (BundleMetadata)mapper.readValue(metadataFile, BundleMetadata.class);
            Date fromDate = new Date(Long.parseLong(meta.getServiceDateFrom()));
            Date toDate = new Date(Long.parseLong(meta.getServiceDateTo()));
            minServiceDate = new ServiceDate(fromDate);
            maxServiceDate = new ServiceDate(toDate);
        }
        catch (Exception e) {
            _log.error(e.getMessage());
            _log.error("Deserialization of metadata.json in local bundle " + filename + "; skipping.");
            throw new Exception(e);
        }
        _log.info("Found local bundle " + filename + " with service range " + minServiceDate + " => " + maxServiceDate);
        BundleItem bundleItem = new BundleItem();
        bundleItem.setId(filename);
        bundleItem.setName(filename);
        bundleItem.setServiceDateFrom(minServiceDate);
        bundleItem.setServiceDateTo(maxServiceDate);
        DateTime lastModified = new DateTime(calendarServiceObjectFile.lastModified());
        bundleItem.setCreated(lastModified);
        bundleItem.setUpdated(lastModified);
        return bundleItem;
    }

    protected BundleItem createBundleItem(File calendarServiceObjectFile, String filename) throws Exception {
        ServiceDate minServiceDate = null;
        ServiceDate maxServiceDate = null;
        try {
            CalendarServiceData data = (CalendarServiceData)ObjectSerializationLibrary.readObject((File)calendarServiceObjectFile);
            for (AgencyAndId serviceId : data.getServiceIds()) {
                for (ServiceDate serviceDate : data.getServiceDatesForServiceId(serviceId)) {
                    if (minServiceDate == null || serviceDate.compareTo(minServiceDate) <= 0) {
                        minServiceDate = serviceDate;
                    }
                    if (maxServiceDate != null && serviceDate.compareTo(maxServiceDate) < 0) continue;
                    maxServiceDate = serviceDate;
                }
            }
        }
        catch (Exception e) {
            _log.info("Deserialization of CalendarServiceData.obj in local bundle " + filename + "; skipping.");
            throw new Exception(e);
        }
        _log.info("Found local bundle " + filename + " with service range " + minServiceDate + " => " + maxServiceDate);
        BundleItem bundleItem = new BundleItem();
        bundleItem.setId(filename);
        bundleItem.setName(filename);
        bundleItem.setServiceDateFrom(minServiceDate);
        bundleItem.setServiceDateTo(maxServiceDate);
        DateTime lastModified = new DateTime(calendarServiceObjectFile.lastModified());
        bundleItem.setCreated(lastModified);
        bundleItem.setUpdated(lastModified);
        return bundleItem;
    }
}

