/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.blocks;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.onebusaway.collections.FactoryMap;
import org.onebusaway.container.refresh.Refreshable;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.transit_data_federation.impl.blocks.BlockIndexServiceImpl;
import org.onebusaway.transit_data_federation.impl.blocks.BlockSequence;
import org.onebusaway.transit_data_federation.impl.blocks.BlockStopTimeIndicesFactory;
import org.onebusaway.transit_data_federation.impl.transit_graph.StopEntryImpl;
import org.onebusaway.transit_data_federation.services.FederatedTransitDataBundle;
import org.onebusaway.transit_data_federation.services.blocks.BlockIndexFactoryService;
import org.onebusaway.transit_data_federation.services.blocks.BlockLayoverIndex;
import org.onebusaway.transit_data_federation.services.blocks.BlockLayoverIndexData;
import org.onebusaway.transit_data_federation.services.blocks.BlockSequenceIndex;
import org.onebusaway.transit_data_federation.services.blocks.BlockStopSequenceIndex;
import org.onebusaway.transit_data_federation.services.blocks.BlockStopTimeIndex;
import org.onebusaway.transit_data_federation.services.blocks.BlockTripIndex;
import org.onebusaway.transit_data_federation.services.blocks.BlockTripIndexData;
import org.onebusaway.transit_data_federation.services.blocks.FrequencyBlockStopTimeIndex;
import org.onebusaway.transit_data_federation.services.blocks.FrequencyBlockTripIndex;
import org.onebusaway.transit_data_federation.services.blocks.FrequencyBlockTripIndexData;
import org.onebusaway.transit_data_federation.services.blocks.FrequencyStopTripIndex;
import org.onebusaway.transit_data_federation.services.blocks.HasBlockTrips;
import org.onebusaway.transit_data_federation.services.blocks.StaticBlockIndexService;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockStopTimeEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockTripEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.StopEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.StopTimeEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.TransitGraphDao;
import org.onebusaway.util.SystemTime;
import org.onebusaway.utility.ObjectSerializationLibrary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class StaticBlockIndexServiceImpl
implements StaticBlockIndexService {
    private Logger _log = LoggerFactory.getLogger(BlockIndexServiceImpl.class);
    private FederatedTransitDataBundle _bundle;
    private TransitGraphDao _graphDao;
    private BlockIndexFactoryService _factory;
    private List<BlockTripIndex> _blockTripIndices;
    private Map<String, List<BlockTripIndex>> _blockTripIndicesByAgencyId;
    private Map<AgencyAndId, List<BlockTripIndex>> _blockTripIndicesByRouteId;
    private Map<AgencyAndId, List<BlockTripIndex>> _blockTripIndicesByBlockId;
    private List<BlockLayoverIndex> _blockLayoverIndices;
    private Map<String, List<BlockLayoverIndex>> _blockLayoverIndicesByAgencyId;
    private Map<AgencyAndId, List<BlockLayoverIndex>> _blockLayoverIndicesByRouteId;
    private Map<AgencyAndId, List<BlockLayoverIndex>> _blockLayoverIndicesByBlockId;
    private List<FrequencyBlockTripIndex> _frequencyBlockTripIndices;
    private Map<String, List<FrequencyBlockTripIndex>> _frequencyBlockTripIndicesByAgencyId;
    private Map<AgencyAndId, List<FrequencyBlockTripIndex>> _frequencyBlockTripIndicesByRouteId;
    private Map<AgencyAndId, List<FrequencyBlockTripIndex>> _frequencyBlockTripIndicesByBlockId;
    private List<BlockSequenceIndex> _blockSequenceIndices = Collections.emptyList();

    StaticBlockIndexServiceImpl() {
    }

    @Autowired
    public void setBundle(FederatedTransitDataBundle bundle) {
        this._bundle = bundle;
    }

    @Autowired
    public void setBlockIndexFactoryService(BlockIndexFactoryService blockIndexFactoryService) {
        this._factory = blockIndexFactoryService;
    }

    @Autowired
    public void setGraphDao(TransitGraphDao graphDao) {
        this._graphDao = graphDao;
    }

    @PostConstruct
    @Refreshable(dependsOn={"blockIndexData"})
    public void setup() throws Exception {
        this.loadBlockTripIndices();
        this.loadBlockLayoverIndices();
        this.loadFrequencyBlockTripIndices();
        this.loadBlockTripIndicesByBlockId();
        this.loadBlockSequenceIndices();
        this.loadStopTimeIndices();
        this.loadStopTripIndices();
    }

    @Override
    public List<BlockTripIndex> getBlockTripIndices() {
        return this._blockTripIndices;
    }

    @Override
    public List<BlockTripIndex> getBlockTripIndicesForAgencyId(String agencyId) {
        return this.list(this._blockTripIndicesByAgencyId.get(agencyId));
    }

    @Override
    public List<BlockTripIndex> getBlockTripIndicesForRouteCollectionId(AgencyAndId routeCollectionId) {
        return this.list(this._blockTripIndicesByRouteId.get(routeCollectionId));
    }

    @Override
    public List<BlockTripIndex> getBlockTripIndicesForBlock(AgencyAndId blockId) {
        return this.list(this._blockTripIndicesByBlockId.get(blockId));
    }

    @Override
    public List<BlockStopTimeIndex> getStopTimeIndicesForStop(StopEntry stopEntry) {
        return ((StopEntryImpl)stopEntry).getStopTimeIndices();
    }

    @Override
    public List<BlockSequenceIndex> getAllBlockSequenceIndices() {
        return this._blockSequenceIndices;
    }

    @Override
    public List<BlockStopSequenceIndex> getStopSequenceIndicesForStop(StopEntry stopEntry) {
        return ((StopEntryImpl)stopEntry).getStopTripIndices();
    }

    @Override
    public List<BlockLayoverIndex> getBlockLayoverIndices() {
        return this._blockLayoverIndices;
    }

    @Override
    public List<BlockLayoverIndex> getBlockLayoverIndicesForAgencyId(String agencyId) {
        return this.list(this._blockLayoverIndicesByAgencyId.get(agencyId));
    }

    @Override
    public List<BlockLayoverIndex> getBlockLayoverIndicesForRouteCollectionId(AgencyAndId routeCollectionId) {
        return this.list(this._blockLayoverIndicesByRouteId.get(routeCollectionId));
    }

    @Override
    public List<BlockLayoverIndex> getBlockLayoverIndicesForBlock(AgencyAndId blockId) {
        return this.list(this._blockLayoverIndicesByBlockId.get(blockId));
    }

    @Override
    public List<FrequencyBlockTripIndex> getFrequencyBlockTripIndices() {
        return this._frequencyBlockTripIndices;
    }

    @Override
    public List<FrequencyBlockTripIndex> getFrequencyBlockTripIndicesForAgencyId(String agencyId) {
        return this.list(this._frequencyBlockTripIndicesByAgencyId.get(agencyId));
    }

    @Override
    public List<FrequencyBlockTripIndex> getFrequencyBlockTripIndicesForRouteCollectionId(AgencyAndId routeCollectionId) {
        return this.list(this._frequencyBlockTripIndicesByRouteId.get(routeCollectionId));
    }

    @Override
    public List<FrequencyBlockTripIndex> getFrequencyBlockTripIndicesForBlock(AgencyAndId blockId) {
        return this.list(this._frequencyBlockTripIndicesByBlockId.get(blockId));
    }

    @Override
    public List<FrequencyBlockStopTimeIndex> getFrequencyStopTimeIndicesForStop(StopEntry stopEntry) {
        return ((StopEntryImpl)stopEntry).getFrequencyStopTimeIndices();
    }

    @Override
    public List<FrequencyStopTripIndex> getFrequencyStopTripIndicesForStop(StopEntry stop) {
        return ((StopEntryImpl)stop).getFrequencyStopTripIndices();
    }

    private <T> List<T> list(List<T> list) {
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    private void loadBlockTripIndices() throws IOException, ClassNotFoundException {
        File path = this._bundle.getBlockTripIndicesPath();
        if (path.exists()) {
            this._log.info("loading block trip indices data");
            List datas = (List)ObjectSerializationLibrary.readObject((File)path);
            this._blockTripIndices = new ArrayList<BlockTripIndex>(datas.size());
            for (BlockTripIndexData data : datas) {
                this._blockTripIndices.add(data.createIndex(this._graphDao));
            }
            this._blockTripIndicesByAgencyId = this.getBlockTripIndicesByAgencyId(this._blockTripIndices);
            this._blockTripIndicesByRouteId = this.getBlockTripsByRouteId(this._blockTripIndices);
            this._log.info("block indices data loaded");
        } else {
            this._blockTripIndices = Collections.emptyList();
            this._blockTripIndicesByAgencyId = Collections.emptyMap();
            this._blockTripIndicesByRouteId = Collections.emptyMap();
        }
    }

    private void loadBlockLayoverIndices() throws IOException, ClassNotFoundException {
        File path = this._bundle.getBlockLayoverIndicesPath();
        if (path.exists()) {
            this._log.info("loading block layover indices data");
            List datas = (List)ObjectSerializationLibrary.readObject((File)path);
            this._blockLayoverIndices = new ArrayList<BlockLayoverIndex>(datas.size());
            for (BlockLayoverIndexData data : datas) {
                this._blockLayoverIndices.add(data.createIndex(this._graphDao));
            }
            this._blockLayoverIndicesByAgencyId = this.getBlockTripIndicesByAgencyId(this._blockLayoverIndices);
            this._blockLayoverIndicesByRouteId = this.getBlockTripsByRouteId(this._blockLayoverIndices);
            this._log.info("block layover indices data loaded");
        } else {
            this._blockLayoverIndices = Collections.emptyList();
            this._blockLayoverIndicesByAgencyId = Collections.emptyMap();
            this._blockLayoverIndicesByRouteId = Collections.emptyMap();
        }
    }

    private void loadFrequencyBlockTripIndices() throws IOException, ClassNotFoundException {
        File path = this._bundle.getFrequencyBlockTripIndicesPath();
        if (path.exists()) {
            this._log.info("loading frequency block trip indices data");
            List datas = (List)ObjectSerializationLibrary.readObject((File)path);
            this._frequencyBlockTripIndices = new ArrayList<FrequencyBlockTripIndex>(datas.size());
            for (FrequencyBlockTripIndexData data : datas) {
                this._frequencyBlockTripIndices.add(data.createIndex(this._graphDao));
            }
            this._frequencyBlockTripIndicesByAgencyId = this.getBlockTripIndicesByAgencyId(this._frequencyBlockTripIndices);
            this._frequencyBlockTripIndicesByRouteId = this.getBlockTripsByRouteId(this._frequencyBlockTripIndices);
            this._log.info("block frequency trip indices data loaded");
        } else {
            this._frequencyBlockTripIndices = Collections.emptyList();
            this._frequencyBlockTripIndicesByAgencyId = Collections.emptyMap();
            this._frequencyBlockTripIndicesByRouteId = Collections.emptyMap();
        }
    }

    private <T extends HasBlockTrips> Map<String, List<T>> getBlockTripIndicesByAgencyId(List<T> indices) {
        FactoryMap blocksByAgencyId = new FactoryMap(new ArrayList());
        for (HasBlockTrips blockIndex : indices) {
            HashSet<String> agencyIds = new HashSet<String>();
            for (BlockTripEntry blockTrip : blockIndex.getTrips()) {
                agencyIds.add(blockTrip.getTrip().getId().getAgencyId());
            }
            for (String agencyId : agencyIds) {
                ((List)blocksByAgencyId.get(agencyId)).add(blockIndex);
            }
        }
        return blocksByAgencyId;
    }

    private <T extends HasBlockTrips> Map<AgencyAndId, List<T>> getBlockTripsByRouteId(List<T> indices) {
        FactoryMap blocksByRouteId = new FactoryMap(new ArrayList());
        for (HasBlockTrips index : indices) {
            HashSet<AgencyAndId> routeIds = new HashSet<AgencyAndId>();
            for (BlockTripEntry blockTrip : index.getTrips()) {
                routeIds.add(blockTrip.getTrip().getRouteCollection().getId());
            }
            for (AgencyAndId routeId : routeIds) {
                ((List)blocksByRouteId.get(routeId)).add(index);
            }
        }
        return blocksByRouteId;
    }

    private void loadBlockTripIndicesByBlockId() {
        this._log.info("calculating block trip indices by blockId...");
        long t1 = SystemTime.currentTimeMillis();
        this._blockTripIndicesByBlockId = new HashMap<AgencyAndId, List<BlockTripIndex>>();
        this._blockLayoverIndicesByBlockId = new HashMap<AgencyAndId, List<BlockLayoverIndex>>();
        this._frequencyBlockTripIndicesByBlockId = new HashMap<AgencyAndId, List<FrequencyBlockTripIndex>>();
        for (BlockEntry block : this._graphDao.getAllBlocks()) {
            List<BlockEntry> list = Arrays.asList(block);
            List<BlockTripIndex> indices = this._factory.createTripIndices(list);
            List<BlockLayoverIndex> layoverIndices = this._factory.createLayoverIndices(list);
            List<FrequencyBlockTripIndex> frequencyIndices = this._factory.createFrequencyTripIndices(list);
            if (!indices.isEmpty()) {
                this._blockTripIndicesByBlockId.put(block.getId(), indices);
            }
            if (!layoverIndices.isEmpty()) {
                this._blockLayoverIndicesByBlockId.put(block.getId(), layoverIndices);
            }
            if (frequencyIndices.isEmpty()) continue;
            this._frequencyBlockTripIndicesByBlockId.put(block.getId(), frequencyIndices);
        }
        long t2 = SystemTime.currentTimeMillis();
        this._log.info("completed calculating block trip indices by blockId: t=" + (t2 - t1));
    }

    private void loadBlockSequenceIndices() throws IOException, ClassNotFoundException {
        this._blockSequenceIndices = this._factory.createSequenceIndices(this._graphDao.getAllBlocks());
    }

    private void loadStopTimeIndices() {
        for (StopEntry stop : this._graphDao.getAllStops()) {
            StopEntryImpl stopImpl = (StopEntryImpl)stop;
            stopImpl.getStopTimeIndices().clear();
            stopImpl.getFrequencyStopTimeIndices().clear();
        }
        BlockStopTimeIndicesFactory factory = new BlockStopTimeIndicesFactory();
        factory.setVerbose(true);
        List<BlockStopTimeIndex> indices = factory.createIndices(this._graphDao.getAllBlocks());
        for (BlockStopTimeIndex index : indices) {
            StopEntryImpl stop = (StopEntryImpl)index.getStop();
            stop.addStopTimeIndex(index);
        }
        List<FrequencyBlockStopTimeIndex> frequencyIndices = factory.createFrequencyIndices(this._graphDao.getAllBlocks());
        for (FrequencyBlockStopTimeIndex index : frequencyIndices) {
            StopEntryImpl stop = (StopEntryImpl)index.getStop();
            stop.addFrequencyStopTimeIndex(index);
        }
    }

    private void loadStopTripIndices() {
        StopEntryImpl stop;
        StopTimeEntry stopTime;
        int offset;
        for (StopEntry stopEntry : this._graphDao.getAllStops()) {
            StopEntryImpl stopImpl = (StopEntryImpl)stopEntry;
            stopImpl.getStopTripIndices().clear();
            stopImpl.getFrequencyStopTripIndices().clear();
        }
        for (BlockSequenceIndex blockSequenceIndex : this._blockSequenceIndices) {
            BlockSequence sequence = blockSequenceIndex.getSequences().get(0);
            offset = 0;
            for (BlockStopTimeEntry bst : sequence.getStopTimes()) {
                stopTime = bst.getStopTime();
                stop = (StopEntryImpl)stopTime.getStop();
                BlockStopSequenceIndex blockStopTripIndex = new BlockStopSequenceIndex(blockSequenceIndex, offset);
                stop.addBlockStopTripIndex(blockStopTripIndex);
                ++offset;
            }
        }
        for (FrequencyBlockTripIndex frequencyBlockTripIndex : this._frequencyBlockTripIndices) {
            BlockTripEntry trip = frequencyBlockTripIndex.getTrips().get(0);
            offset = 0;
            for (BlockStopTimeEntry bst : trip.getStopTimes()) {
                stopTime = bst.getStopTime();
                stop = (StopEntryImpl)stopTime.getStop();
                FrequencyStopTripIndex stopTripIndex = new FrequencyStopTripIndex(frequencyBlockTripIndex, offset);
                stop.addFrequencyStopTripIndex(stopTripIndex);
                ++offset;
            }
        }
    }
}

