/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.blocks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.onebusaway.container.ConfigurationParameter;
import org.onebusaway.geospatial.model.CoordinateBounds;
import org.onebusaway.geospatial.model.CoordinatePoint;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.transit_data_federation.impl.blocks.BlockSequence;
import org.onebusaway.transit_data_federation.model.TargetTime;
import org.onebusaway.transit_data_federation.services.ExtendedCalendarService;
import org.onebusaway.transit_data_federation.services.blocks.BlockCalendarService;
import org.onebusaway.transit_data_federation.services.blocks.BlockGeospatialService;
import org.onebusaway.transit_data_federation.services.blocks.BlockInstance;
import org.onebusaway.transit_data_federation.services.blocks.BlockSequenceIndex;
import org.onebusaway.transit_data_federation.services.blocks.BlockStatusService;
import org.onebusaway.transit_data_federation.services.blocks.InstanceState;
import org.onebusaway.transit_data_federation.services.blocks.ServiceIntervalBlock;
import org.onebusaway.transit_data_federation.services.realtime.BlockLocation;
import org.onebusaway.transit_data_federation.services.realtime.BlockLocationService;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockConfigurationEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.FrequencyEntry;
import org.onebusaway.util.SystemTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BlockStatusServiceImpl
implements BlockStatusService {
    private BlockCalendarService _blockCalendarService;
    private BlockLocationService _blockLocationService;
    private BlockGeospatialService _blockGeospatialService;
    private ExtendedCalendarService _extendedCalendarService;
    private int _runningLateWindow = 1800;
    private int _runningEarlyWindow = 600;

    @Autowired
    public void setActive(BlockCalendarService activeCalendarService) {
        this._blockCalendarService = activeCalendarService;
    }

    @Autowired
    public void setBlockLocationService(BlockLocationService blockLocationService) {
        this._blockLocationService = blockLocationService;
    }

    @Autowired
    public void setBlockGeospatialService(BlockGeospatialService blockGeospatialService) {
        this._blockGeospatialService = blockGeospatialService;
    }

    @Autowired
    public void setExtendedCalendarService(ExtendedCalendarService extendedCalendarSerivce) {
        this._extendedCalendarService = extendedCalendarSerivce;
    }

    @ConfigurationParameter
    public void setRunningLateWindow(int runningLateWindowInSeconds) {
        this._runningLateWindow = runningLateWindowInSeconds;
    }

    @Override
    public int getRunningLateWindow() {
        return this._runningLateWindow;
    }

    @ConfigurationParameter
    public void setRunningEarlyWindow(int runningEarlyWindowInSeconds) {
        this._runningEarlyWindow = runningEarlyWindowInSeconds;
    }

    @Override
    public int getRunningEarlyWindow() {
        return this._runningEarlyWindow;
    }

    @Override
    public Map<BlockInstance, List<BlockLocation>> getBlocks(AgencyAndId blockId, long serviceDate, AgencyAndId vehicleId, long time) {
        List<BlockInstance> blockInstances = this.getBlockInstances(blockId, serviceDate, time);
        HashMap<BlockInstance, List<BlockLocation>> results = new HashMap<BlockInstance, List<BlockLocation>>();
        for (BlockInstance blockInstance : blockInstances) {
            ArrayList<BlockLocation> locations = new ArrayList<BlockLocation>();
            this.computeLocations(blockInstance, vehicleId, time, locations);
            results.put(blockInstance, locations);
        }
        return results;
    }

    @Override
    public BlockLocation getBlockForVehicle(AgencyAndId vehicleId, long time) {
        TargetTime target = new TargetTime(time, time);
        return this._blockLocationService.getLocationForVehicleAndTime(vehicleId, target);
    }

    @Override
    public List<BlockLocation> getAllActiveBlocks(long time) {
        List<BlockInstance> instances = this._blockCalendarService.getActiveBlocksInTimeRange(time, time);
        return this.getAsLocations(instances, time);
    }

    @Override
    public List<BlockLocation> getActiveBlocksForAgency(String agencyId, long time) {
        List<BlockInstance> instances = this._blockCalendarService.getActiveBlocksForAgencyInTimeRange(agencyId, time, time);
        return this.getAsLocations(instances, time);
    }

    @Override
    public List<BlockLocation> getBlocksForRoute(AgencyAndId routeId, long time) {
        long timeFrom = time - (long)(this._runningLateWindow * 1000);
        long timeTo = time + (long)(this._runningEarlyWindow * 1000);
        List<BlockInstance> instances = this._blockCalendarService.getActiveBlocksForRouteInTimeRange(routeId, timeFrom, timeTo);
        return this.getAsLocations(instances, time);
    }

    @Override
    public List<BlockLocation> getBlocksForBounds(CoordinateBounds bounds, long time) {
        long timeFrom = time - (long)(this._runningLateWindow * 1000);
        long timeTo = time + (long)(this._runningEarlyWindow * 1000);
        List<BlockInstance> instances = this._blockGeospatialService.getActiveScheduledBlocksPassingThroughBounds(bounds, timeFrom, timeTo);
        List<BlockLocation> locations = this.getAsLocations(instances, time);
        ArrayList<BlockLocation> inRange = new ArrayList<BlockLocation>();
        for (BlockLocation location : locations) {
            CoordinatePoint p = location.getLocation();
            if (p == null || !bounds.contains(p)) continue;
            inRange.add(location);
        }
        return inRange;
    }

    @Override
    public Map<BlockInstance, List<List<BlockLocation>>> getBlocksForIndex(BlockSequenceIndex index, List<Date> timestamps) {
        List<BlockInstance> instances = this.getBlockInstancesForIndexAndTimestamps(index, timestamps);
        HashMap<BlockInstance, List<List<BlockLocation>>> results = new HashMap<BlockInstance, List<List<BlockLocation>>>();
        for (BlockInstance instance : instances) {
            this.getBlockLocationsForInstanceAndTimestamps(instance, timestamps, results);
        }
        return results;
    }

    private List<BlockInstance> getBlockInstances(AgencyAndId blockId, long serviceDate, long time) {
        if (serviceDate != 0L) {
            BlockInstance blockInstance = this._blockCalendarService.getBlockInstance(blockId, serviceDate);
            if (blockInstance == null) {
                return Collections.emptyList();
            }
            BlockConfigurationEntry blockConfig = blockInstance.getBlock();
            if (blockConfig.getFrequencies() == null) {
                return Arrays.asList(blockInstance);
            }
            ArrayList<BlockInstance> instances = new ArrayList<BlockInstance>();
            for (FrequencyEntry frequency : blockConfig.getFrequencies()) {
                instances.add(new BlockInstance(blockConfig, blockInstance.getServiceDate(), frequency));
            }
            return instances;
        }
        List<BlockInstance> instances = this._blockCalendarService.getActiveBlocks(blockId, time, time);
        if (instances.isEmpty()) {
            instances = this._blockCalendarService.getClosestActiveBlocks(blockId, time);
        }
        return instances;
    }

    private List<BlockLocation> getAsLocations(Iterable<BlockInstance> instances, long time) {
        ArrayList<BlockLocation> locations = new ArrayList<BlockLocation>();
        for (BlockInstance instance : instances) {
            this.computeLocations(instance, null, time, locations);
        }
        return locations;
    }

    private void computeLocations(BlockInstance instance, AgencyAndId vehicleId, long time, List<BlockLocation> results) {
        BlockLocation location;
        if (instance == null) {
            return;
        }
        TargetTime target = new TargetTime(time, time);
        List<BlockLocation> locations = this._blockLocationService.getLocationsForBlockInstance(instance, target);
        if (!locations.isEmpty()) {
            if (vehicleId == null) {
                results.addAll(locations);
            } else {
                for (BlockLocation location2 : locations) {
                    if (!vehicleId.equals((Object)location2.getVehicleId())) continue;
                    results.add(location2);
                }
            }
        } else if (vehicleId == null && (location = this._blockLocationService.getScheduledLocationForBlockInstance(instance, time)) != null && location.isInService()) {
            results.add(location);
        }
    }

    private List<BlockInstance> getBlockInstancesForIndexAndTimestamps(BlockSequenceIndex index, List<Date> timestamps) {
        Date tFrom = timestamps.get(0);
        Date tTo = timestamps.get(timestamps.size() - 1);
        ServiceIntervalBlock serviceIntervalBlock = index.getServiceIntervalBlock();
        List<BlockSequence> sequences = index.getSequences();
        Collection<Date> serviceDates = this._extendedCalendarService.getServiceDatesWithinRange(index.getServiceIds(), serviceIntervalBlock.getRange(), tFrom, tTo);
        ArrayList<BlockInstance> instances = new ArrayList<BlockInstance>();
        for (Date serviceDate : serviceDates) {
            int effectiveFromTime = (int)((tFrom.getTime() - serviceDate.getTime()) / 1000L);
            int effectiveToTime = (int)((tTo.getTime() - serviceDate.getTime()) / 1000L);
            int indexFrom = Arrays.binarySearch(serviceIntervalBlock.getMaxArrivals(), effectiveFromTime);
            int indexTo = Arrays.binarySearch(serviceIntervalBlock.getMinDepartures(), effectiveToTime);
            if (indexFrom < 0) {
                indexFrom = -(indexFrom + 1);
            }
            if (indexTo < 0) {
                indexTo = -(indexTo + 1);
            }
            InstanceState state = new InstanceState(serviceDate.getTime());
            for (int i = indexFrom; i < indexTo; ++i) {
                BlockSequence sequence = sequences.get(i);
                BlockConfigurationEntry blockConfig = sequence.getBlockConfig();
                BlockInstance instance = new BlockInstance(blockConfig, state);
                instances.add(instance);
            }
        }
        return instances;
    }

    private void getBlockLocationsForInstanceAndTimestamps(BlockInstance instance, List<Date> timestamps, Map<BlockInstance, List<List<BlockLocation>>> results) {
        Map<AgencyAndId, List<BlockLocation>> locations = this._blockLocationService.getLocationsForBlockInstance(instance, timestamps, SystemTime.currentTimeMillis());
        if (locations.isEmpty()) {
            List empty = Collections.emptyList();
            results.put(instance, empty);
        } else {
            ArrayList<List<BlockLocation>> asList = new ArrayList<List<BlockLocation>>(locations.values());
            results.put(instance, asList);
        }
    }
}

