/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.beans;

import java.util.ArrayList;
import java.util.List;
import org.onebusaway.collections.CollectionsLibrary;
import org.onebusaway.geospatial.model.CoordinatePoint;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.realtime.api.EVehiclePhase;
import org.onebusaway.realtime.api.VehicleLocationListener;
import org.onebusaway.realtime.api.VehicleLocationRecord;
import org.onebusaway.transit_data.model.ListBean;
import org.onebusaway.transit_data.model.VehicleStatusBean;
import org.onebusaway.transit_data.model.realtime.VehicleLocationRecordBean;
import org.onebusaway.transit_data.model.realtime.VehicleLocationRecordQueryBean;
import org.onebusaway.transit_data.model.trips.TripDetailsBean;
import org.onebusaway.transit_data.model.trips.TripDetailsInclusionBean;
import org.onebusaway.transit_data_federation.impl.realtime.BlockLocationRecord;
import org.onebusaway.transit_data_federation.impl.realtime.BlockLocationRecordDao;
import org.onebusaway.transit_data_federation.model.TargetTime;
import org.onebusaway.transit_data_federation.services.beans.TripDetailsBeanService;
import org.onebusaway.transit_data_federation.services.beans.VehicleStatusBeanService;
import org.onebusaway.transit_data_federation.services.realtime.BlockLocation;
import org.onebusaway.transit_data_federation.services.realtime.BlockLocationService;
import org.onebusaway.transit_data_federation.services.realtime.VehicleStatus;
import org.onebusaway.transit_data_federation.services.realtime.VehicleStatusService;
import org.onebusaway.util.AgencyAndIdLibrary;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
class VehicleStatusBeanServiceImpl
implements VehicleStatusBeanService {
    private VehicleStatusService _vehicleStatusService;
    private TripDetailsBeanService _tripDetailsBeanService;
    private BlockLocationRecordDao _blockLocationRecordDao;
    private VehicleLocationListener _vehicleLocationListener;
    private BlockLocationService _blockLocationService;

    VehicleStatusBeanServiceImpl() {
    }

    @Autowired
    public void setVehicleStatusService(VehicleStatusService vehicleStatusService) {
        this._vehicleStatusService = vehicleStatusService;
    }

    @Autowired
    public void setTripDetailsBeanService(TripDetailsBeanService tripDetailsBeanService) {
        this._tripDetailsBeanService = tripDetailsBeanService;
    }

    @Autowired
    public void setBlockLocationRecordDao(BlockLocationRecordDao blockLocationRecordDao) {
        this._blockLocationRecordDao = blockLocationRecordDao;
    }

    @Autowired
    @Qualifier(value="vehicleStatusServiceImpl")
    public void setVehicleLocationListener(VehicleLocationListener vehicleLocationListener) {
        this._vehicleLocationListener = vehicleLocationListener;
    }

    @Autowired
    public void setBlockLocationService(BlockLocationService blockLocationService) {
        this._blockLocationService = blockLocationService;
    }

    @Override
    public VehicleStatusBean getVehicleForId(AgencyAndId vehicleId, long time) {
        VehicleStatus status = this._vehicleStatusService.getVehicleStatusForId(vehicleId);
        if (status == null) {
            return null;
        }
        return this.getStatusAsBean(status, time);
    }

    @Override
    public ListBean<VehicleStatusBean> getFilteredVehiclesForAgency(String agencyId, long time, Integer ageInSeconds) {
        return this.getAllVehiclesForAgency(agencyId, time, ageInSeconds);
    }

    @Override
    public ListBean<VehicleStatusBean> getAllVehiclesForAgency(String agencyId, long time) {
        return this.getAllVehiclesForAgency(agencyId, time, null);
    }

    private ListBean<VehicleStatusBean> getAllVehiclesForAgency(String agencyId, long time, Integer ageInSeconds) {
        List<VehicleStatus> statuses = this._vehicleStatusService.getAllVehicleStatuses();
        ArrayList<VehicleStatusBean> beans = new ArrayList<VehicleStatusBean>();
        for (VehicleStatus status : statuses) {
            VehicleStatusBean bean;
            AgencyAndId vid = status.getVehicleId();
            if (!vid.getAgencyId().equals(agencyId) || !this.isActive(bean = this.getStatusAsBean(status, time), time, ageInSeconds)) continue;
            beans.add(bean);
        }
        return new ListBean(beans, false);
    }

    @Override
    public VehicleLocationRecordBean getVehicleLocationRecordForVehicleId(AgencyAndId vehicleId, long targetTime) {
        TargetTime target = new TargetTime(targetTime, targetTime);
        BlockLocation blockLocation = this._blockLocationService.getLocationForVehicleAndTime(vehicleId, target);
        if (blockLocation == null) {
            return null;
        }
        return this.getBlockLocationAsVehicleLocationRecord(blockLocation);
    }

    @Override
    public VehicleLocationRecordBean getVehiclePositionForVehicleId(AgencyAndId vehicleId) {
        VehicleLocationRecord record = this._vehicleStatusService.getRawPosition(vehicleId);
        if (record == null) {
            return null;
        }
        VehicleLocationRecordBean bean = new VehicleLocationRecordBean();
        bean.setTimeOfLocationUpdate(record.getTimeOfLocationUpdate());
        bean.setTimeOfRecord(record.getTimeOfRecord());
        bean.setCurrentLocation(new CoordinatePoint(record.getCurrentLocationLat(), record.getCurrentLocationLon()));
        bean.setCurrentOrientation(record.getCurrentOrientation());
        bean.setDistanceAlongBlock(record.getDistanceAlongBlock());
        bean.setScheduleDeviation(record.getScheduleDeviation());
        return bean;
    }

    @Override
    public ListBean<VehicleLocationRecordBean> getVehicleLocations(VehicleLocationRecordQueryBean query) {
        AgencyAndId blockId = AgencyAndIdLibrary.convertFromString((String)query.getBlockId());
        AgencyAndId tripId = AgencyAndIdLibrary.convertFromString((String)query.getTripId());
        AgencyAndId vehicleId = AgencyAndIdLibrary.convertFromString((String)query.getVehicleId());
        List<BlockLocationRecord> records = this._blockLocationRecordDao.getBlockLocationRecords(blockId, tripId, vehicleId, query.getServiceDate(), query.getFromTime(), query.getToTime(), 1000);
        ArrayList<VehicleLocationRecordBean> beans = new ArrayList<VehicleLocationRecordBean>(records.size());
        for (BlockLocationRecord record : records) {
            VehicleLocationRecordBean bean = this.getBlockLocationRecordAsVehicleLocationRecord(record);
            beans.add(bean);
        }
        return new ListBean(beans, false);
    }

    @Override
    public void submitVehicleLocation(VehicleLocationRecordBean bean) {
        VehicleLocationRecord r = new VehicleLocationRecord();
        r.setTimeOfRecord(bean.getTimeOfRecord());
        r.setTimeOfLocationUpdate(bean.getTimeOfLocationUpdate());
        r.setServiceDate(bean.getServiceDate());
        r.setBlockId(AgencyAndIdLibrary.convertFromString((String)bean.getBlockId()));
        r.setTripId(AgencyAndIdLibrary.convertFromString((String)bean.getTripId()));
        r.setVehicleId(AgencyAndIdLibrary.convertFromString((String)bean.getVehicleId()));
        if (bean.getPhase() != null) {
            r.setPhase(EVehiclePhase.valueOf((String)bean.getPhase().toUpperCase()));
        }
        r.setStatus(bean.getStatus());
        CoordinatePoint p = bean.getCurrentLocation();
        if (p != null) {
            r.setCurrentLocationLat(p.getLat());
            r.setCurrentLocationLon(p.getLon());
        }
        if (bean.isCurrentOrientationSet()) {
            r.setCurrentOrientation(bean.getCurrentOrientation());
        }
        if (bean.isDistanceAlongBlockSet()) {
            r.setDistanceAlongBlock(bean.getDistanceAlongBlock());
        }
        if (bean.isScheduleDeviationSet()) {
            r.setScheduleDeviation(bean.getScheduleDeviation());
        }
        this._vehicleLocationListener.handleVehicleLocationRecord(r);
    }

    @Override
    public void resetVehicleLocation(AgencyAndId vehicleId) {
        this._vehicleLocationListener.resetVehicleLocation(vehicleId);
    }

    private VehicleStatusBean getStatusAsBean(VehicleStatus status, long time) {
        List<VehicleLocationRecord> allRecords;
        VehicleLocationRecord record = status.getRecord();
        VehicleStatusBean bean = new VehicleStatusBean();
        bean.setLastUpdateTime(record.getTimeOfRecord());
        bean.setLastLocationUpdateTime(record.getTimeOfLocationUpdate());
        EVehiclePhase phase = record.getPhase();
        if (phase != null) {
            bean.setPhase(phase.toLabel());
        }
        bean.setStatus(record.getStatus());
        if (record.isCurrentLocationSet()) {
            bean.setLocation(new CoordinatePoint(record.getCurrentLocationLat(), record.getCurrentLocationLon()));
        }
        bean.setVehicleId(AgencyAndIdLibrary.convertToString((AgencyAndId)record.getVehicleId()));
        TripDetailsBean details = this._tripDetailsBeanService.getTripForVehicle(record.getVehicleId(), time, new TripDetailsInclusionBean(true, false, true));
        if (details != null && details.getStatus() != null) {
            bean.setTrip(details.getTrip());
            bean.setTripStatus(details.getStatus());
        }
        if (!CollectionsLibrary.isEmpty(allRecords = status.getAllRecords())) {
            ArrayList<VehicleLocationRecordBean> allRecordBeans = new ArrayList<VehicleLocationRecordBean>();
            bean.setAllRecords(allRecordBeans);
            for (VehicleLocationRecord r : allRecords) {
                VehicleLocationRecordBean rBean = this.getVehicleLocationRecordAsBean(r);
                allRecordBeans.add(rBean);
            }
        }
        if (status.getOccupancyRecord() != null) {
            bean.setOccupancyStatus(status.getOccupancyRecord().getOccupancyStatus());
            bean.setOccupancyCount(status.getOccupancyRecord().getRawCount());
            bean.setOccupancyCapacity(status.getOccupancyRecord().getCapacity());
        }
        return bean;
    }

    private VehicleLocationRecordBean getVehicleLocationRecordAsBean(VehicleLocationRecord record) {
        VehicleLocationRecordBean bean = new VehicleLocationRecordBean();
        bean.setBlockId(AgencyAndIdLibrary.convertToString((AgencyAndId)record.getBlockId()));
        if (record.getPhase() != null) {
            bean.setPhase(record.getPhase().toLabel());
        }
        if (record.isCurrentLocationSet()) {
            CoordinatePoint location = new CoordinatePoint(record.getCurrentLocationLat(), record.getCurrentLocationLon());
            bean.setCurrentLocation(location);
        }
        if (record.isCurrentOrientationSet()) {
            bean.setCurrentOrientation(record.getCurrentOrientation());
        }
        if (record.isDistanceAlongBlockSet()) {
            bean.setDistanceAlongBlock(record.getDistanceAlongBlock());
        }
        if (record.isScheduleDeviationSet()) {
            bean.setScheduleDeviation(record.getScheduleDeviation());
        }
        bean.setStatus(record.getStatus());
        bean.setServiceDate(record.getServiceDate());
        bean.setTimeOfRecord(record.getTimeOfRecord());
        bean.setTripId(AgencyAndIdLibrary.convertToString((AgencyAndId)record.getTripId()));
        bean.setVehicleId(AgencyAndIdLibrary.convertToString((AgencyAndId)record.getVehicleId()));
        return bean;
    }

    private VehicleLocationRecordBean getBlockLocationRecordAsVehicleLocationRecord(BlockLocationRecord record) {
        CoordinatePoint location;
        VehicleLocationRecordBean bean = new VehicleLocationRecordBean();
        bean.setBlockId(AgencyAndIdLibrary.convertToString((AgencyAndId)record.getBlockId()));
        if (record.getPhase() != null) {
            bean.setPhase(record.getPhase().toLabel());
        }
        if ((location = record.getLocation()) != null) {
            bean.setCurrentLocation(location);
        }
        if (record.getOrientation() != null) {
            bean.setCurrentOrientation(record.getOrientation().doubleValue());
        }
        if (record.getDistanceAlongBlock() != null) {
            bean.setDistanceAlongBlock(record.getDistanceAlongBlock().doubleValue());
        }
        if (record.getScheduleDeviation() != null) {
            bean.setScheduleDeviation(record.getScheduleDeviation().doubleValue());
        }
        bean.setStatus(record.getStatus());
        bean.setServiceDate(record.getServiceDate());
        bean.setTimeOfRecord(record.getTime());
        bean.setTripId(AgencyAndIdLibrary.convertToString((AgencyAndId)record.getTripId()));
        bean.setVehicleId(AgencyAndIdLibrary.convertToString((AgencyAndId)record.getVehicleId()));
        return bean;
    }

    private VehicleLocationRecordBean getBlockLocationAsVehicleLocationRecord(BlockLocation record) {
        CoordinatePoint location;
        VehicleLocationRecordBean bean = new VehicleLocationRecordBean();
        bean.setBlockId(AgencyAndIdLibrary.convertToString((AgencyAndId)record.getBlockInstance().getBlock().getBlock().getId()));
        if (record.getPhase() != null) {
            bean.setPhase(record.getPhase().toLabel());
        }
        if ((location = record.getLocation()) != null) {
            bean.setCurrentLocation(location);
        }
        if (record.isOrientationSet()) {
            bean.setCurrentOrientation(record.getOrientation());
        }
        if (record.isDistanceAlongBlockSet()) {
            bean.setDistanceAlongBlock(record.getDistanceAlongBlock());
        }
        if (record.isScheduleDeviationSet()) {
            bean.setScheduleDeviation(record.getScheduleDeviation());
        }
        bean.setStatus(record.getStatus());
        bean.setServiceDate(record.getBlockInstance().getServiceDate());
        bean.setTimeOfRecord(record.getLastUpdateTime());
        bean.setTimeOfLocationUpdate(record.getLastLocationUpdateTime());
        bean.setTripId(AgencyAndIdLibrary.convertToString((AgencyAndId)record.getActiveTrip().getTrip().getId()));
        bean.setVehicleId(AgencyAndIdLibrary.convertToString((AgencyAndId)record.getVehicleId()));
        return bean;
    }

    private boolean isActive(VehicleStatusBean bean, long time, Integer ageInSeconds) {
        if (ageInSeconds == null) {
            return true;
        }
        return bean.getLastUpdateTime() > time - (long)(ageInSeconds * 1000);
    }
}

