/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.beans;

import java.util.List;
import java.util.TimeZone;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.realtime.api.OccupancyStatus;
import org.onebusaway.transit_data.model.StopBean;
import org.onebusaway.transit_data.model.TripStopTimeBean;
import org.onebusaway.transit_data.model.TripStopTimesBean;
import org.onebusaway.transit_data.model.schedule.FrequencyBean;
import org.onebusaway.transit_data.model.trips.TripBean;
import org.onebusaway.transit_data_federation.impl.beans.FrequencyBeanLibrary;
import org.onebusaway.transit_data_federation.model.bundle.HistoricalRidership;
import org.onebusaway.transit_data_federation.model.narrative.StopTimeNarrative;
import org.onebusaway.transit_data_federation.services.AgencyService;
import org.onebusaway.transit_data_federation.services.RidershipService;
import org.onebusaway.transit_data_federation.services.beans.StopBeanService;
import org.onebusaway.transit_data_federation.services.beans.TripBeanService;
import org.onebusaway.transit_data_federation.services.beans.TripStopTimesBeanService;
import org.onebusaway.transit_data_federation.services.blocks.BlockTripInstance;
import org.onebusaway.transit_data_federation.services.narrative.NarrativeService;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockTripEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.FrequencyEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.StopEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.StopTimeEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.TripEntry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TripStopTimesBeanServiceImpl
implements TripStopTimesBeanService {
    private TripBeanService _tripBeanService;
    private StopBeanService _stopBeanService;
    private AgencyService _agencyService;
    private RidershipService _ridershipService;
    private NarrativeService _narrativeService;

    @Autowired
    public void setAgencyService(AgencyService agencyService) {
        this._agencyService = agencyService;
    }

    @Autowired
    public void setTripBeanService(TripBeanService tripBeanService) {
        this._tripBeanService = tripBeanService;
    }

    @Autowired
    public void setStopBeanService(StopBeanService stopBeanService) {
        this._stopBeanService = stopBeanService;
    }

    @Autowired
    public void setOccupancyService(RidershipService ridershipService) {
        this._ridershipService = ridershipService;
    }

    @Autowired
    public void setNarrativeService(NarrativeService narrativeService) {
        this._narrativeService = narrativeService;
    }

    @Override
    public TripStopTimesBean getStopTimesForBlockTrip(BlockTripInstance blockTripInstance) {
        FrequencyEntry frequencyLabel;
        BlockTripEntry blockTrip = blockTripInstance.getBlockTrip();
        TripStopTimesBean bean = this.getStopTimesForTrip(blockTrip.getTrip(), blockTripInstance.getServiceDate());
        if (blockTrip.getPreviousTrip() != null) {
            BlockTripEntry previous = blockTrip.getPreviousTrip();
            TripBean previousTrip = this._tripBeanService.getTripForId(previous.getTrip().getId());
            bean.setPreviousTrip(previousTrip);
        }
        if (blockTrip.getNextTrip() != null) {
            BlockTripEntry next = blockTrip.getNextTrip();
            TripBean nextTrip = this._tripBeanService.getTripForId(next.getTrip().getId());
            bean.setNextTrip(nextTrip);
        }
        if ((frequencyLabel = blockTripInstance.getFrequencyLabel()) != null) {
            long serviceDate = blockTripInstance.getServiceDate();
            FrequencyBean fb = FrequencyBeanLibrary.getBeanForFrequency(serviceDate, frequencyLabel);
            bean.setFrequency(fb);
        }
        for (TripStopTimeBean st : bean.getStopTimes()) {
            List<HistoricalRidership> rid = this._ridershipService.getHistoricalRiderships(blockTrip.getTrip().getRoute().getId(), blockTrip.getTrip().getId(), AgencyAndId.convertFromString((String)st.getStop().getId()), blockTripInstance.getServiceDate());
            if (rid == null || rid.size() <= 0) continue;
            st.setHistoricalOccupancy(OccupancyStatus.toEnum((double)rid.get(0).getLoadFactor()));
        }
        return bean;
    }

    private TripStopTimesBean getStopTimesForTrip(TripEntry trip, long serviceDate) {
        AgencyAndId tripId = trip.getId();
        TripStopTimesBean bean = new TripStopTimesBean();
        TimeZone tz = this._agencyService.getTimeZoneForAgencyId(tripId.getAgencyId());
        bean.setTimeZone(tz.getID());
        for (StopTimeEntry stopTime : trip.getStopTimes()) {
            List<HistoricalRidership> rid;
            TripStopTimeBean stBean = new TripStopTimeBean();
            stBean.setArrivalTime(stopTime.getArrivalTime());
            stBean.setDepartureTime(stopTime.getDepartureTime());
            StopEntry stopEntry = stopTime.getStop();
            StopBean stopBean = this._stopBeanService.getStopForId(stopEntry.getId(), null);
            stBean.setStop(stopBean);
            stBean.setDistanceAlongTrip(stopTime.getShapeDistTraveled());
            stBean.setGtfsSequence(stopTime.getGtfsSequence());
            StopTimeNarrative stopTimeNarrative = this._narrativeService.getStopTimeNarrativeForPattern(trip.getRoute().getId(), stopTime.getStop().getId(), trip.getDirectionId());
            if (stopTimeNarrative != null) {
                stBean.setStopHeadsign(stopTimeNarrative.getStopHeadsign());
            }
            if ((rid = this._ridershipService.getHistoricalRiderships(trip.getRoute().getId(), trip.getId(), stopEntry.getId(), serviceDate)) != null && rid.size() > 0) {
                stBean.setHistoricalOccupancy(OccupancyStatus.toEnum((double)rid.get(0).getLoadFactor()));
            }
            bean.addStopTime(stBean);
        }
        return bean;
    }
}

