/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.beans;

import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.transit_data.model.RouteBean;
import org.onebusaway.transit_data.model.trips.TripBean;
import org.onebusaway.transit_data_federation.impl.beans.ApplicationBeanLibrary;
import org.onebusaway.transit_data_federation.model.narrative.TripNarrative;
import org.onebusaway.transit_data_federation.model.transit_graph.DynamicGraph;
import org.onebusaway.transit_data_federation.services.beans.RouteBeanService;
import org.onebusaway.transit_data_federation.services.beans.TripBeanService;
import org.onebusaway.transit_data_federation.services.narrative.NarrativeService;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.TransitGraphDao;
import org.onebusaway.transit_data_federation.services.transit_graph.TripEntry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TripBeanServiceImpl
implements TripBeanService {
    private TransitGraphDao _graph;
    private DynamicGraph _dynamicGraph;
    private NarrativeService _narrativeService;
    private RouteBeanService _routeBeanService;

    @Autowired
    public void setTransitGraphDao(TransitGraphDao graph) {
        this._graph = graph;
    }

    @Autowired
    public void setDynamicGraph(DynamicGraph dynamicGraph) {
        this._dynamicGraph = dynamicGraph;
    }

    @Autowired
    public void setNarrativeService(NarrativeService narrativeService) {
        this._narrativeService = narrativeService;
    }

    @Autowired
    public void setRouteBeanService(RouteBeanService routeBeanService) {
        this._routeBeanService = routeBeanService;
    }

    @Override
    public TripBean getTripForId(AgencyAndId tripId) {
        TripEntry tripEntry = this._graph.getTripEntryForId(tripId);
        if (tripEntry == null) {
            tripEntry = this._dynamicGraph.getTripEntryForId(tripId);
        }
        if (tripEntry == null) {
            return null;
        }
        AgencyAndId routeId = tripEntry.getRouteCollection().getId();
        RouteBean routeBean = this._routeBeanService.getRouteForId(routeId);
        TripNarrative tripNarrative = this._narrativeService.getTripForId(tripId);
        if (tripNarrative == null) {
            return null;
        }
        TripBean tripBean = new TripBean();
        tripBean.setId(ApplicationBeanLibrary.getId(tripId));
        tripBean.setTripShortName(tripNarrative.getTripShortName());
        tripBean.setTripHeadsign(tripNarrative.getTripHeadsign());
        tripBean.setRoute(routeBean);
        tripBean.setRouteShortName(tripNarrative.getRouteShortName());
        tripBean.setServiceId(ApplicationBeanLibrary.getId(tripEntry.getServiceId().getId()));
        AgencyAndId shapeId = tripEntry.getShapeId();
        if (shapeId != null && shapeId.hasValues()) {
            tripBean.setShapeId(ApplicationBeanLibrary.getId(shapeId));
        }
        tripBean.setDirectionId(tripEntry.getDirectionId());
        tripBean.setTotalTripDistance(tripEntry.getTotalTripDistance());
        tripBean.setPeakOffpeak(tripNarrative.getPeakOffpeak());
        BlockEntry block = tripEntry.getBlock();
        tripBean.setBlockId(ApplicationBeanLibrary.getId(block.getId()));
        return tripBean;
    }
}

