/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.beans;

import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.transit_data.model.StopBean;
import org.onebusaway.transit_data.model.StopTimeInstanceBean;
import org.onebusaway.transit_data.model.schedule.StopTimeBean;
import org.onebusaway.transit_data_federation.model.StopTimeInstance;
import org.onebusaway.transit_data_federation.services.beans.StopBeanService;
import org.onebusaway.transit_data_federation.services.beans.StopTimeBeanService;
import org.onebusaway.transit_data_federation.services.transit_graph.StopTimeEntry;
import org.onebusaway.util.AgencyAndIdLibrary;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class StopTimeBeanServiceImpl
implements StopTimeBeanService {
    private StopBeanService _stopBeanService;

    StopTimeBeanServiceImpl() {
    }

    @Autowired
    public void setStopBeanService(StopBeanService stopBeanService) {
        this._stopBeanService = stopBeanService;
    }

    @Override
    public StopTimeBean getStopTimeAsBean(StopTimeEntry stopTime) {
        StopTimeBean bean = new StopTimeBean();
        bean.setArrivalTime(stopTime.getArrivalTime());
        bean.setDepartureTime(stopTime.getDepartureTime());
        bean.setDropOffType(stopTime.getDropOffType());
        bean.setPickupType(stopTime.getPickupType());
        StopBean stopBean = this._stopBeanService.getStopForId(stopTime.getStop().getId(), null);
        bean.setStop(stopBean);
        return bean;
    }

    @Override
    public StopTimeInstanceBean getStopTimeInstanceAsBean(StopTimeInstance instance) {
        StopTimeInstanceBean bean = new StopTimeInstanceBean();
        bean.setArrivalTime(instance.getArrivalTime());
        bean.setDepartureTime(instance.getDepartureTime());
        bean.setServiceDate(instance.getServiceDate());
        bean.setTripId(AgencyAndIdLibrary.convertToString((AgencyAndId)instance.getTrip().getTrip().getId()));
        return bean;
    }
}

