/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.beans;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.onebusaway.container.cache.Cacheable;
import org.onebusaway.geospatial.model.CoordinatePoint;
import org.onebusaway.geospatial.model.EncodedPolylineBean;
import org.onebusaway.geospatial.services.PolylineEncoder;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.transit_data.model.ListBean;
import org.onebusaway.transit_data_federation.model.ShapePoints;
import org.onebusaway.transit_data_federation.services.beans.ShapeBeanService;
import org.onebusaway.transit_data_federation.services.shapes.ShapePointService;
import org.onebusaway.transit_data_federation.services.transit_graph.TransitGraphDao;
import org.onebusaway.transit_data_federation.services.transit_graph.TripEntry;
import org.onebusaway.util.AgencyAndIdLibrary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class ShapeBeanServiceImpl
implements ShapeBeanService {
    private static Logger _log = LoggerFactory.getLogger(ShapeBeanServiceImpl.class);
    private ShapePointService _shapePointService;
    private TransitGraphDao _transitGraphDao;

    ShapeBeanServiceImpl() {
    }

    @Autowired
    public void setShapePointService(ShapePointService shapePointService) {
        this._shapePointService = shapePointService;
    }

    @Autowired
    public void setTransitGraphDao(TransitGraphDao transitGraphDao) {
        this._transitGraphDao = transitGraphDao;
    }

    @Override
    @Cacheable
    public EncodedPolylineBean getPolylineForShapeId(AgencyAndId id) {
        ShapePoints shapePoints = this._shapePointService.getShapePointsForShapeId(id);
        if (shapePoints == null) {
            return null;
        }
        return PolylineEncoder.createEncodings((double[])shapePoints.getLats(), (double[])shapePoints.getLons(), (int)-1);
    }

    @Override
    @Cacheable
    public List<EncodedPolylineBean> getMergedPolylinesForShapeIds(Collection<AgencyAndId> shapeIds) {
        ArrayList<EncodedPolylineBean> polylines = new ArrayList<EncodedPolylineBean>();
        if (shapeIds.isEmpty()) {
            return polylines;
        }
        ArrayList<CoordinatePoint> currentLine = new ArrayList<CoordinatePoint>();
        HashSet<Edge> edges = new HashSet<Edge>();
        for (AgencyAndId shapeId : shapeIds) {
            ShapePoints shapePoints = this._shapePointService.getShapePointsForShapeId(shapeId);
            if (shapePoints == null) {
                _log.warn("no shape points for shapeId=" + shapeId);
                continue;
            }
            double[] lats = shapePoints.getLats();
            double[] lons = shapePoints.getLons();
            CoordinatePoint prev = null;
            for (int i = 0; i < shapePoints.getSize(); ++i) {
                Edge edge;
                CoordinatePoint loc = new CoordinatePoint(lats[i], lons[i]);
                if (prev != null && !prev.equals((Object)loc) && !edges.add(edge = new Edge(prev, loc))) {
                    if (currentLine.size() > 1) {
                        polylines.add(PolylineEncoder.createEncodings(currentLine));
                    }
                    currentLine.clear();
                }
                if (prev == null || !prev.equals((Object)loc)) {
                    currentLine.add(loc);
                }
                prev = loc;
            }
            if (currentLine.size() > 1) {
                polylines.add(PolylineEncoder.createEncodings(currentLine));
            }
            currentLine.clear();
        }
        return polylines;
    }

    @Override
    public ListBean<String> getShapeIdsForAgencyId(String agencyId) {
        HashSet<AgencyAndId> shapeIds = new HashSet<AgencyAndId>();
        for (TripEntry trip : this._transitGraphDao.getAllTrips()) {
            AgencyAndId shapeId = trip.getShapeId();
            if (shapeId == null || !shapeId.hasValues() || !shapeId.getAgencyId().equals(agencyId)) continue;
            shapeIds.add(shapeId);
        }
        ArrayList<String> ids = new ArrayList<String>();
        for (AgencyAndId shapeId : shapeIds) {
            String id = AgencyAndIdLibrary.convertToString((AgencyAndId)shapeId);
            ids.add(id);
        }
        Collections.sort(ids);
        return new ListBean(ids, false);
    }

    private static int compare(CoordinatePoint a, CoordinatePoint b) {
        int rc = Double.compare(a.getLat(), b.getLat());
        if (rc == 0) {
            rc = Double.compare(a.getLon(), b.getLon());
        }
        return rc;
    }

    private static class Edge {
        private final CoordinatePoint _a;
        private final CoordinatePoint _b;

        public Edge(CoordinatePoint a, CoordinatePoint b) {
            int rc = ShapeBeanServiceImpl.compare(a, b);
            if (rc <= 0) {
                this._a = a;
                this._b = b;
            } else {
                this._a = b;
                this._b = a;
            }
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._a == null ? 0 : this._a.hashCode());
            result = 31 * result + (this._b == null ? 0 : this._b.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Edge other = (Edge)obj;
            if (this._a == null ? other._a != null : !this._a.equals((Object)other._a)) {
                return false;
            }
            return !(this._b == null ? other._b != null : !this._b.equals((Object)other._b));
        }
    }
}

