/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.beans;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import org.onebusaway.container.cache.Cacheable;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.calendar.AgencyServiceInterval;
import org.onebusaway.gtfs.model.calendar.ServiceDate;
import org.onebusaway.transit_data.model.AgencyBean;
import org.onebusaway.transit_data.model.RouteBean;
import org.onebusaway.transit_data.model.RouteScheduleBean;
import org.onebusaway.transit_data.model.StopBean;
import org.onebusaway.transit_data.model.StopTimeInstanceBeanExtendedWithStopId;
import org.onebusaway.transit_data.model.StopsAndTripsForDirectionBean;
import org.onebusaway.transit_data.model.service_alerts.ServiceAlertBean;
import org.onebusaway.transit_data.model.service_alerts.SituationQueryBean;
import org.onebusaway.transit_data.model.trips.TripBean;
import org.onebusaway.transit_data_federation.impl.DirectedGraph;
import org.onebusaway.transit_data_federation.impl.StopGraphComparator;
import org.onebusaway.transit_data_federation.model.narrative.AgencyNarrative;
import org.onebusaway.transit_data_federation.model.narrative.RouteCollectionNarrative;
import org.onebusaway.transit_data_federation.model.narrative.StopNarrative;
import org.onebusaway.transit_data_federation.model.narrative.TripNarrative;
import org.onebusaway.transit_data_federation.services.ExtendedCalendarService;
import org.onebusaway.transit_data_federation.services.beans.RouteScheduleBeanService;
import org.onebusaway.transit_data_federation.services.beans.ServiceAlertsBeanService;
import org.onebusaway.transit_data_federation.services.blocks.BlockIndexService;
import org.onebusaway.transit_data_federation.services.blocks.BlockTripIndex;
import org.onebusaway.transit_data_federation.services.narrative.NarrativeService;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockTripEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.RouteCollectionEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.RouteEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.ServiceIdActivation;
import org.onebusaway.transit_data_federation.services.transit_graph.StopEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.StopTimeEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.TransitGraphDao;
import org.onebusaway.transit_data_federation.services.transit_graph.TripEntry;
import org.onebusaway.util.AgencyAndIdLibrary;
import org.onebusaway.utility.text.StringLibrary;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RouteScheduleBeanServiceImpl
implements RouteScheduleBeanService {
    protected TransitGraphDao _graph;
    protected ExtendedCalendarService _calendarService;
    protected BlockIndexService _blockIndexService;
    protected NarrativeService _narrativeService;
    private ServiceAlertsBeanService _serviceAlertsBeanService;

    @Autowired
    public void setTransitGraphDao(TransitGraphDao graph) {
        this._graph = graph;
    }

    @Autowired
    public void setNarrativeService(NarrativeService service) {
        this._narrativeService = service;
    }

    @Autowired
    public void setCalendarService(ExtendedCalendarService service) {
        this._calendarService = service;
    }

    @Autowired
    public void setBlockIndexService(BlockIndexService blockIndexService) {
        this._blockIndexService = blockIndexService;
    }

    @Autowired
    public void setServiceAlertsBeanService(ServiceAlertsBeanService service) {
        this._serviceAlertsBeanService = service;
    }

    @Override
    @Cacheable
    public RouteScheduleBean getScheduledArrivalsForInterval(AgencyAndId routeId, AgencyServiceInterval serviceInterval) {
        RouteScheduleBean rsb = new RouteScheduleBean();
        rsb.setOutOfServiceBounds(true);
        rsb.setRouteId(routeId);
        rsb.setScheduleDate(serviceInterval.getServiceDate());
        RouteCollectionEntry routeCollectionForId = this._graph.getRouteCollectionForId(routeId);
        if (routeCollectionForId == null) {
            return rsb;
        }
        this.addStopTripDirectionsViaBlockTrip(rsb, routeId);
        this.addSituations(rsb, routeId);
        return rsb;
    }

    private void addSituations(RouteScheduleBean rsb, AgencyAndId routeId) {
        SituationQueryBean sqb = new SituationQueryBean();
        this.createAffectsBeanInSituationQuerry(sqb).setRouteId(AgencyAndId.convertToString((AgencyAndId)routeId));
        for (StopBean stopBean : rsb.getStops()) {
            SituationQueryBean.AffectsBean routeStopAffects = this.createAffectsBeanInSituationQuerry(sqb);
            routeStopAffects.setRouteId(AgencyAndId.convertToString((AgencyAndId)routeId));
            routeStopAffects.setStopId(stopBean.getId());
            this.createAffectsBeanInSituationQuerry(sqb).setStopId(stopBean.getId());
        }
        List<ServiceAlertBean> serviceAlerts = this._serviceAlertsBeanService.getServiceAlerts(sqb);
        rsb.setServiceAlerts(serviceAlerts);
    }

    private SituationQueryBean.AffectsBean createAffectsBeanInSituationQuerry(SituationQueryBean sqb) {
        SituationQueryBean.AffectsBean routeAffects = new SituationQueryBean.AffectsBean();
        sqb.getAffects().add(routeAffects);
        return routeAffects;
    }

    private void addStopTripDirectionsViaBlockTrip(RouteScheduleBean rsb, AgencyAndId routeId) {
        List<BlockTripIndex> blockTripIndices = this._blockIndexService.getBlockTripIndicesForRouteCollectionId(routeId);
        HashMap<String, StopCollections> directionToStopCollectionsMap = new HashMap<String, StopCollections>();
        HashMap<String, StopsAndTripsForDirectionBean> directionToStopTripDirectionBeanMap = new HashMap<String, StopsAndTripsForDirectionBean>();
        HashSet<AgencyAndId> serviceIds = new HashSet<AgencyAndId>();
        LinkedHashSet<TripEntry> activeTrips = new LinkedHashSet<TripEntry>();
        BeanReferences references = new BeanReferences();
        this.addAgencyReference(references, routeId.getAgencyId());
        this.addRouteReference(references, routeId);
        for (BlockTripIndex bti : blockTripIndices) {
            for (BlockTripEntry blockTrip : bti.getTrips()) {
                ServiceIdActivation idActivation = blockTrip.getPattern().getServiceIds();
                if (this._calendarService.areServiceIdsActiveOnServiceDate(idActivation, rsb.getScheduleDate().getAsDate(idActivation.getTimeZone()))) {
                    rsb.setOutOfServiceBounds(false);
                    activeTrips.add(blockTrip.getTrip());
                    String directionId = blockTrip.getTrip().getDirectionId();
                    TripNarrative tripNarrativeForId = this._narrativeService.getTripForId(blockTrip.getTrip().getId());
                    String headsign = null;
                    headsign = tripNarrativeForId != null ? tripNarrativeForId.getTripHeadsign() : this.getDestinationForTrip(blockTrip.getTrip());
                    StopCollection stops = new StopCollection();
                    stops.addFromTrip(blockTrip.getTrip());
                    StopsAndTripsForDirectionBean stdb = (StopsAndTripsForDirectionBean)directionToStopTripDirectionBeanMap.get(directionId);
                    StopCollections sc = (StopCollections)directionToStopCollectionsMap.get(directionId);
                    if (stdb == null) {
                        stdb = new StopsAndTripsForDirectionBean();
                        stdb.setDirectionId(directionId);
                        stdb.setTripIds(new ArrayList());
                        stdb.setStopIds(new ArrayList());
                        directionToStopTripDirectionBeanMap.put(directionId, stdb);
                        sc = new StopCollections();
                        directionToStopCollectionsMap.put(directionId, sc);
                    }
                    stdb.getTripIds().add(blockTrip.getTrip().getId());
                    stdb.addTripHeadsign(headsign);
                    sc.addIfNotPresent(stops);
                    serviceIds.add(blockTrip.getTrip().getServiceId().getId());
                }
                if (!this.willServiceIdsBeActiveAfterServiceDate(idActivation, rsb.getScheduleDate().getAsDate(idActivation.getTimeZone()))) continue;
                rsb.setOutOfServiceBounds(false);
            }
        }
        for (String direction : directionToStopTripDirectionBeanMap.keySet()) {
            StopsAndTripsForDirectionBean bean = (StopsAndTripsForDirectionBean)directionToStopTripDirectionBeanMap.get(direction);
            StopCollections sc = (StopCollections)directionToStopCollectionsMap.get(direction);
            bean.setStopIds(this.collapse((StopCollections)directionToStopCollectionsMap.get(direction)));
            this.addStopTimeReferences(references, bean, activeTrips, bean.getTripIds(), rsb.getScheduleDate());
        }
        rsb.setServiceIds(new ArrayList());
        for (AgencyAndId serviceId : serviceIds) {
            rsb.getServiceIds().add(serviceId);
        }
        rsb.getStopTripDirections().addAll(directionToStopTripDirectionBeanMap.values());
        rsb.getAgencies().addAll(references.getAgencies());
        rsb.getRoutes().addAll(references.getRoutes());
        rsb.getTrips().addAll(references.getTrips());
        rsb.getStops().addAll(references.getStops());
        rsb.getStopTimes().addAll(references.getStopTimes());
    }

    private boolean willServiceIdsBeActiveAfterServiceDate(ServiceIdActivation serviceIds, Date serviceDate) {
        boolean answer = false;
        Set<Date> dates = this._calendarService.getDatesForServiceIds(serviceIds);
        for (Date date : dates) {
            if (!date.after(serviceDate)) continue;
            return true;
        }
        return answer;
    }

    private void addRouteReference(BeanReferences references, AgencyAndId routeId) {
        this.findOrBuildRouteBean(references, routeId);
    }

    private RouteBean findOrBuildRouteBean(BeanReferences references, AgencyAndId routeId) {
        RouteBean routeBean = references.getRoute(routeId);
        if (routeBean != null) {
            return routeBean;
        }
        RouteBean.Builder builder = RouteBean.builder();
        builder.setId(AgencyAndIdLibrary.convertToString((AgencyAndId)routeId));
        AgencyBean agency = references.getAgencyById(routeId.getAgencyId());
        builder.setAgency(agency);
        RouteCollectionNarrative narrative = this._narrativeService.getRouteCollectionForId(routeId);
        if (narrative == null) {
            routeBean = builder.create();
            references.getRoutes().add(routeBean);
            return routeBean;
        }
        builder.setColor(narrative.getColor());
        builder.setDescription(narrative.getDescription());
        builder.setLongName(narrative.getLongName());
        builder.setShortName(narrative.getShortName());
        builder.setTextColor(narrative.getTextColor());
        builder.setType(narrative.getType());
        builder.setUrl(narrative.getUrl());
        routeBean = builder.create();
        references.getRoutes().add(routeBean);
        return routeBean;
    }

    private void addStopTimeReferences(BeanReferences references, StopsAndTripsForDirectionBean stopsAndTripsForDirectionBean, Set<TripEntry> allTrips, List<AgencyAndId> selectedTrips, ServiceDate serviceDate) {
        for (AgencyAndId selection : selectedTrips) {
            for (TripEntry tripEntry : allTrips) {
                if (!tripEntry.getId().equals((Object)selection)) continue;
                this.addAgencyReference(references, tripEntry.getId().getAgencyId());
                this.addTripReference(references, tripEntry);
                for (StopTimeEntry stopTimeEntry : tripEntry.getStopTimes()) {
                    this.addStopTimeReference(references, stopsAndTripsForDirectionBean, stopTimeEntry, serviceDate);
                    this.addStopReference(references, stopTimeEntry.getStop(), stopTimeEntry.getTrip().getRoute());
                }
            }
        }
    }

    private void addAgencyReference(BeanReferences references, String agencyId) {
        if (references.hasAgency(agencyId)) {
            return;
        }
        AgencyBean bean = new AgencyBean();
        references.getAgencies().add(bean);
        bean.setId(agencyId);
        AgencyNarrative narrative = this._narrativeService.getAgencyForId(agencyId);
        if (narrative == null) {
            return;
        }
        bean.setName(narrative.getName());
        bean.setLang(narrative.getLang());
        bean.setEmail(narrative.getEmail());
        bean.setPhone(narrative.getPhone());
        bean.setDisclaimer(narrative.getDisclaimer());
        bean.setTimezone(narrative.getTimezone());
        bean.setUrl(narrative.getUrl());
        bean.setFareUrl(narrative.getFareUrl());
    }

    private void addTripReference(BeanReferences references, TripEntry tripEntry) {
        if (references.hasTrip(tripEntry.getId())) {
            return;
        }
        TripBean bean = new TripBean();
        bean.setId(AgencyAndIdLibrary.convertToString((AgencyAndId)tripEntry.getId()));
        bean.setDirectionId(tripEntry.getDirectionId());
        bean.setServiceId(AgencyAndIdLibrary.convertToString((AgencyAndId)tripEntry.getServiceId().getId()));
        bean.setBlockId(AgencyAndIdLibrary.convertToString((AgencyAndId)tripEntry.getBlock().getId()));
        bean.setShapeId(AgencyAndIdLibrary.convertToString((AgencyAndId)tripEntry.getShapeId()));
        references.getTrips().add(bean);
        TripNarrative narrative = this._narrativeService.getTripForId(tripEntry.getId());
        if (narrative == null) {
            return;
        }
        bean.setTripHeadsign(narrative.getTripHeadsign());
        bean.setRouteShortName(narrative.getRouteShortName());
        bean.setTripShortName(narrative.getTripShortName());
        bean.setRoute(this.findOrBuildRouteBean(references, tripEntry.getRoute().getId()));
    }

    private void addStopReference(BeanReferences references, StopEntry stop, RouteEntry route) {
        StopBean bean = new StopBean();
        bean.setId(AgencyAndIdLibrary.convertToString((AgencyAndId)stop.getId()));
        if (references.hasStop(stop.getId())) {
            StopBean stopBean = references.getStop(stop.getId());
            RouteBean routeBean = this.findOrBuildRouteBean(references, route.getId());
            if (!stopBean.getRoutes().contains(routeBean)) {
                stopBean.getRoutes().add(routeBean);
            }
            return;
        }
        references.getStops().add(bean);
        bean.setId(AgencyAndIdLibrary.convertToString((AgencyAndId)stop.getId()));
        bean.setLat(stop.getStopLat());
        bean.setLon(stop.getStopLon());
        if (stop.getParent() != null) {
            if (references.hasStop(stop.getParent())) {
                bean.setParent(references.getStop(stop.getParent()));
            } else {
                AgencyAndId parentId = stop.getParent();
                StopBean parentBean = new StopBean();
                StopNarrative parentNarrative = this._narrativeService.getStopForId(parentId);
                StopEntry parent = this._graph.getStopEntryForId(parentId);
                parentBean.setId(AgencyAndIdLibrary.convertToString((AgencyAndId)parentId));
                parentBean.setLat(parent.getStopLat());
                parentBean.setLon(parent.getStopLon());
                parentBean.setName(parentNarrative.getName());
                parentBean.setCode(StringLibrary.getBestName((String[])new String[]{parentNarrative.getCode(), parent.getId().getId()}));
                parentBean.setLocationType(parentNarrative.getLocationType());
                parentBean.setDirection(parentNarrative.getDirection());
                parentBean.setWheelchairBoarding(parent.getWheelchairBoarding());
                ArrayList parentRoutes = new ArrayList();
                parentBean.setRoutes(parentRoutes);
                bean.setParent(parentBean);
                references.getStops().add(parentBean);
            }
        }
        ArrayList<RouteBean> routes = new ArrayList<RouteBean>();
        routes.add(this.findOrBuildRouteBean(references, route.getId()));
        bean.setRoutes(routes);
        StopNarrative narrative = this._narrativeService.getStopForId(stop.getId());
        if (narrative == null) {
            return;
        }
        bean.setName(narrative.getName());
        bean.setCode(StringLibrary.getBestName((String[])new String[]{narrative.getCode(), stop.getId().getId()}));
        bean.setDirection(narrative.getDirection());
    }

    private void addStopTimeReference(BeanReferences references, StopsAndTripsForDirectionBean stopsAndTripsForDirectionBean, StopTimeEntry stopTimeEntry, ServiceDate serviceDate) {
        StopTimeInstanceBeanExtendedWithStopId bean = new StopTimeInstanceBeanExtendedWithStopId();
        bean.setTripId(AgencyAndIdLibrary.convertToString((AgencyAndId)stopTimeEntry.getTrip().getId()));
        bean.setServiceId(AgencyAndIdLibrary.convertToString((AgencyAndId)stopTimeEntry.getTrip().getServiceId().getId()));
        bean.setServiceDate(serviceDate.getAsDate(this.getTimeZoneForAgency(stopTimeEntry.getTrip().getId().getAgencyId())).getTime());
        bean.setArrivalEnabled(stopTimeEntry.getArrivalTime() > 0);
        bean.setArrivalTime((long)stopTimeEntry.getArrivalTime());
        bean.setDepartureEnabled(stopTimeEntry.getDepartureTime() > 0);
        bean.setDepartureTime((long)stopTimeEntry.getDepartureTime());
        bean.setStopId(stopTimeEntry.getStop().getId());
        references.getStopTimes().add(bean);
        stopsAndTripsForDirectionBean.getStopTimes().add(bean);
    }

    private TimeZone getTimeZoneForAgency(String agencyId) {
        AgencyNarrative agency = this._narrativeService.getAgencyForId(agencyId);
        if (agency == null) {
            return TimeZone.getDefault();
        }
        if (agency.getTimezone() == null) {
            return TimeZone.getDefault();
        }
        return TimeZone.getTimeZone(agency.getTimezone());
    }

    private List<AgencyAndId> collapse(StopCollections stopCollections) {
        ArrayList<StopEntry> stopsInDefaultOrder = new ArrayList<StopEntry>();
        DirectedGraph<StopEntry> graph = new DirectedGraph<StopEntry>();
        for (StopCollection sequence : stopCollections.getList()) {
            StopEntry prev = null;
            for (StopEntry stop : sequence.getStops()) {
                if (prev != null && !graph.isConnected(stop, prev)) {
                    graph.addEdge(prev, stop);
                    stopsInDefaultOrder.add(stop);
                }
                prev = stop;
            }
        }
        StopGraphComparator c = new StopGraphComparator(graph);
        ArrayList<AgencyAndId> ids = new ArrayList<AgencyAndId>();
        for (StopEntry entry : graph.getTopologicalSort(c)) {
            ids.add(entry.getId());
        }
        return ids;
    }

    private String getDestinationForTrip(TripEntry trip) {
        int lastStopIndex = trip.getStopTimes().size() - 1;
        AgencyAndId stopId = trip.getStopTimes().get(lastStopIndex).getStop().getId();
        StopNarrative stopForId = this._narrativeService.getStopForId(stopId);
        if (stopForId == null) {
            return null;
        }
        return stopForId.getName();
    }

    public static class BeanReferences {
        private Set<AgencyBean> agencies = new LinkedHashSet<AgencyBean>();
        private Set<RouteBean> routes = new LinkedHashSet<RouteBean>();
        private Set<TripBean> trips = new LinkedHashSet<TripBean>();
        private Set<StopBean> stops = new LinkedHashSet<StopBean>();
        private Set<StopTimeInstanceBeanExtendedWithStopId> stopTimes = new LinkedHashSet<StopTimeInstanceBeanExtendedWithStopId>();

        public Set<AgencyBean> getAgencies() {
            return this.agencies;
        }

        public Set<RouteBean> getRoutes() {
            return this.routes;
        }

        public Set<TripBean> getTrips() {
            return this.trips;
        }

        public Set<StopBean> getStops() {
            return this.stops;
        }

        public Set<StopTimeInstanceBeanExtendedWithStopId> getStopTimes() {
            return this.stopTimes;
        }

        public boolean hasAgency(String agencyId) {
            for (AgencyBean bean : this.agencies) {
                if (!bean.getId().equals(agencyId)) continue;
                return true;
            }
            return false;
        }

        public boolean hasTrip(AgencyAndId id) {
            for (TripBean bean : this.trips) {
                if (!bean.getId().equals(AgencyAndIdLibrary.convertToString((AgencyAndId)id))) continue;
                return true;
            }
            return false;
        }

        public boolean hasStop(AgencyAndId id) {
            for (StopBean bean : this.stops) {
                if (!bean.getId().equals(AgencyAndIdLibrary.convertToString((AgencyAndId)id))) continue;
                return true;
            }
            return false;
        }

        public StopBean getStop(AgencyAndId id) {
            for (StopBean bean : this.stops) {
                if (!bean.getId().equals(AgencyAndIdLibrary.convertToString((AgencyAndId)id))) continue;
                return bean;
            }
            return null;
        }

        public boolean hasRoute(AgencyAndId id) {
            for (RouteBean bean : this.routes) {
                if (!bean.getId().equals(AgencyAndIdLibrary.convertToString((AgencyAndId)id))) continue;
                return true;
            }
            return false;
        }

        public RouteBean getRoute(AgencyAndId id) {
            for (RouteBean bean : this.routes) {
                if (!bean.getId().equals(AgencyAndIdLibrary.convertToString((AgencyAndId)id))) continue;
                return bean;
            }
            return null;
        }

        public AgencyBean getAgencyById(String agencyId) {
            for (AgencyBean bean : this.agencies) {
                if (!bean.getId().equals(agencyId)) continue;
                return bean;
            }
            return null;
        }
    }

    private static class StopCollection {
        private List<StopEntry> stops;

        public StopCollection() {
            this.stops = new ArrayList<StopEntry>();
        }

        public StopCollection(List<StopEntry> stops) {
            this.stops = stops;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StopCollection that = (StopCollection)o;
            return Objects.equals(this.stops, that.stops);
        }

        public int hashCode() {
            return Objects.hash(this.stops);
        }

        public void addFromTrip(TripEntry trip) {
            for (StopTimeEntry stopTimes : trip.getStopTimes()) {
                this.stops.add(stopTimes.getStop());
            }
        }

        public List<StopEntry> getStops() {
            return this.stops;
        }
    }

    private static class StopCollections {
        private List<StopCollection> list = new ArrayList<StopCollection>();

        public void addIfNotPresent(StopCollection stops) {
            if (!this.list.contains(stops)) {
                this.list.add(stops);
            }
        }

        public List<StopCollection> getList() {
            return this.list;
        }
    }

    private class DirectionHeadsignStops {
        private String directionId;
        private String tripHeadsign;
        private StopCollections stopCollections = new StopCollections();

        public DirectionHeadsignStops(String directionId, String tripHeadsign, StopCollection stopCollection) {
            this.directionId = directionId;
            this.tripHeadsign = tripHeadsign;
            if (stopCollection == null) {
                throw new NullPointerException("StopCollection cannot be null");
            }
            this.stopCollections.addIfNotPresent(stopCollection);
        }

        public String getDirectionId() {
            return this.directionId;
        }

        public String getTripHeadsign() {
            return this.tripHeadsign;
        }

        public StopCollections getStopCollections() {
            return this.stopCollections;
        }

        public void addStopCollection(StopCollection stopCollection) {
            this.stopCollections.addIfNotPresent(stopCollection);
        }

        public String toString() {
            return this.directionId + this.tripHeadsign + this.stopCollections.getList().get((int)0).stops.stream().map(x -> x.getId().toString() + x.getStopLat() + x.getStopLon()).sorted().reduce((x, y) -> x + y);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DirectionHeadsignStops)) {
                return false;
            }
            DirectionHeadsignStops that = (DirectionHeadsignStops)obj;
            return this.toString().equals(that.toString());
        }

        public int hashCode() {
            return this.toString().hashCode();
        }
    }
}

