/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.beans;

import java.util.ArrayList;
import java.util.List;
import org.onebusaway.container.cache.Cacheable;
import org.onebusaway.container.cache.CacheableArgument;
import org.onebusaway.geospatial.model.CoordinateBounds;
import org.onebusaway.geospatial.services.SphericalGeometryLibrary;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.transit_data.model.FilterChain;
import org.onebusaway.transit_data.model.StopBean;
import org.onebusaway.transit_data_federation.impl.beans.ApplicationBeanLibrary;
import org.onebusaway.transit_data_federation.services.beans.GeospatialBeanService;
import org.onebusaway.transit_data_federation.services.beans.NearbyStopsBeanService;
import org.onebusaway.transit_data_federation.services.beans.StopsBeanService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class NearbyStopsBeanServiceImpl
implements NearbyStopsBeanService {
    private GeospatialBeanService _geospatialBeanService;
    private StopsBeanService _stopsBeanService;

    NearbyStopsBeanServiceImpl() {
    }

    @Autowired
    public void setGeospatialBeanService(GeospatialBeanService geospatialBeanService) {
        this._geospatialBeanService = geospatialBeanService;
    }

    @Autowired
    public void setStopsBeanService(StopsBeanService _stopsBeanService) {
        this._stopsBeanService = _stopsBeanService;
    }

    @Override
    public List<AgencyAndId> getNearbyStops(StopBean stopBean, double radius) {
        return this.getNearbyStops(stopBean, radius, new FilterChain());
    }

    @Override
    @Cacheable
    public List<AgencyAndId> getNearbyStops(@CacheableArgument(keyProperty="id") StopBean stopBean, double radius, FilterChain filterChain) {
        CoordinateBounds bounds = SphericalGeometryLibrary.bounds((double)stopBean.getLat(), (double)stopBean.getLon(), (double)radius);
        List<AgencyAndId> ids = this._geospatialBeanService.getStopsByBounds(bounds);
        ArrayList<AgencyAndId> excludingSource = new ArrayList<AgencyAndId>();
        for (AgencyAndId id : ids) {
            if (ApplicationBeanLibrary.getId(id).equals(stopBean.getId()) || !filterChain.matches(stopBean)) continue;
            excludingSource.add(id);
        }
        return excludingSource;
    }
}

