/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.beans;

import java.util.ArrayList;
import java.util.List;
import org.onebusaway.geospatial.model.CoordinateBounds;
import org.onebusaway.geospatial.model.CoordinatePoint;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.transit_data.model.ListBean;
import org.onebusaway.transit_data.model.StopBean;
import org.onebusaway.transit_data.model.blocks.BlockStatusBean;
import org.onebusaway.transit_data.model.blocks.BlockTripBean;
import org.onebusaway.transit_data_federation.impl.beans.ApplicationBeanLibrary;
import org.onebusaway.transit_data_federation.services.beans.BlockBeanService;
import org.onebusaway.transit_data_federation.services.beans.BlockStatusBeanService;
import org.onebusaway.transit_data_federation.services.beans.StopBeanService;
import org.onebusaway.transit_data_federation.services.blocks.BlockInstance;
import org.onebusaway.transit_data_federation.services.blocks.BlockStatusService;
import org.onebusaway.transit_data_federation.services.realtime.BlockLocation;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockConfigurationEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockStopTimeEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockTripEntry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BlockStatusBeanServiceImpl
implements BlockStatusBeanService {
    private StopBeanService _stopBeanService;
    private BlockStatusService _blockStatusService;
    private BlockBeanService _blockBeanService;

    @Autowired
    public void setStopBeanService(StopBeanService stopBeanService) {
        this._stopBeanService = stopBeanService;
    }

    @Autowired
    public void setBlockStatusService(BlockStatusService blockStatusService) {
        this._blockStatusService = blockStatusService;
    }

    @Autowired
    public void setBlockBeanService(BlockBeanService blockBeanService) {
        this._blockBeanService = blockBeanService;
    }

    @Override
    public BlockStatusBean getBlockForVehicle(AgencyAndId vehicleId, long time) {
        return this.bean(this._blockStatusService.getBlockForVehicle(vehicleId, time));
    }

    @Override
    public ListBean<BlockStatusBean> getBlocksForAgency(String agencyId, long time) {
        return this.beans(this._blockStatusService.getActiveBlocksForAgency(agencyId, time));
    }

    @Override
    public ListBean<BlockStatusBean> getBlocksForRoute(AgencyAndId routeId, long time) {
        return this.beans(this._blockStatusService.getBlocksForRoute(routeId, time));
    }

    @Override
    public ListBean<BlockStatusBean> getBlocksForBounds(CoordinateBounds bounds, long time) {
        return this.beans(this._blockStatusService.getBlocksForBounds(bounds, time));
    }

    private ListBean<BlockStatusBean> beans(List<BlockLocation> locations) {
        ArrayList<BlockStatusBean> results = new ArrayList<BlockStatusBean>();
        for (BlockLocation location : locations) {
            BlockStatusBean statusBean = this.bean(location);
            if (statusBean == null) continue;
            results.add(statusBean);
        }
        return new ListBean(results, false);
    }

    private BlockStatusBean bean(BlockLocation blockLocation) {
        BlockStopTimeEntry stop;
        if (blockLocation == null) {
            return null;
        }
        BlockInstance instance = blockLocation.getBlockInstance();
        BlockConfigurationEntry block = instance.getBlock();
        long serviceDate = instance.getServiceDate();
        BlockStatusBean bean = new BlockStatusBean();
        bean.setBlock(this._blockBeanService.getBlockForId(block.getBlock().getId()));
        bean.setStatus("default");
        bean.setServiceDate(serviceDate);
        bean.setTotalDistanceAlongBlock(block.getTotalBlockDistance());
        bean.setInService(blockLocation.isInService());
        CoordinatePoint location = blockLocation.getLocation();
        bean.setLocation(location);
        bean.setScheduledDistanceAlongBlock(blockLocation.getScheduledDistanceAlongBlock());
        bean.setDistanceAlongBlock(blockLocation.getDistanceAlongBlock());
        BlockTripEntry activeTrip = blockLocation.getActiveTrip();
        if (activeTrip != null) {
            BlockTripBean activeTripBean = this._blockBeanService.getBlockTripAsBean(activeTrip);
            bean.setActiveTrip(activeTripBean);
        }
        if ((stop = blockLocation.getClosestStop()) != null) {
            StopBean stopBean = this._stopBeanService.getStopForId(stop.getStopTime().getStop().getId(), null);
            bean.setClosestStop(stopBean);
            bean.setClosestStopTimeOffset(blockLocation.getClosestStopTimeOffset());
        }
        bean.setPredicted(blockLocation.isPredicted());
        bean.setLastUpdateTime(blockLocation.getLastUpdateTime());
        bean.setScheduleDeviation(blockLocation.getScheduleDeviation());
        AgencyAndId vid = blockLocation.getVehicleId();
        if (vid != null) {
            bean.setVehicleId(ApplicationBeanLibrary.getId(vid));
        }
        return bean;
    }
}

