/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.beans;

import org.onebusaway.container.cache.Cacheable;
import org.onebusaway.transit_data.model.AgencyBean;
import org.onebusaway.transit_data_federation.model.narrative.AgencyNarrative;
import org.onebusaway.transit_data_federation.services.beans.AgencyBeanService;
import org.onebusaway.transit_data_federation.services.narrative.NarrativeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class AgencyBeanServiceImpl
implements AgencyBeanService {
    private NarrativeService _narrativeService;

    AgencyBeanServiceImpl() {
    }

    @Autowired
    public void setNarrativeService(NarrativeService narrativeService) {
        this._narrativeService = narrativeService;
    }

    @Override
    @Cacheable
    public AgencyBean getAgencyForId(String id) {
        AgencyNarrative agency = this._narrativeService.getAgencyForId(id);
        if (agency == null) {
            return null;
        }
        AgencyBean bean = new AgencyBean();
        bean.setId(id);
        bean.setLang(agency.getLang());
        bean.setName(agency.getName());
        bean.setPhone(agency.getPhone());
        bean.setEmail(agency.getEmail());
        bean.setTimezone(agency.getTimezone());
        bean.setUrl(agency.getUrl());
        bean.setDisclaimer(agency.getDisclaimer());
        bean.setPrivateService(agency.isPrivateService());
        bean.setFareUrl(agency.getFareUrl());
        bean.setEmail(agency.getEmail());
        return bean;
    }
}

