/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.onebusaway.collections.Range;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.calendar.ServiceDate;
import org.onebusaway.gtfs.model.calendar.ServiceInterval;
import org.onebusaway.transit_data_federation.impl.blocks.IndexAdapters;
import org.onebusaway.transit_data_federation.impl.time.GenericBinarySearch;
import org.onebusaway.transit_data_federation.model.StopTimeInstance;
import org.onebusaway.transit_data_federation.services.ExtendedCalendarService;
import org.onebusaway.transit_data_federation.services.StopTimeService;
import org.onebusaway.transit_data_federation.services.blocks.AbstractBlockStopTimeIndex;
import org.onebusaway.transit_data_federation.services.blocks.BlockIndexService;
import org.onebusaway.transit_data_federation.services.blocks.BlockStopSequenceIndex;
import org.onebusaway.transit_data_federation.services.blocks.BlockStopTimeIndex;
import org.onebusaway.transit_data_federation.services.blocks.FrequencyBlockStopTimeIndex;
import org.onebusaway.transit_data_federation.services.blocks.FrequencyStopTripIndex;
import org.onebusaway.transit_data_federation.services.blocks.HasIndexedBlockStopTimes;
import org.onebusaway.transit_data_federation.services.blocks.InstanceState;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockStopTimeEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.FrequencyBlockStopTimeEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.FrequencyEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.ServiceIdActivation;
import org.onebusaway.transit_data_federation.services.transit_graph.StopEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.TransitGraphDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class StopTimeServiceImpl
implements StopTimeService {
    private TransitGraphDao _graph;
    private ExtendedCalendarService _calendarService;
    private BlockIndexService _blockIndexService;

    StopTimeServiceImpl() {
    }

    @Autowired
    public void setTransitGraphDao(TransitGraphDao graph) {
        this._graph = graph;
    }

    @Autowired
    public void setCalendarService(ExtendedCalendarService calendarService) {
        this._calendarService = calendarService;
    }

    @Autowired
    public void setBlockIndexService(BlockIndexService blockIndexService) {
        this._blockIndexService = blockIndexService;
    }

    @Override
    public List<StopTimeInstance> getStopTimeInstancesInTimeRange(AgencyAndId stopId, Date from, Date to) {
        StopEntry stopEntry = this._graph.getStopEntryForId(stopId, true);
        return this.getStopTimeInstancesInTimeRange(stopEntry, from, to, StopTimeService.EFrequencyStopTimeBehavior.INCLUDE_UNSPECIFIED);
    }

    @Override
    public List<StopTimeInstance> getStopTimeInstancesInTimeRange(StopEntry stopEntry, Date from, Date to, StopTimeService.EFrequencyStopTimeBehavior frequencyBehavior) {
        ArrayList<StopTimeInstance> stopTimeInstances = new ArrayList<StopTimeInstance>();
        for (BlockStopTimeIndex index : this._blockIndexService.getStopTimeIndicesForStop(stopEntry)) {
            Collection<Date> serviceDates = this._calendarService.getServiceDatesWithinRange(index.getServiceIds(), index.getServiceInterval(), from, to);
            for (Date serviceDate : serviceDates) {
                this.getStopTimesForStopAndServiceDateAndTimeRange(index, serviceDate, from, to, stopTimeInstances);
            }
        }
        List<FrequencyStopTripIndex> frequencyStopTripIndices = this._blockIndexService.getFrequencyStopTripIndicesForStop(stopEntry);
        for (FrequencyStopTripIndex index : frequencyStopTripIndices) {
            Collection<Date> serviceDates = this._calendarService.getServiceDatesWithinRange(index.getServiceIds(), index.getServiceInterval(), from, to);
            for (Date serviceDate : serviceDates) {
                this.getFrequenciesForStopAndServiceIdsAndTimeRange(index, serviceDate, from, to, stopTimeInstances, frequencyBehavior);
            }
        }
        return stopTimeInstances;
    }

    @Override
    public Range getDepartureForStopAndServiceDate(AgencyAndId stopId, ServiceDate serviceDate) {
        StopEntry stop = this._graph.getStopEntryForId(stopId, true);
        List<BlockStopTimeIndex> indices = this._blockIndexService.getStopTimeIndicesForStop(stop);
        Range interval = new Range();
        for (BlockStopTimeIndex index : indices) {
            this.extendIntervalWithIndex(serviceDate, interval, index);
        }
        List<FrequencyBlockStopTimeIndex> freqIndices = this._blockIndexService.getFrequencyStopTimeIndicesForStop(stop);
        for (FrequencyBlockStopTimeIndex index : freqIndices) {
            this.extendIntervalWithIndex(serviceDate, interval, index);
        }
        return interval;
    }

    @Override
    public List<StopTimeInstance> getNextBlockSequenceDeparturesForStop(StopEntry stopEntry, long time, boolean includePrivateSerivce) {
        ArrayList<StopTimeInstance> stopTimeInstances = new ArrayList<StopTimeInstance>();
        List<BlockStopSequenceIndex> blockStopTripIndices = this._blockIndexService.getStopSequenceIndicesForStop(stopEntry);
        for (BlockStopSequenceIndex index : blockStopTripIndices) {
            List<Date> serviceDates = this._calendarService.getNextServiceDatesForDepartureInterval(index.getServiceIds(), index.getServiceInterval(), time);
            for (Date serviceDate : serviceDates) {
                int relativeFrom = StopTimeServiceImpl.effectiveTime(serviceDate.getTime(), time);
                int fromIndex = GenericBinarySearch.search(index, index.size(), relativeFrom, IndexAdapters.BLOCK_STOP_TIME_DEPARTURE_INSTANCE);
                if (fromIndex >= index.size()) continue;
                BlockStopTimeEntry blockStopTime = index.getBlockStopTimeForIndex(fromIndex);
                InstanceState state = new InstanceState(serviceDate.getTime());
                StopTimeInstance sti = new StopTimeInstance(blockStopTime, state);
                stopTimeInstances.add(sti);
            }
        }
        List<FrequencyBlockStopTimeIndex> frequencyIndices = this._blockIndexService.getFrequencyStopTimeIndicesForStop(stopEntry);
        for (FrequencyBlockStopTimeIndex index : frequencyIndices) {
            List<Date> serviceDates = this._calendarService.getNextServiceDatesForDepartureInterval(index.getServiceIds(), index.getServiceInterval(), time);
            for (Date serviceDate : serviceDates) {
                int relativeFrom = StopTimeServiceImpl.effectiveTime(serviceDate.getTime(), time);
                int fromIndex = GenericBinarySearch.search(index, index.size(), relativeFrom, IndexAdapters.FREQUENCY_END_TIME_INSTANCE);
                List<FrequencyBlockStopTimeEntry> frequencyStopTimes = index.getFrequencyStopTimes();
                if (fromIndex >= index.size()) continue;
                FrequencyBlockStopTimeEntry entry = frequencyStopTimes.get(fromIndex);
                BlockStopTimeEntry bst = entry.getStopTime();
                FrequencyEntry frequency = entry.getFrequency();
                InstanceState state = new InstanceState(serviceDate.getTime(), frequency);
                int stopTimeOffset = entry.getStopTimeOffset();
                int frequencyOffset = this.computeFrequencyOffset(relativeFrom, bst, frequency, stopTimeOffset, true);
                StopTimeInstance sti = new StopTimeInstance(bst, state, frequencyOffset);
                stopTimeInstances.add(sti);
            }
        }
        return stopTimeInstances;
    }

    private int computeFrequencyOffset(int relativeTime, BlockStopTimeEntry sourceBst, FrequencyEntry frequency, int stopTimeOffset, boolean findDepartures) {
        int t = Math.max(relativeTime, frequency.getStartTime());
        t = Math.min(t, frequency.getEndTime());
        t = this.snapToFrequencyStopTime(frequency, t, stopTimeOffset, findDepartures);
        return t - sourceBst.getStopTime().getDepartureTime();
    }

    private int getStopTimesForStopAndServiceDateAndTimeRange(HasIndexedBlockStopTimes index, Date serviceDate, Date from, Date to, List<StopTimeInstance> instances) {
        List<BlockStopTimeEntry> blockStopTimes = index.getStopTimes();
        int relativeFrom = StopTimeServiceImpl.effectiveTime(serviceDate, from);
        int relativeTo = StopTimeServiceImpl.effectiveTime(serviceDate, to);
        int fromIndex = GenericBinarySearch.search(index, blockStopTimes.size(), relativeFrom, IndexAdapters.BLOCK_STOP_TIME_DEPARTURE_INSTANCE);
        int toIndex = GenericBinarySearch.search(index, blockStopTimes.size(), relativeTo, IndexAdapters.BLOCK_STOP_TIME_ARRIVAL_INSTANCE);
        InstanceState state = new InstanceState(serviceDate.getTime());
        for (int in = fromIndex; in < toIndex; ++in) {
            BlockStopTimeEntry blockStopTime = blockStopTimes.get(in);
            instances.add(new StopTimeInstance(blockStopTime, state));
        }
        return fromIndex;
    }

    private List<Integer> getFrequenciesForStopAndServiceIdsAndTimeRange(FrequencyStopTripIndex index, Date serviceDate, Date from, Date to, List<StopTimeInstance> stopTimeInstances, StopTimeService.EFrequencyStopTimeBehavior frequencyBehavior) {
        int relativeFrom = StopTimeServiceImpl.effectiveTime(serviceDate, from);
        int relativeTo = StopTimeServiceImpl.effectiveTime(serviceDate, to);
        int fromIndex = GenericBinarySearch.search(index, index.size(), relativeFrom, IndexAdapters.FREQUENCY_END_TIME_INSTANCE);
        int toIndex = GenericBinarySearch.search(index, index.size(), relativeTo, IndexAdapters.FREQUENCY_START_TIME_INSTANCE);
        List<FrequencyBlockStopTimeEntry> frequencyStopTimes = index.getFrequencyStopTimes();
        ArrayList<Integer> offsetsIntoIndex = new ArrayList<Integer>();
        block4: for (int in = fromIndex; in < toIndex; ++in) {
            FrequencyBlockStopTimeEntry entry = frequencyStopTimes.get(in);
            BlockStopTimeEntry bst = entry.getStopTime();
            FrequencyEntry frequency = entry.getFrequency();
            InstanceState state = new InstanceState(serviceDate.getTime(), frequency);
            switch (frequencyBehavior) {
                case INCLUDE_UNSPECIFIED: {
                    stopTimeInstances.add(new StopTimeInstance(bst, state));
                    offsetsIntoIndex.add(in);
                    continue block4;
                }
                case INCLUDE_INTERPOLATED: {
                    int stopTimeOffset = entry.getStopTimeOffset();
                    int tFrom = Math.max(relativeFrom, frequency.getStartTime());
                    int tTo = Math.min(relativeTo, frequency.getEndTime());
                    tFrom = this.snapToFrequencyStopTime(frequency, tFrom, stopTimeOffset, true);
                    tTo = this.snapToFrequencyStopTime(frequency, tTo, stopTimeOffset, false);
                    for (int t = tFrom; t <= tTo; t += frequency.getHeadwaySecs()) {
                        int frequencyOffset = t - bst.getStopTime().getDepartureTime();
                        stopTimeInstances.add(new StopTimeInstance(bst, state, frequencyOffset));
                        offsetsIntoIndex.add(in);
                    }
                    continue block4;
                }
            }
        }
        return offsetsIntoIndex;
    }

    private int snapToFrequencyStopTime(FrequencyEntry frequency, int timeToSnap, int stopTimeOffset, boolean isLowerBound) {
        int offset = timeToSnap - frequency.getStartTime();
        int headway = frequency.getHeadwaySecs();
        int snappedToHeadway = offset / headway * headway;
        int snapped = snappedToHeadway + frequency.getStartTime() + stopTimeOffset;
        if (isLowerBound) {
            if (snapped < timeToSnap) {
                snapped += headway;
            }
        } else if (snapped > timeToSnap) {
            snapped -= headway;
        }
        return snapped;
    }

    private void extendIntervalWithIndex(ServiceDate serviceDate, Range interval, AbstractBlockStopTimeIndex index) {
        Date date;
        ServiceIdActivation serviceIds = index.getServiceIds();
        if (this._calendarService.areServiceIdsActiveOnServiceDate(serviceIds, date = serviceDate.getAsDate(serviceIds.getTimeZone()))) {
            ServiceInterval in = index.getServiceInterval();
            long tFrom = date.getTime() + (long)(in.getMinDeparture() * 1000);
            long tTo = date.getTime() + (long)(in.getMaxDeparture() * 1000);
            interval.addValue((double)tFrom);
            interval.addValue((double)tTo);
        }
    }

    private static int effectiveTime(Date serviceDate, Date targetTime) {
        return StopTimeServiceImpl.effectiveTime(serviceDate.getTime(), targetTime.getTime());
    }

    private static int effectiveTime(long serviceDate, long targetTime) {
        return (int)((targetTime - serviceDate) / 1000L);
    }
}

