/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.onebusaway.container.refresh.Refreshable;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.transit_data.model.StopDirectionSwap;
import org.onebusaway.transit_data.services.TransitDataService;
import org.onebusaway.transit_data_federation.impl.StopDirectionSwapKey;
import org.onebusaway.transit_data_federation.services.FederatedTransitDataBundle;
import org.onebusaway.transit_data_federation.services.StopSwapService;
import org.onebusaway.transit_data_federation.services.transit_graph.TransitGraphDao;
import org.onebusaway.utility.ObjectSerializationLibrary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StopSwapServiceImpl
implements StopSwapService {
    private static Logger _log = LoggerFactory.getLogger(StopSwapServiceImpl.class);
    @Autowired
    private FederatedTransitDataBundle _bundle;
    @Autowired
    public TransitDataService _transitDataService;
    @Autowired
    public TransitGraphDao _dao;
    private Map<StopDirectionSwapKey, StopDirectionSwap> _cache;

    public void setTransitDataService(TransitDataService tds) {
        this._transitDataService = tds;
    }

    @PostConstruct
    @Refreshable(dependsOn={"transitGraph"})
    public void setup() throws IOException, ClassNotFoundException {
        File path = this._bundle.getStopSwapPath();
        if (path.exists()) {
            _log.info("loading Stop Swap / Wrong Way Concurrencies at {}", (Object)path);
            try {
                this._cache = (Map)ObjectSerializationLibrary.readObject((File)path);
            }
            catch (Throwable t) {
                this._cache = new HashMap<StopDirectionSwapKey, StopDirectionSwap>();
            }
        } else {
            this._cache = new HashMap<StopDirectionSwapKey, StopDirectionSwap>();
        }
    }

    @Override
    public StopDirectionSwap findStopDirectionSwap(AgencyAndId routeId, String directionId, AgencyAndId stopId) {
        return this._cache.get(new StopDirectionSwapKey(routeId, directionId, stopId));
    }
}

