/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.onebusaway.collections.FactoryMap;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.transit_data_federation.model.StopSequence;
import org.onebusaway.transit_data_federation.services.StopSequencesService;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockTripEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.StopEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.StopTimeEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.TripEntry;
import org.springframework.stereotype.Component;

@Component
public class StopSequencesServiceImpl
implements StopSequencesService {
    private static final AgencyAndId NO_SHAPE_ID = new AgencyAndId("no agency", StopSequencesServiceImpl.class.getName() + ".noShapeId");
    private static final String NO_DIRECTION_ID = StopSequencesServiceImpl.class.getName() + ".noDirectionId";

    @Override
    public List<StopSequence> getStopSequencesForTrips(List<BlockTripEntry> trips) {
        FactoryMap tripsByStopSequenceKey = new FactoryMap(new ArrayList());
        for (BlockTripEntry blockTrip : trips) {
            AgencyAndId shapeId;
            TripEntry trip = blockTrip.getTrip();
            String directionId = trip.getDirectionId();
            if (directionId == null) {
                directionId = NO_DIRECTION_ID;
            }
            if ((shapeId = trip.getShapeId()) == null || !shapeId.hasValues()) {
                shapeId = NO_SHAPE_ID;
            }
            List<StopEntry> stops = this.getStopTimesAsStops(trip.getStopTimes());
            StopSequenceKey key = new StopSequenceKey(stops, directionId, shapeId);
            ((List)tripsByStopSequenceKey.get(key)).add(blockTrip);
        }
        ArrayList<StopSequence> sequences = new ArrayList<StopSequence>();
        for (Map.Entry entry : tripsByStopSequenceKey.entrySet()) {
            StopSequenceKey key = (StopSequenceKey)entry.getKey();
            StopSequence ss = new StopSequence();
            ss.setId(sequences.size());
            ss.setRoute(null);
            ss.setStops(key.getStops());
            if (!key.getDirectionId().equals(NO_DIRECTION_ID)) {
                ss.setDirectionId(key.getDirectionId());
            }
            if (!key.getShapeId().equals((Object)NO_SHAPE_ID)) {
                ss.setShapeId(key.getShapeId());
            }
            ss.setTrips((List)entry.getValue());
            ss.setTripCount(((List)entry.getValue()).size());
            sequences.add(ss);
        }
        return sequences;
    }

    private List<StopEntry> getStopTimesAsStops(List<StopTimeEntry> stopTimes) {
        ArrayList<StopEntry> stops = new ArrayList<StopEntry>(stopTimes.size());
        for (StopTimeEntry st : stopTimes) {
            stops.add(st.getStop());
        }
        return stops;
    }

    private static class StopSequenceKey {
        private List<StopEntry> stops;
        private String directionId;
        private AgencyAndId shapeId;

        public StopSequenceKey(List<StopEntry> stops, String directionId, AgencyAndId shapeId) {
            this.stops = stops;
            this.directionId = directionId;
            this.shapeId = shapeId;
        }

        public List<StopEntry> getStops() {
            return this.stops;
        }

        public String getDirectionId() {
            return this.directionId;
        }

        public AgencyAndId getShapeId() {
            return this.shapeId;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.directionId == null ? 0 : this.directionId.hashCode());
            result = 31 * result + (this.shapeId == null ? 0 : this.shapeId.hashCode());
            result = 31 * result + (this.stops == null ? 0 : this.stops.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            StopSequenceKey other = (StopSequenceKey)obj;
            if (this.directionId == null ? other.directionId != null : !this.directionId.equals(other.directionId)) {
                return false;
            }
            if (this.shapeId == null ? other.shapeId != null : !this.shapeId.equals((Object)other.shapeId)) {
                return false;
            }
            return !(this.stops == null ? other.stops != null : !this.stops.equals(other.stops));
        }
    }
}

