/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queryparser.classic.MultiFieldQueryParser;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.similarities.ClassicSimilarity;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.onebusaway.container.refresh.Refreshable;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.transit_data_federation.model.SearchResult;
import org.onebusaway.transit_data_federation.services.FederatedTransitDataBundle;
import org.onebusaway.transit_data_federation.services.StopSearchService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StopSearchServiceImpl
implements StopSearchService {
    private static Analyzer _analyzer = new StandardAnalyzer();
    private static String[] CODE_FIELDS = new String[]{"code"};
    private static String[] NAME_FIELDS = new String[]{"name"};
    private FederatedTransitDataBundle _bundle;
    private IndexSearcher _searcher;

    @Autowired
    public void setBundle(FederatedTransitDataBundle bundle) {
        this._bundle = bundle;
    }

    @PostConstruct
    @Refreshable(dependsOn={"stopSearchData"})
    public void initialize() throws IOException {
        File path = this._bundle.getStopSearchIndexPath();
        if (path.exists()) {
            DirectoryReader reader = DirectoryReader.open((Directory)FSDirectory.open((Path)path.toPath()));
            this._searcher = new IndexSearcher((IndexReader)reader);
        } else {
            this._searcher = null;
        }
    }

    @Override
    public SearchResult<AgencyAndId> searchForStopsByCode(String id, int maxResultCount, double minScoreToKeep) throws IOException, ParseException {
        return this.search((QueryParser)new MultiFieldQueryParser(CODE_FIELDS, _analyzer), id, maxResultCount, minScoreToKeep);
    }

    @Override
    public SearchResult<AgencyAndId> searchForStopsByName(String name, int maxResultCount, double minScoreToKeep) throws IOException, ParseException {
        return this.search((QueryParser)new MultiFieldQueryParser(NAME_FIELDS, _analyzer), name, maxResultCount, minScoreToKeep);
    }

    private SearchResult<AgencyAndId> search(QueryParser parser, String value, int maxResultCount, double minScoreToKeep) throws IOException, ParseException {
        if (this._searcher == null) {
            return new SearchResult<AgencyAndId>();
        }
        Query query = parser.parse(value);
        this._searcher.setSimilarity((Similarity)new ClassicSimilarity());
        TopDocs top = this._searcher.search(query, maxResultCount);
        HashMap<AgencyAndId, Float> topScores = new HashMap<AgencyAndId, Float>();
        for (ScoreDoc sd : top.scoreDocs) {
            String stopId;
            String agencyId;
            AgencyAndId id;
            Float existingScore;
            Document document = this._searcher.doc(sd.doc);
            if ((double)sd.score < minScoreToKeep || (existingScore = (Float)topScores.get(id = new AgencyAndId(agencyId = document.get("agencyId"), stopId = document.get("stopId")))) != null && !(existingScore.floatValue() < sd.score)) continue;
            topScores.put(id, Float.valueOf(sd.score));
        }
        ArrayList<AgencyAndId> ids = new ArrayList<AgencyAndId>((int)top.totalHits);
        double[] scores = new double[(int)top.totalHits];
        int index = 0;
        for (AgencyAndId id : topScores.keySet()) {
            ids.add(id);
            scores[index] = ((Float)topScores.get(id)).floatValue();
            ++index;
        }
        return new SearchResult<AgencyAndId>(ids, scores);
    }
}

