/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl;

import org.onebusaway.gtfs.model.calendar.AgencyServiceInterval;
import org.onebusaway.gtfs.model.calendar.LocalizedServiceId;
import org.onebusaway.gtfs.model.calendar.ServiceInterval;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockTripEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.StopEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.StopTimeEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.TripEntry;

public class ServiceIntervalHelper {
    public ServiceInterval getServiceIntervalForTrip(TripEntry trip, StopEntry stopEntry) {
        int intervalStart = Integer.MAX_VALUE;
        int intervalEnd = 0;
        for (StopTimeEntry stopTime : trip.getStopTimes()) {
            if (!stopTime.getStop().equals(stopEntry)) continue;
            if (stopTime.getArrivalTime() > 0) {
                intervalStart = Math.min(intervalStart, stopTime.getArrivalTime());
            }
            if (stopTime.getDepartureTime() <= 0) continue;
            intervalEnd = Math.max(intervalEnd, stopTime.getDepartureTime());
        }
        return new ServiceInterval(intervalStart, intervalEnd);
    }

    public ServiceInterval getServiceIntervalForTrip(TripEntry trip) {
        int tripStartTime = trip.getStopTimes().get(0).getDepartureTime();
        int tripEndTime = -1;
        int position = trip.getStopTimes().size();
        while (tripEndTime < 0 && position > 0) {
            tripEndTime = trip.getStopTimes().get(--position).getArrivalTime();
        }
        ServiceInterval tripInterval = new ServiceInterval(tripStartTime, tripEndTime);
        return tripInterval;
    }

    public ServiceInterval getServiceIntervalForTrip(BlockTripEntry trip) {
        return this.getServiceIntervalForTrip(trip.getTrip());
    }

    public boolean isServiceIntervalActiveInRange(LocalizedServiceId localizedServiceId, ServiceInterval activeService, AgencyServiceInterval agencyServiceInterval) {
        ServiceInterval serviceInterval = agencyServiceInterval.getServiceInterval(localizedServiceId.getId().getAgencyId());
        return Math.max(activeService.getMinArrival(), serviceInterval.getMinArrival()) <= Math.min(activeService.getMaxDeparture(), serviceInterval.getMaxDeparture());
    }
}

