/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.onebusaway.container.cache.Cacheable;
import org.onebusaway.exceptions.InternalErrorServiceException;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.calendar.AgencyServiceInterval;
import org.onebusaway.gtfs.model.calendar.ServiceInterval;
import org.onebusaway.gtfs.services.calendar.CalendarService;
import org.onebusaway.transit_data_federation.impl.ServiceIntervalHelper;
import org.onebusaway.transit_data_federation.services.RouteService;
import org.onebusaway.transit_data_federation.services.blocks.BlockIndexService;
import org.onebusaway.transit_data_federation.services.blocks.BlockStopTimeIndex;
import org.onebusaway.transit_data_federation.services.blocks.FrequencyBlockStopTimeIndex;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockTripEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.RouteCollectionEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.RouteEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.StopEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.StopTimeEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.TransitGraphDao;
import org.onebusaway.transit_data_federation.services.transit_graph.TripEntry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class RouteServiceImpl
implements RouteService {
    private TransitGraphDao _transitGraphDao;
    private BlockIndexService _blockIndexService;
    private CalendarService _calendarService;
    private ServiceIntervalHelper _helper = new ServiceIntervalHelper();

    RouteServiceImpl() {
    }

    @Autowired
    public void setTransitGraphDao(TransitGraphDao transitGraphDao) {
        this._transitGraphDao = transitGraphDao;
    }

    @Autowired
    public void setBlockIndexService(BlockIndexService blockIndexService) {
        this._blockIndexService = blockIndexService;
    }

    @Autowired
    public void setCalendarService(CalendarService calendarService) {
        this._calendarService = calendarService;
    }

    @Override
    @Cacheable
    public Collection<AgencyAndId> getStopsForRouteCollection(AgencyAndId id) {
        return this.getStopsForRouteCollectionForServiceInterval(id, null);
    }

    @Override
    @Cacheable
    public Collection<AgencyAndId> getStopsForRouteCollectionForServiceInterval(AgencyAndId id, AgencyServiceInterval serviceInterval) {
        HashSet<AgencyAndId> stopIds = new HashSet<AgencyAndId>();
        RouteCollectionEntry routeCollectionEntry = this._transitGraphDao.getRouteCollectionForId(id);
        for (RouteEntry route : routeCollectionEntry.getChildren()) {
            List<TripEntry> trips = route.getTrips();
            for (TripEntry trip : trips) {
                boolean isActiveTrip;
                ServiceInterval tripServiceInterval = this._helper.getServiceIntervalForTrip(trip);
                if (serviceInterval != null && !(isActiveTrip = this._blockIndexService.isDynamicTrip(trip) ? this._helper.isServiceIntervalActiveInRange(trip.getServiceId(), tripServiceInterval, serviceInterval) : this._calendarService.isLocalizedServiceIdActiveInRange(trip.getServiceId(), tripServiceInterval, serviceInterval))) continue;
                List<StopTimeEntry> stopTimes = trip.getStopTimes();
                for (StopTimeEntry stopTime : stopTimes) {
                    stopIds.add(stopTime.getStop().getId());
                }
            }
        }
        return new ArrayList<AgencyAndId>(stopIds);
    }

    @Override
    @Cacheable
    public Set<AgencyAndId> getRouteCollectionIdsForStop(AgencyAndId stopId) {
        return this.getRouteCollectionIdsForStopForServiceDate(stopId, null);
    }

    @Override
    @Cacheable
    public Set<AgencyAndId> getRouteCollectionIdsForStopForServiceDate(AgencyAndId stopId, AgencyServiceInterval serviceInterval) {
        StopEntry stopEntry = this._transitGraphDao.getStopEntryForId(stopId);
        if (stopEntry == null) {
            throw new InternalErrorServiceException("no such stop: id=" + stopId);
        }
        HashSet<AgencyAndId> routeCollectionIds = new HashSet<AgencyAndId>();
        List<BlockStopTimeIndex> indices = this._blockIndexService.getStopTimeIndicesForStop(stopEntry);
        for (BlockStopTimeIndex blockStopTimeIndex : indices) {
            for (BlockTripEntry blockTrip : blockStopTimeIndex.getTrips()) {
                TripEntry trip = blockTrip.getTrip();
                AgencyAndId routeCollectionAgencyAndId = trip.getRouteCollection().getId();
                if (routeCollectionIds.contains(routeCollectionAgencyAndId)) continue;
                boolean isActiveTrip = false;
                if (serviceInterval != null) {
                    ServiceInterval stopServiceInterval = this._helper.getServiceIntervalForTrip(trip, stopEntry);
                    isActiveTrip = this._blockIndexService.isDynamicTrip(trip) ? this._helper.isServiceIntervalActiveInRange(trip.getServiceId(), stopServiceInterval, serviceInterval) : this._calendarService.isLocalizedServiceIdActiveInRange(trip.getServiceId(), stopServiceInterval, serviceInterval);
                    if (!isActiveTrip) continue;
                }
                routeCollectionIds.add(routeCollectionAgencyAndId);
            }
        }
        List<FrequencyBlockStopTimeIndex> frequencyIndices = this._blockIndexService.getFrequencyStopTimeIndicesForStop(stopEntry);
        for (FrequencyBlockStopTimeIndex blockStopTimeIndex : frequencyIndices) {
            for (BlockTripEntry blockTrip : blockStopTimeIndex.getTrips()) {
                TripEntry trip = blockTrip.getTrip();
                if (serviceInterval != null) {
                    ServiceInterval stopServiceInterval = this._helper.getServiceIntervalForTrip(trip, stopEntry);
                    boolean isActiveTrip = this._blockIndexService.isDynamicTrip(trip) ? this._helper.isServiceIntervalActiveInRange(trip.getServiceId(), stopServiceInterval, serviceInterval) : this._calendarService.isLocalizedServiceIdActiveInRange(trip.getServiceId(), stopServiceInterval, serviceInterval);
                    if (!isActiveTrip) continue;
                }
                routeCollectionIds.add(trip.getRouteCollection().getId());
            }
        }
        return routeCollectionIds;
    }
}

