/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import javax.annotation.PostConstruct;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queryparser.classic.MultiFieldQueryParser;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.onebusaway.container.refresh.Refreshable;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.transit_data_federation.model.SearchResult;
import org.onebusaway.transit_data_federation.services.FederatedTransitDataBundle;
import org.onebusaway.transit_data_federation.services.RouteCollectionSearchService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RouteCollectionSearchServiceImpl
implements RouteCollectionSearchService {
    public static final String[] ENGLISH_STOP_WORDS = new String[]{"an", "and", "are", "as", "at", "be", "but", "by", "for", "if", "in", "into", "is", "it", "no", "not", "of", "on", "or", "such", "that", "the", "their", "then", "there", "these", "they", "this", "to", "was", "will", "with"};
    private static Analyzer _analyzer = new StandardAnalyzer(new CharArraySet(Arrays.asList(ENGLISH_STOP_WORDS), true));
    private static String[] NAME_FIELDS = new String[]{"shortName", "longName"};
    private FederatedTransitDataBundle _bundle;
    private IndexSearcher _searcher;

    @Autowired
    public void setBundle(FederatedTransitDataBundle bundle) {
        this._bundle = bundle;
    }

    @PostConstruct
    @Refreshable(dependsOn={"routeCollectionSearchData"})
    public void initialize() throws IOException {
        File path = this._bundle.getRouteSearchIndexPath();
        if (path.exists()) {
            DirectoryReader reader = DirectoryReader.open((Directory)FSDirectory.open((Path)path.toPath()));
            this._searcher = new IndexSearcher((IndexReader)reader);
        } else {
            this._searcher = null;
        }
    }

    @Override
    public SearchResult<AgencyAndId> searchForRoutesByName(String value, int maxResultCount, double minScoreToKeep) throws IOException, ParseException {
        return this.search((QueryParser)new MultiFieldQueryParser(NAME_FIELDS, _analyzer), value, maxResultCount, minScoreToKeep);
    }

    private SearchResult<AgencyAndId> search(QueryParser parser, String value, int maxResultCount, double minScoreToKeep) throws IOException, ParseException {
        if (this._searcher == null) {
            return new SearchResult<AgencyAndId>();
        }
        Query query = parser.parse(value);
        TopDocs top = this._searcher.search(query, maxResultCount);
        HashMap<AgencyAndId, Float> topScores = new HashMap<AgencyAndId, Float>();
        String lowerCaseQueryValue = value.toLowerCase();
        for (ScoreDoc sd : top.scoreDocs) {
            String id;
            String agencyId;
            AgencyAndId routeId;
            Float score;
            Document document = this._searcher.doc(sd.doc);
            String routeShortName = document.get("shortName");
            HashSet<String> tokens = new HashSet<String>();
            if (routeShortName != null) {
                for (String token : routeShortName.toLowerCase().split("\\b")) {
                    if (token.isEmpty()) continue;
                    tokens.add(token);
                }
            }
            if ((double)sd.score < minScoreToKeep && !tokens.contains(lowerCaseQueryValue) || (score = (Float)topScores.get(routeId = new AgencyAndId(agencyId = document.get("routeCollectionAgencyId"), id = document.get("routeCollectionId")))) != null && !(score.floatValue() < sd.score)) continue;
            topScores.put(routeId, Float.valueOf(sd.score));
        }
        ArrayList<AgencyAndId> ids = new ArrayList<AgencyAndId>(topScores.size());
        double[] scores = new double[topScores.size()];
        int index = 0;
        for (AgencyAndId id : topScores.keySet()) {
            ids.add(id);
            scores[index] = ((Float)topScores.get(id)).floatValue();
            ++index;
        }
        return new SearchResult<AgencyAndId>(ids, scores);
    }
}

