/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.onebusaway.container.refresh.Refreshable;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.transit_data.model.ConsolidatedStopMapBean;
import org.onebusaway.transit_data_federation.services.ConsolidatedStopsService;
import org.onebusaway.transit_data_federation.services.FederatedTransitDataBundle;
import org.onebusaway.util.AgencyAndIdLibrary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConsolidatedStopsServiceImpl
implements ConsolidatedStopsService {
    private static Logger _log = LoggerFactory.getLogger(ConsolidatedStopsServiceImpl.class);
    private FederatedTransitDataBundle _bundle;
    private Map<AgencyAndId, ConsolidatedStopMapBean> _index;

    @Autowired
    public void setBundle(FederatedTransitDataBundle bundle) {
        this._bundle = bundle;
    }

    @Override
    public Collection<ConsolidatedStopMapBean> getAllConsolidatedStops() {
        if (this._index == null) {
            return new ArrayList<ConsolidatedStopMapBean>();
        }
        return this._index.values();
    }

    @Override
    public AgencyAndId getConsolidatedStopIdForHiddenStopId(AgencyAndId id) {
        if (this._index == null || this._index.get(id) == null) {
            return null;
        }
        return this._index.get(id).getConsolidatedStopId();
    }

    @Refreshable(dependsOn={"stopConsolidationFile"})
    public void init() throws IOException {
        File stopFile = this._bundle.getStopConsolidationFile();
        if (stopFile.exists() && stopFile.isFile()) {
            this.buildIndex(this._bundle.getStopConsolidationFile());
        } else {
            _log.warn("missing Stop Consolidation File; skipping");
        }
    }

    private void buildIndex(File file) throws IOException {
        String line;
        this._index = new HashMap<AgencyAndId, ConsolidatedStopMapBean>();
        FileInputStream in = new FileInputStream(file);
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()).length() == 0 || line.startsWith("#") || line.startsWith("{{{") || line.startsWith("}}}")) continue;
            String[] tokens = line.contains("\"") ? line.split("\"") : line.split("\\s+");
            ArrayList<AgencyAndId> ids = new ArrayList<AgencyAndId>();
            for (String token : tokens) {
                if (!StringUtils.isNotBlank((String)token)) continue;
                ids.add(AgencyAndIdLibrary.convertFromString((String)token));
            }
            List hiddenStops = ids.subList(1, ids.size());
            ConsolidatedStopMapBean bean = new ConsolidatedStopMapBean((AgencyAndId)ids.get(0), hiddenStops);
            for (AgencyAndId stop : hiddenStops) {
                this._index.put(stop, bean);
            }
        }
    }
}

