/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.api.model.transit;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.onebusaway.api.impl.MaxCountSupport;
import org.onebusaway.api.model.RouteGroupingV2Bean;
import org.onebusaway.api.model.StopGroupV2Bean;
import org.onebusaway.api.model.StopGroupingV2Bean;
import org.onebusaway.api.model.transit.AgencyV2Bean;
import org.onebusaway.api.model.transit.AgencyWithCoverageV2Bean;
import org.onebusaway.api.model.transit.ArrivalAndDepartureV2Bean;
import org.onebusaway.api.model.transit.ConfigV2Bean;
import org.onebusaway.api.model.transit.CoordinatePointV2Bean;
import org.onebusaway.api.model.transit.EntryWithReferencesBean;
import org.onebusaway.api.model.transit.FrequencyV2Bean;
import org.onebusaway.api.model.transit.HasId;
import org.onebusaway.api.model.transit.ListWithRangeAndReferencesBean;
import org.onebusaway.api.model.transit.ListWithReferencesBean;
import org.onebusaway.api.model.transit.ReferencesBean;
import org.onebusaway.api.model.transit.RouteScheduleV2Bean;
import org.onebusaway.api.model.transit.RouteSearchResultBean;
import org.onebusaway.api.model.transit.RouteV2Bean;
import org.onebusaway.api.model.transit.ScheduleFrequencyInstanceV2Bean;
import org.onebusaway.api.model.transit.ScheduleStopTimeInstanceExtendedWithStopIdV2Bean;
import org.onebusaway.api.model.transit.ScheduleStopTimeInstanceV2Bean;
import org.onebusaway.api.model.transit.StopCalendarDayV2Bean;
import org.onebusaway.api.model.transit.StopRouteDirectionScheduleV2Bean;
import org.onebusaway.api.model.transit.StopRouteScheduleV2Bean;
import org.onebusaway.api.model.transit.StopScheduleV2Bean;
import org.onebusaway.api.model.transit.StopSearchResultBean;
import org.onebusaway.api.model.transit.StopV2Bean;
import org.onebusaway.api.model.transit.StopWithArrivalsAndDeparturesV2Bean;
import org.onebusaway.api.model.transit.StopWithDistance;
import org.onebusaway.api.model.transit.StopsAndTripsForDirectionV2Bean;
import org.onebusaway.api.model.transit.StopsForRouteV2Bean;
import org.onebusaway.api.model.transit.StopsWithArrivalsAndDeparturesV2Bean;
import org.onebusaway.api.model.transit.TimeIntervalV2;
import org.onebusaway.api.model.transit.TripDetailsV2Bean;
import org.onebusaway.api.model.transit.TripStatusV2Bean;
import org.onebusaway.api.model.transit.TripStopTimeV2Bean;
import org.onebusaway.api.model.transit.TripStopTimesV2Bean;
import org.onebusaway.api.model.transit.TripV2Bean;
import org.onebusaway.api.model.transit.TripWithStopTimesV2Bean;
import org.onebusaway.api.model.transit.VehicleLocationRecordV2Bean;
import org.onebusaway.api.model.transit.VehicleStatusV2Bean;
import org.onebusaway.api.model.transit.blocks.BlockConfigurationV2Bean;
import org.onebusaway.api.model.transit.blocks.BlockInstanceV2Bean;
import org.onebusaway.api.model.transit.blocks.BlockStopTimeV2Bean;
import org.onebusaway.api.model.transit.blocks.BlockTripV2Bean;
import org.onebusaway.api.model.transit.blocks.BlockV2Bean;
import org.onebusaway.api.model.transit.realtime.CurrentVehicleEstimateV2Bean;
import org.onebusaway.api.model.transit.schedule.StopTimeV2Bean;
import org.onebusaway.api.model.transit.service_alerts.NaturalLanguageStringV2Bean;
import org.onebusaway.api.model.transit.service_alerts.SituationAffectsV2Bean;
import org.onebusaway.api.model.transit.service_alerts.SituationConditionDetailsV2Bean;
import org.onebusaway.api.model.transit.service_alerts.SituationConsequenceV2Bean;
import org.onebusaway.api.model.transit.service_alerts.SituationV2Bean;
import org.onebusaway.api.model.transit.service_alerts.TimeRangeV2Bean;
import org.onebusaway.collections.CollectionsLibrary;
import org.onebusaway.geospatial.model.CoordinatePoint;
import org.onebusaway.geospatial.model.EncodedPolylineBean;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.realtime.api.OccupancyStatus;
import org.onebusaway.transit_data.HistoricalRidershipBean;
import org.onebusaway.transit_data.OccupancyStatusBean;
import org.onebusaway.transit_data.model.AgencyBean;
import org.onebusaway.transit_data.model.AgencyWithCoverageBean;
import org.onebusaway.transit_data.model.ArrivalAndDepartureBean;
import org.onebusaway.transit_data.model.ListBean;
import org.onebusaway.transit_data.model.RouteBean;
import org.onebusaway.transit_data.model.RouteGroupingBean;
import org.onebusaway.transit_data.model.RouteScheduleBean;
import org.onebusaway.transit_data.model.RouteSorting;
import org.onebusaway.transit_data.model.RoutesBean;
import org.onebusaway.transit_data.model.StopBean;
import org.onebusaway.transit_data.model.StopCalendarDayBean;
import org.onebusaway.transit_data.model.StopGroupBean;
import org.onebusaway.transit_data.model.StopGroupingBean;
import org.onebusaway.transit_data.model.StopRouteDirectionScheduleBean;
import org.onebusaway.transit_data.model.StopRouteScheduleBean;
import org.onebusaway.transit_data.model.StopScheduleBean;
import org.onebusaway.transit_data.model.StopTimeInstanceBean;
import org.onebusaway.transit_data.model.StopTimeInstanceBeanExtendedWithStopId;
import org.onebusaway.transit_data.model.StopWithArrivalsAndDeparturesBean;
import org.onebusaway.transit_data.model.StopsAndTripsForDirectionBean;
import org.onebusaway.transit_data.model.StopsBean;
import org.onebusaway.transit_data.model.StopsForRouteBean;
import org.onebusaway.transit_data.model.StopsWithArrivalsAndDeparturesBean;
import org.onebusaway.transit_data.model.TimeIntervalBean;
import org.onebusaway.transit_data.model.TripStopTimeBean;
import org.onebusaway.transit_data.model.TripStopTimesBean;
import org.onebusaway.transit_data.model.VehicleStatusBean;
import org.onebusaway.transit_data.model.blocks.BlockBean;
import org.onebusaway.transit_data.model.blocks.BlockConfigurationBean;
import org.onebusaway.transit_data.model.blocks.BlockInstanceBean;
import org.onebusaway.transit_data.model.blocks.BlockStopTimeBean;
import org.onebusaway.transit_data.model.blocks.BlockTripBean;
import org.onebusaway.transit_data.model.config.BundleMetadata;
import org.onebusaway.transit_data.model.realtime.CurrentVehicleEstimateBean;
import org.onebusaway.transit_data.model.realtime.VehicleLocationRecordBean;
import org.onebusaway.transit_data.model.schedule.FrequencyBean;
import org.onebusaway.transit_data.model.schedule.FrequencyInstanceBean;
import org.onebusaway.transit_data.model.schedule.StopTimeBean;
import org.onebusaway.transit_data.model.service_alerts.ESeverity;
import org.onebusaway.transit_data.model.service_alerts.NaturalLanguageStringBean;
import org.onebusaway.transit_data.model.service_alerts.ServiceAlertBean;
import org.onebusaway.transit_data.model.service_alerts.SituationAffectsBean;
import org.onebusaway.transit_data.model.service_alerts.SituationConsequenceBean;
import org.onebusaway.transit_data.model.service_alerts.TimeRangeBean;
import org.onebusaway.transit_data.model.trips.TripBean;
import org.onebusaway.transit_data.model.trips.TripDetailsBean;
import org.onebusaway.transit_data.model.trips.TripStatusBean;
import org.onebusaway.util.AgencyAndIdLibrary;

public class BeanFactoryV2 {
    private boolean _includeReferences = true;
    private boolean _includeConditionDetails = true;
    private ReferencesBean _references = new ReferencesBean();
    private MaxCountSupport _maxCount;
    private String _applicationKey;
    private Locale _locale;
    private RouteSorting customRouteSort;
    private String primarySortAgency;

    public BeanFactoryV2(boolean includeReferences) {
        this._includeReferences = includeReferences;
        this._locale = Locale.getDefault();
    }

    public void setIncludeConditionDetails(boolean includeConditionDetails) {
        this._includeConditionDetails = includeConditionDetails;
    }

    public void setMaxCount(MaxCountSupport maxCount) {
        this._maxCount = maxCount;
    }

    public void setApplicationKey(String applicationKey) {
        this._applicationKey = applicationKey;
    }

    public void setCustomRouteSort(RouteSorting customRouteSort) {
        this.customRouteSort = customRouteSort;
    }

    public void setLocale(Locale locale) {
        this._locale = locale;
    }

    public EntryWithReferencesBean<AgencyV2Bean> getResponse(AgencyBean agency) {
        return this.entry(this.getAgency(agency));
    }

    public EntryWithReferencesBean<RouteV2Bean> getResponse(RouteBean route) {
        return this.entry(this.getRoute(route));
    }

    public EntryWithReferencesBean<EncodedPolylineBean> getResponse(EncodedPolylineBean bean) {
        return this.entry(bean);
    }

    public Object getResponse(StopBean stop) {
        return this.entry(this.getStop(stop));
    }

    public ListWithReferencesBean<StopV2Bean> getResponse(StopSearchResultBean input) {
        ArrayList<StopV2Bean> beans = new ArrayList<StopV2Bean>();
        for (StopBean stop : input.getStopSuggestions().getList()) {
            beans.add(this.getStop(stop));
        }
        ListWithRangeAndReferencesBean<StopV2Bean> response = new ListWithRangeAndReferencesBean<StopV2Bean>(beans, input.getStopSuggestions().isLimitExceeded(), false, this._references);
        response.getReferences().getRoutes().sort((a, b) -> this.customRouteSort.compareRoutes(a.getNullSafeShortName(), b.getNullSafeShortName()));
        this.primarySortAgency = this.customRouteSort.getPrimarySortAgency();
        List<RouteV2Bean> sortedRoutes = this.finalSort(response.getReferences().getRoutes());
        List<AgencyV2Bean> agencyV2BeanList = response.getReferences().getAgencies();
        response.getReferences().setRoutes(sortedRoutes);
        this.agencySort(agencyV2BeanList);
        return response;
    }

    public ListWithReferencesBean<RouteV2Bean> getResponse(RouteSearchResultBean input) {
        ArrayList<RouteV2Bean> beans = new ArrayList<RouteV2Bean>();
        for (RouteBean route : input.getRouteSuggestions().getList()) {
            beans.add(this.getRoute(route));
        }
        ListWithRangeAndReferencesBean<RouteV2Bean> response = new ListWithRangeAndReferencesBean<RouteV2Bean>(beans, input.getRouteSuggestions().isLimitExceeded(), false, this._references);
        response.getList().sort((a, b) -> this.customRouteSort.compareRoutes(a.getNullSafeShortName(), b.getNullSafeShortName()));
        this.primarySortAgency = this.customRouteSort.getPrimarySortAgency();
        List<RouteV2Bean> sortedRoutes = this.finalSort(response.getList());
        List<AgencyV2Bean> agencyV2BeanList = response.getReferences().getAgencies();
        response.setList(sortedRoutes);
        this.agencySort(agencyV2BeanList);
        return response;
    }

    public EntryWithReferencesBean<TripV2Bean> getResponse(TripBean trip) {
        return this.entry(this.getTrip(trip));
    }

    public EntryWithReferencesBean<TripDetailsV2Bean> getResponse(TripDetailsBean tripDetails) {
        return this.entry(this.getTripDetails(tripDetails));
    }

    public EntryWithReferencesBean<BlockV2Bean> getBlockResponse(BlockBean block) {
        return this.entry(this.getBlock(block));
    }

    public EntryWithReferencesBean<StopWithArrivalsAndDeparturesV2Bean> getResponse(StopWithArrivalsAndDeparturesBean result) {
        EntryWithReferencesBean<StopWithArrivalsAndDeparturesV2Bean> response = this.entry(this.getStopWithArrivalAndDepartures(result));
        response.getReferences().getRoutes().sort((a, b) -> this.customRouteSort.compareRoutes(a.getNullSafeShortName(), b.getNullSafeShortName()));
        this.primarySortAgency = this.customRouteSort.getPrimarySortAgency();
        List<RouteV2Bean> sortedRoutes = this.finalSort(response.getReferences().getRoutes());
        List<AgencyV2Bean> agencyV2BeanList = response.getReferences().getAgencies();
        response.getReferences().setRoutes(sortedRoutes);
        this.agencySort(agencyV2BeanList);
        return response;
    }

    public EntryWithReferencesBean<StopsWithArrivalsAndDeparturesV2Bean> getResponse(StopsWithArrivalsAndDeparturesBean result) {
        EntryWithReferencesBean<StopsWithArrivalsAndDeparturesV2Bean> response = this.entry(this.getStopsWithArrivalAndDepartures(result));
        if (response.getReferences().getRoutes() != null) {
            response.getReferences().getRoutes().sort((a, b) -> this.customRouteSort.compareRoutes(a.getNullSafeShortName(), b.getNullSafeShortName()));
        }
        this.primarySortAgency = this.customRouteSort.getPrimarySortAgency();
        List<RouteV2Bean> sortedRoutes = this.finalSort(response.getReferences().getRoutes());
        List<AgencyV2Bean> agencyV2BeanList = response.getReferences().getAgencies();
        response.getReferences().setRoutes(sortedRoutes);
        this.agencySort(agencyV2BeanList);
        return response;
    }

    private void agencySort(List<AgencyV2Bean> agencies) {
        if (this.primarySortAgency != null && agencies != null) {
            agencies.sort((a, b) -> {
                if (a.getId().equals(this.primarySortAgency)) {
                    return -1;
                }
                if (b.getId().equals(this.primarySortAgency)) {
                    return 1;
                }
                return a.getId().compareTo(b.getId());
            });
        }
    }

    private List<RouteV2Bean> finalSort(List<RouteV2Bean> response) {
        if (this.primarySortAgency == null) {
            return response;
        }
        if (response == null) {
            return response;
        }
        List routeV2BeanList = response.stream().filter((? super T r) -> r.getAgencyId().equals(this.primarySortAgency)).collect(Collectors.toList());
        return Stream.concat(routeV2BeanList.stream(), response.stream().filter((? super T r) -> !r.getAgencyId().equals(this.primarySortAgency))).collect(Collectors.toList());
    }

    public EntryWithReferencesBean<ArrivalAndDepartureV2Bean> getResponse(ArrivalAndDepartureBean result) {
        return this.entry(this.getArrivalAndDeparture(result));
    }

    public EntryWithReferencesBean<StopScheduleV2Bean> getResponse(StopScheduleBean stopSchedule) {
        return this.entry(this.getStopSchedule(stopSchedule));
    }

    public EntryWithReferencesBean<RouteScheduleV2Bean> getResponse(RouteScheduleBean routeSchedule) {
        return this.entry(this.getRouteSchedule(routeSchedule));
    }

    public EntryWithReferencesBean<StopsForRouteV2Bean> getResponse(StopsForRouteBean result, boolean includePolylines) {
        return this.entry(this.getStopsForRoute(result, includePolylines));
    }

    public EntryWithReferencesBean<ConfigV2Bean> getResponse(BundleMetadata result) {
        return this.entry(this.getConfig(result));
    }

    public ListWithReferencesBean<AgencyWithCoverageV2Bean> getResponse(List<AgencyWithCoverageBean> beans) {
        ArrayList<AgencyWithCoverageV2Bean> list = new ArrayList<AgencyWithCoverageV2Bean>();
        for (AgencyWithCoverageBean bean : this.filter(beans)) {
            list.add(this.getAgencyWithCoverage(bean));
        }
        return this.list(list, list.size() < beans.size());
    }

    public ListWithReferencesBean<RouteV2Bean> getResponse(RoutesBean result) {
        ArrayList<RouteV2Bean> beans = new ArrayList<RouteV2Bean>();
        for (RouteBean route : result.getRoutes()) {
            beans.add(this.getRoute(route));
        }
        return this.list(beans, result.isLimitExceeded(), false);
    }

    public ListWithReferencesBean<StopV2Bean> getResponse(StopsBean result) {
        ArrayList<StopV2Bean> beans = new ArrayList<StopV2Bean>();
        for (StopBean stop : result.getStops()) {
            beans.add(this.getStop(stop));
        }
        return this.list(beans, result.isLimitExceeded(), false);
    }

    public ListWithReferencesBean<TripDetailsV2Bean> getTripDetailsResponse(ListBean<TripDetailsBean> trips) {
        ArrayList<TripDetailsV2Bean> beans = new ArrayList<TripDetailsV2Bean>();
        for (TripDetailsBean trip : trips.getList()) {
            if (trip == null) continue;
            beans.add(this.getTripDetails(trip));
        }
        return this.list(beans, trips.isLimitExceeded(), false);
    }

    public ListWithReferencesBean<VehicleStatusV2Bean> getVehicleStatusResponse(ListBean<VehicleStatusBean> vehicles) {
        ArrayList<VehicleStatusV2Bean> beans = new ArrayList<VehicleStatusV2Bean>();
        for (VehicleStatusBean vehicle : vehicles.getList()) {
            beans.add(this.getVehicleStatus(vehicle));
        }
        return this.list(beans, vehicles.isLimitExceeded(), false);
    }

    public ListWithReferencesBean<VehicleLocationRecordV2Bean> getVehicleLocationRecordResponse(ListBean<VehicleLocationRecordBean> vehicles) {
        ArrayList<VehicleLocationRecordV2Bean> beans = new ArrayList<VehicleLocationRecordV2Bean>();
        for (VehicleLocationRecordBean vehicle : vehicles.getList()) {
            beans.add(this.getVehicleLocationRecord(vehicle));
        }
        return this.list(beans, vehicles.isLimitExceeded(), false);
    }

    public EntryWithReferencesBean<VehicleStatusV2Bean> getVehicleStatusResponse(VehicleStatusBean vehicleStatus) {
        return this.entry(this.getVehicleStatus(vehicleStatus));
    }

    public ListWithReferencesBean<HistoricalRidershipBean> getHistoricalOccupancyResponse(List<OccupancyStatusBean> beans) {
        ArrayList<HistoricalRidershipBean> rid = new ArrayList<HistoricalRidershipBean>();
        for (OccupancyStatusBean bean : beans) {
            rid.add(new HistoricalRidershipBean(bean.getOccupancyStatus()));
        }
        return this.list(rid, false, false);
    }

    public EntryWithReferencesBean<SituationV2Bean> getResponse(ServiceAlertBean situation) {
        return this.entry(this.getSituation(situation));
    }

    public ListWithReferencesBean<RouteGroupingV2Bean> getResponse(ListBean<RouteGroupingBean> beans) {
        ArrayList<RouteGroupingV2Bean> v2Beans = new ArrayList<RouteGroupingV2Bean>();
        for (RouteGroupingBean routeGroupingBean : beans.getList()) {
            v2Beans.add(this.getRouteGroupingBean(routeGroupingBean));
            for (RouteBean route : routeGroupingBean.getRoutes()) {
                this._references.addRoute(this.getRoute(route));
            }
            for (StopBean stop : routeGroupingBean.getStops()) {
                this._references.addStop(this.getStop(stop));
            }
        }
        return this.list(v2Beans, beans.isLimitExceeded());
    }

    public ListWithReferencesBean<String> getEntityIdsResponse(ListBean<String> ids) {
        return this.list(ids.getList(), ids.isLimitExceeded());
    }

    public <T> ListWithReferencesBean<T> getEmptyList(Class<T> type, boolean outOfRange) {
        return this.list(new ArrayList(), false, outOfRange);
    }

    public TimeIntervalV2 getTimeInterval(TimeIntervalBean interval) {
        if (interval == null) {
            return null;
        }
        TimeIntervalV2 bean = new TimeIntervalV2();
        bean.setFrom(interval.getFrom());
        bean.setTo(interval.getTo());
        return bean;
    }

    public AgencyV2Bean getAgency(AgencyBean agency) {
        AgencyV2Bean bean = new AgencyV2Bean();
        bean.setDisclaimer(agency.getDisclaimer());
        bean.setId(agency.getId());
        bean.setLang(agency.getLang());
        bean.setName(agency.getName());
        bean.setPhone(agency.getPhone());
        bean.setPrivateService(agency.isPrivateService());
        bean.setTimezone(agency.getTimezone());
        bean.setUrl(agency.getUrl());
        bean.setEmail(agency.getEmail());
        bean.setFareUrl(agency.getFareUrl());
        return bean;
    }

    public RouteV2Bean getRoute(RouteBean route) {
        RouteV2Bean bean = new RouteV2Bean();
        bean.setAgencyId(route.getAgency().getId());
        this.addToReferences(route.getAgency());
        bean.setColor(route.getColor());
        bean.setDescription(route.getDescription());
        bean.setId(route.getId());
        bean.setLongName(route.getLongName());
        bean.setShortName(route.getShortName());
        bean.setTextColor(route.getTextColor());
        bean.setType(route.getType());
        bean.setUrl(route.getUrl());
        return bean;
    }

    public ConfigV2Bean getConfig(BundleMetadata meta) {
        ConfigV2Bean bean = new ConfigV2Bean();
        bean.setGitProperties(this.getGitProperties());
        if (meta == null) {
            return bean;
        }
        bean.setId(meta.getId());
        bean.setName(meta.getName());
        bean.setServiceDateFrom(meta.getServiceDateFrom());
        bean.setServiceDateTo(meta.getServiceDateTo());
        return bean;
    }

    public StopV2Bean getStop(StopBean stop) {
        StopV2Bean bean = new StopV2Bean();
        bean.setCode(stop.getCode());
        bean.setDirection(stop.getDirection());
        bean.setId(stop.getId());
        bean.setLat(stop.getLat());
        bean.setLon(stop.getLon());
        bean.setLocationType(stop.getLocationType());
        bean.setName(stop.getName());
        bean.setWheelchairBoarding(stop.getWheelchairBoarding());
        ArrayList<String> routeIds = new ArrayList<String>();
        for (Object route : stop.getRoutes()) {
            routeIds.add(route.getId());
            this.addToReferences((RouteBean)route);
        }
        ArrayList<String> staticRouteIds = new ArrayList<String>();
        if (stop.getStaticRoutes() != null) {
            for (RouteBean staticRoute : stop.getStaticRoutes()) {
                if (staticRoute == null) continue;
                staticRouteIds.add(staticRoute.getId());
                this.addToReferences(staticRoute);
            }
        }
        bean.setRouteIds(routeIds);
        bean.setStaticRouteIds(staticRouteIds);
        if (stop.getParent() != null) {
            StopBean parent = stop.getParent();
            StopV2Bean parentBean = new StopV2Bean();
            parentBean.setCode(parent.getCode());
            parentBean.setDirection(parent.getDirection());
            parentBean.setId(parent.getId());
            parentBean.setLat(parent.getLat());
            parentBean.setLon(parent.getLon());
            parentBean.setLocationType(parent.getLocationType());
            parentBean.setName(parent.getName());
            parentBean.setWheelchairBoarding(parent.getWheelchairBoarding());
            bean.setParent(parentBean.getId());
            this._references.addStop(parentBean);
        }
        return bean;
    }

    public TripV2Bean getTrip(TripBean trip) {
        TripV2Bean bean = new TripV2Bean();
        bean.setId(trip.getId());
        bean.setRouteId(trip.getRoute().getId());
        this.addToReferences(trip.getRoute());
        bean.setRouteShortName(trip.getRouteShortName());
        bean.setTripHeadsign(trip.getTripHeadsign());
        bean.setTripShortName(trip.getTripShortName());
        bean.setDirectionId(trip.getDirectionId());
        bean.setServiceId(trip.getServiceId());
        bean.setShapeId(trip.getShapeId());
        bean.setBlockId(trip.getBlockId());
        bean.setPeakOffpeak(trip.getPeakOffpeak());
        return bean;
    }

    public TripStatusV2Bean getTripStatus(TripStatusBean tripStatus) {
        StopBean nextStop;
        StopBean closestStop;
        TripStatusV2Bean bean = new TripStatusV2Bean();
        TripBean activeTrip = tripStatus.getActiveTrip();
        if (activeTrip != null) {
            bean.setActiveTripId(activeTrip.getId());
            bean.setBlockTripSequence(tripStatus.getBlockTripSequence());
            this.addToReferences(activeTrip);
        }
        bean.setServiceDate(tripStatus.getServiceDate());
        FrequencyBean frequency = tripStatus.getFrequency();
        if (frequency != null) {
            bean.setFrequency(this.getFrequency(frequency));
        }
        bean.setScheduledDistanceAlongTrip(tripStatus.getScheduledDistanceAlongTrip());
        bean.setTotalDistanceAlongTrip(tripStatus.getTotalDistanceAlongTrip());
        bean.setPosition(tripStatus.getLocation());
        if (tripStatus.isOrientationSet()) {
            bean.setOrientation(tripStatus.getOrientation());
        }
        if ((closestStop = tripStatus.getClosestStop()) != null) {
            bean.setClosestStop(closestStop.getId());
            this.addToReferences(closestStop);
            bean.setClosestStopTimeOffset(tripStatus.getClosestStopTimeOffset());
        }
        if ((nextStop = tripStatus.getNextStop()) != null) {
            bean.setNextStop(nextStop.getId());
            this.addToReferences(nextStop);
            bean.setNextStopTimeOffset(tripStatus.getNextStopTimeOffset());
        }
        bean.setPhase(tripStatus.getPhase());
        bean.setStatus(tripStatus.getStatus());
        bean.setPredicted(tripStatus.isPredicted());
        if (tripStatus.getLastUpdateTime() > 0L) {
            bean.setLastUpdateTime(tripStatus.getLastUpdateTime());
        }
        if (tripStatus.getLastLocationUpdateTime() > 0L) {
            bean.setLastLocationUpdateTime(tripStatus.getLastLocationUpdateTime());
        }
        if (tripStatus.isLastKnownDistanceAlongTripSet()) {
            bean.setLastKnownDistanceAlongTrip(tripStatus.getLastKnownDistanceAlongTrip());
        }
        bean.setLastKnownLocation(tripStatus.getLastKnownLocation());
        if (tripStatus.isLastKnownOrientationSet()) {
            bean.setLastKnownOrientation(tripStatus.getLastKnownOrientation());
        }
        if (tripStatus.isScheduleDeviationSet()) {
            bean.setScheduleDeviation((int)tripStatus.getScheduleDeviation());
        }
        if (tripStatus.isDistanceAlongTripSet()) {
            bean.setDistanceAlongTrip(tripStatus.getDistanceAlongTrip());
        }
        bean.setVehicleId(tripStatus.getVehicleId());
        if (tripStatus.getOccupancyStatus() != null) {
            bean.setOccupancyStatus(OccupancyStatus.valueOf((String)tripStatus.getOccupancyStatus()));
        }
        bean.setOccupancyCount(tripStatus.getOccupancyCount());
        bean.setOccupancyCapacity(tripStatus.getOccupancyCapacity());
        bean.setVehicleFeatures(tripStatus.getVehicleFeatures());
        List situations = tripStatus.getSituations();
        if (situations != null && !situations.isEmpty()) {
            ArrayList<String> situationIds = new ArrayList<String>();
            for (ServiceAlertBean situation : situations) {
                situationIds.add(situation.getId());
                this.addToReferences(situation);
            }
            bean.setSituationIds(situationIds);
        }
        return bean;
    }

    public TripStopTimesV2Bean getTripStopTimes(TripStopTimesBean tripStopTimes) {
        FrequencyBean freq;
        TripBean prevTrip;
        TripStopTimesV2Bean bean = new TripStopTimesV2Bean();
        bean.setTimeZone(tripStopTimes.getTimeZone());
        ArrayList<TripStopTimeV2Bean> instances = new ArrayList<TripStopTimeV2Bean>();
        for (TripStopTimeBean sti : tripStopTimes.getStopTimes()) {
            TripStopTimeV2Bean stiBean = new TripStopTimeV2Bean();
            stiBean.setArrivalTime(sti.getArrivalTime());
            stiBean.setDepartureTime(sti.getDepartureTime());
            stiBean.setStopHeadsign(sti.getStopHeadsign());
            stiBean.setDistanceAlongTrip(sti.getDistanceAlongTrip());
            stiBean.setStopId(sti.getStop().getId());
            stiBean.setHistoricalOccupancy(sti.getHistoricalOccupancy());
            this.addToReferences(sti.getStop());
            instances.add(stiBean);
        }
        bean.setStopTimes(instances);
        TripBean nextTrip = tripStopTimes.getNextTrip();
        if (nextTrip != null) {
            bean.setNextTripId(nextTrip.getId());
            this.addToReferences(nextTrip);
        }
        if ((prevTrip = tripStopTimes.getPreviousTrip()) != null) {
            bean.setPreviousTripId(prevTrip.getId());
            this.addToReferences(prevTrip);
        }
        if ((freq = tripStopTimes.getFrequency()) != null) {
            bean.setFrequency(this.getFrequency(freq));
        }
        return bean;
    }

    public TripDetailsV2Bean getTripDetails(TripDetailsBean tripDetails) {
        List situations;
        TripStatusBean status;
        TripStopTimesBean stopTimes;
        TripBean trip;
        TripDetailsV2Bean bean = new TripDetailsV2Bean();
        bean.setTripId(tripDetails.getTripId());
        bean.setServiceDate(tripDetails.getServiceDate());
        if (tripDetails.getFrequency() != null) {
            bean.setFrequency(this.getFrequency(tripDetails.getFrequency()));
        }
        if ((trip = tripDetails.getTrip()) != null) {
            this.addToReferences(trip);
        }
        if ((stopTimes = tripDetails.getSchedule()) != null) {
            bean.setSchedule(this.getTripStopTimes(stopTimes));
        }
        if ((status = tripDetails.getStatus()) != null) {
            bean.setStatus(this.getTripStatus(status));
        }
        if (!CollectionsLibrary.isEmpty((Collection)(situations = tripDetails.getSituations()))) {
            ArrayList<String> situationIds = new ArrayList<String>();
            for (ServiceAlertBean situation : situations) {
                this.addToReferences(situation);
                situationIds.add(situation.getId());
            }
            bean.setSituationIds(situationIds);
        }
        return bean;
    }

    public BlockInstanceV2Bean getBlockInstance(BlockInstanceBean blockInstance) {
        BlockInstanceV2Bean bean = new BlockInstanceV2Bean();
        bean.setBlockConfiguration(this.getBlockConfig(blockInstance.getBlockConfiguration()));
        bean.setBlockId(blockInstance.getBlockId());
        bean.setServiceDate(blockInstance.getServiceDate());
        return bean;
    }

    public BlockV2Bean getBlock(BlockBean block) {
        BlockV2Bean bean = new BlockV2Bean();
        bean.setId(block.getId());
        ArrayList<BlockConfigurationV2Bean> blockConfigs = new ArrayList<BlockConfigurationV2Bean>();
        for (BlockConfigurationBean blockConfig : block.getConfigurations()) {
            blockConfigs.add(this.getBlockConfig(blockConfig));
        }
        bean.setConfigurations(blockConfigs);
        return bean;
    }

    public BlockConfigurationV2Bean getBlockConfig(BlockConfigurationBean blockConfig) {
        BlockConfigurationV2Bean bean = new BlockConfigurationV2Bean();
        bean.setActiveServiceIds(blockConfig.getActiveServiceIds());
        bean.setInactiveServiceIds(blockConfig.getInactiveServiceIds());
        ArrayList<BlockTripV2Bean> blockTrips = new ArrayList<BlockTripV2Bean>();
        for (BlockTripBean blockTrip : blockConfig.getTrips()) {
            blockTrips.add(this.getBlockTrip(blockTrip));
        }
        bean.setTrips(blockTrips);
        return bean;
    }

    public BlockTripV2Bean getBlockTrip(BlockTripBean blockTrip) {
        BlockTripV2Bean bean = new BlockTripV2Bean();
        bean.setAccumulatedSlackTime(blockTrip.getAccumulatedSlackTime());
        bean.setDistanceAlongBlock(blockTrip.getDistanceAlongBlock());
        this.addToReferences(blockTrip.getTrip());
        bean.setTripId(blockTrip.getTrip().getId());
        ArrayList<BlockStopTimeV2Bean> blockStopTimes = new ArrayList<BlockStopTimeV2Bean>();
        for (BlockStopTimeBean blockStopTime : blockTrip.getBlockStopTimes()) {
            BlockStopTimeV2Bean stopTimeBean = this.getBlockStopTime(blockStopTime);
            blockStopTimes.add(stopTimeBean);
        }
        bean.setBlockStopTimes(blockStopTimes);
        return bean;
    }

    public BlockStopTimeV2Bean getBlockStopTime(BlockStopTimeBean blockStopTime) {
        BlockStopTimeV2Bean bean = new BlockStopTimeV2Bean();
        bean.setAccumulatedSlackTime(blockStopTime.getAccumulatedSlackTime());
        bean.setBlockSequence(blockStopTime.getBlockSequence());
        bean.setDistanceAlongBlock(blockStopTime.getDistanceAlongBlock());
        bean.setStopTime(this.getStopTime(blockStopTime.getStopTime()));
        return bean;
    }

    public StopTimeV2Bean getStopTime(StopTimeBean stopTime) {
        StopTimeV2Bean bean = new StopTimeV2Bean();
        bean.setArrivalTime(stopTime.getArrivalTime());
        bean.setDepartureTime(stopTime.getDepartureTime());
        bean.setDropOffType(stopTime.getDropOffType());
        bean.setPickupType(stopTime.getPickupType());
        bean.setStopId(stopTime.getStop().getId());
        this.addToReferences(stopTime.getStop());
        return bean;
    }

    public ScheduleStopTimeInstanceExtendedWithStopIdV2Bean getStopTime(StopTimeInstanceBeanExtendedWithStopId stopTime) {
        ScheduleStopTimeInstanceExtendedWithStopIdV2Bean bean = new ScheduleStopTimeInstanceExtendedWithStopIdV2Bean();
        bean.setArrivalTime(stopTime.getArrivalTime());
        bean.setDepartureTime(stopTime.getDepartureTime());
        bean.setArrivalEnabled(stopTime.isArrivalEnabled());
        bean.setDepartureEnabled(stopTime.isDepartureEnabled());
        bean.setStopHeadsign(stopTime.getStopHeadsign());
        bean.setTripId(stopTime.getTripId());
        bean.setStopId(stopTime.getStopId().toString());
        return bean;
    }

    public RouteGroupingV2Bean getRouteGroupingBean(RouteGroupingBean bean) {
        RouteGroupingV2Bean v2Bean = new RouteGroupingV2Bean();
        v2Bean.setRouteId(bean.getRouteId());
        for (StopGroupingBean stopGrouping : bean.getStopGroupings()) {
            v2Bean.getStopGroupings().add(this.getStopGrouping(stopGrouping));
        }
        return v2Bean;
    }

    public StopGroupingV2Bean getStopGrouping(StopGroupingBean bean) {
        StopGroupingV2Bean v2Bean = new StopGroupingV2Bean();
        v2Bean.setType(bean.getType());
        v2Bean.setOrdered(bean.isOrdered());
        if (bean.getStopGroups() != null) {
            for (StopGroupBean stopGroup : bean.getStopGroups()) {
                StopGroupV2Bean stopGroupV2 = this.getStopGroup(stopGroup);
                if (stopGroupV2 == null) continue;
                v2Bean.getStopGroups().add(stopGroupV2);
            }
        }
        return v2Bean;
    }

    public StopGroupV2Bean getStopGroup(StopGroupBean bean) {
        StopGroupV2Bean v2Bean = new StopGroupV2Bean();
        v2Bean.setId(bean.getId());
        v2Bean.setName(bean.getName());
        if (bean.getStopIds() != null) {
            for (String stopId : bean.getStopIds()) {
                v2Bean.getStopIds().add(stopId);
            }
        }
        if (bean.getSubGroups() != null) {
            for (StopGroupBean subGroup : bean.getSubGroups()) {
                StopGroupV2Bean subGroupV2 = this.getStopGroup(subGroup);
                if (subGroupV2 == null) continue;
                v2Bean.getSubGroups().add(subGroupV2);
            }
        }
        if (bean.getPolylines() != null) {
            for (EncodedPolylineBean polyline : bean.getPolylines()) {
                v2Bean.getPolylines().add(polyline);
            }
        }
        return v2Bean;
    }

    public ListWithReferencesBean<CurrentVehicleEstimateV2Bean> getCurrentVehicleEstimates(ListBean<CurrentVehicleEstimateBean> estimates) {
        if (estimates == null || estimates.getList() == null) {
            return this.list(new ArrayList(), false);
        }
        ArrayList<CurrentVehicleEstimateV2Bean> beans = new ArrayList<CurrentVehicleEstimateV2Bean>();
        for (CurrentVehicleEstimateBean estimate : estimates.getList()) {
            beans.add(this.getCurrentVehicleEstimate(estimate));
        }
        return this.list(beans, estimates.isLimitExceeded());
    }

    public CurrentVehicleEstimateV2Bean getCurrentVehicleEstimate(CurrentVehicleEstimateBean estimate) {
        if (estimate == null) {
            return null;
        }
        CurrentVehicleEstimateV2Bean bean = new CurrentVehicleEstimateV2Bean();
        bean.setProbability(estimate.getProbability());
        bean.setTripStatus(this.getTripStatus(estimate.getTripStatus()));
        bean.setDebug(estimate.getDebug());
        return bean;
    }

    public VehicleStatusV2Bean getVehicleStatus(VehicleStatusBean vehicleStatus) {
        TripStatusBean tripStatus;
        VehicleStatusV2Bean bean = new VehicleStatusV2Bean();
        bean.setLastUpdateTime(vehicleStatus.getLastUpdateTime());
        if (vehicleStatus.getLastLocationUpdateTime() > 0L) {
            bean.setLastLocationUpdateTime(vehicleStatus.getLastLocationUpdateTime());
        }
        bean.setLocation(vehicleStatus.getLocation());
        bean.setPhase(vehicleStatus.getPhase());
        bean.setStatus(vehicleStatus.getStatus());
        bean.setVehicleId(vehicleStatus.getVehicleId());
        if (vehicleStatus.getOccupancyStatus() != null && vehicleStatus.getOccupancyStatus() != OccupancyStatus.UNKNOWN) {
            bean.setOccupancyStatus(vehicleStatus.getOccupancyStatus());
        } else {
            bean.setOccupancyStatus(null);
        }
        if (vehicleStatus.getOccupancyCount() != null) {
            bean.setOccupancyCount(vehicleStatus.getOccupancyCount());
        } else {
            bean.setOccupancyCount(-1);
        }
        if (vehicleStatus.getOccupancyCapacity() != null) {
            if (vehicleStatus.getOccupancyCapacity() > 0) {
                bean.setOccupancyCapacity(vehicleStatus.getOccupancyCapacity());
            } else {
                bean.setOccupancyCapacity(-1);
            }
        } else {
            bean.setOccupancyCapacity(-1);
        }
        TripBean trip = vehicleStatus.getTrip();
        if (trip != null) {
            bean.setTripId(trip.getId());
            this.addToReferences(trip);
        }
        if ((tripStatus = vehicleStatus.getTripStatus()) != null) {
            bean.setTripStatus(this.getTripStatus(tripStatus));
        }
        return bean;
    }

    public VehicleLocationRecordV2Bean getVehicleLocationRecord(VehicleLocationRecordBean record) {
        VehicleLocationRecordV2Bean bean = new VehicleLocationRecordV2Bean();
        bean.setBlockId(record.getBlockId());
        bean.setCurrentLocation(record.getCurrentLocation());
        if (record.isCurrentOrientationSet()) {
            bean.setCurrentOrientation(record.getCurrentOrientation());
        }
        if (record.isDistanceAlongBlockSet()) {
            bean.setDistanceAlongBlock(record.getDistanceAlongBlock());
        }
        bean.setPhase(record.getPhase());
        if (record.isScheduleDeviationSet()) {
            bean.setScheduleDeviation(record.getScheduleDeviation());
        }
        bean.setServiceDate(record.getServiceDate());
        bean.setStatus(record.getStatus());
        bean.setTimeOfRecord(record.getTimeOfRecord());
        bean.setTimeOfLocationUpdate(record.getTimeOfLocationUpdate());
        bean.setTripId(record.getTripId());
        bean.setVehicleId(record.getVehicleId());
        return bean;
    }

    public RouteScheduleV2Bean getRouteSchedule(RouteScheduleBean routeSchedule) {
        RouteScheduleV2Bean bean = new RouteScheduleV2Bean();
        bean.setRouteId(AgencyAndIdLibrary.convertToString((AgencyAndId)routeSchedule.getRouteId()));
        bean.setServiceIds(routeSchedule.getServiceIds().stream().map(serviceId -> serviceId.toString()).collect(Collectors.toList()));
        bean.setScheduleDate(routeSchedule.getScheduleDate().getAsDate().getTime());
        Comparator<StopTimeInstanceBean> comparator = new Comparator<StopTimeInstanceBean>(){

            @Override
            public int compare(StopTimeInstanceBean s1, StopTimeInstanceBean s2) {
                if (!s1.getTripId().equals(s2.getTripId())) {
                    return s1.getTripId().compareTo(s2.getTripId());
                }
                return s1.getArrivalTime() < s2.getArrivalTime() ? -1 : 1;
            }
        };
        ArrayList<StopsAndTripsForDirectionV2Bean> stopTripDirectionBeans = new ArrayList<StopsAndTripsForDirectionV2Bean>();
        for (StopsAndTripsForDirectionBean stdb : routeSchedule.getStopTripDirections()) {
            StopsAndTripsForDirectionV2Bean v2 = new StopsAndTripsForDirectionV2Bean();
            v2.setDirectionId(stdb.getDirectionId());
            v2.setTripHeadsigns(stdb.getTripHeadsigns());
            v2.setStopIds(stdb.getStopIds().stream().map(x -> x.toString()).collect(Collectors.toList()));
            Collections.sort(stdb.getTripIds());
            v2.setTripIds(stdb.getTripIds().stream().map(x -> x.toString()).collect(Collectors.toList()));
            Collections.sort(stdb.getStopTimes(), comparator);
            List stopTimesBeans = stdb.getStopTimes();
            v2.setTripsWithStopTimes(stdb.getTripIds().stream().map(x -> this.getStopTimesForTrip(x.toString(), stopTimesBeans)).collect(Collectors.toList()));
            stopTripDirectionBeans.add(v2);
        }
        bean.setStopTripGroupings(stopTripDirectionBeans);
        this._references.setAgencies(routeSchedule.getAgencies().stream().map(x -> this.getAgency((AgencyBean)x)).collect(Collectors.toList()));
        this._references.setRoutes(routeSchedule.getRoutes().stream().map(x -> this.getRoute((RouteBean)x)).collect(Collectors.toList()));
        this._references.setSituations(routeSchedule.getServiceAlerts().stream().map(x -> this.getSituation((ServiceAlertBean)x)).collect(Collectors.toList()));
        this._references.setStops(routeSchedule.getStops().stream().map(x -> this.getStop((StopBean)x)).collect(Collectors.toList()));
        this._references.setTrips(routeSchedule.getTrips().stream().map(x -> this.getTrip((TripBean)x)).collect(Collectors.toList()));
        this._references.setStopTimes(routeSchedule.getStopTimes().stream().map(x -> this.getStopTime((StopTimeInstanceBeanExtendedWithStopId)x)).collect(Collectors.toList()));
        return bean;
    }

    private TripWithStopTimesV2Bean getStopTimesForTrip(String tripId, List<StopTimeInstanceBeanExtendedWithStopId> sortedStoptimesList) {
        int index = this.getIndexOfFirstStopTimeMatchForTrip(sortedStoptimesList, tripId);
        ArrayList<ScheduleStopTimeInstanceExtendedWithStopIdV2Bean> stopTimesForTrip = new ArrayList<ScheduleStopTimeInstanceExtendedWithStopIdV2Bean>();
        StopTimeInstanceBeanExtendedWithStopId stopTime = sortedStoptimesList.get(index);
        while (stopTime.getTripId().equals(tripId)) {
            ScheduleStopTimeInstanceExtendedWithStopIdV2Bean v2 = this.getStopTime(stopTime);
            stopTimesForTrip.add(v2);
            if (++index >= sortedStoptimesList.size()) break;
            stopTime = sortedStoptimesList.get(index);
        }
        TripWithStopTimesV2Bean tripWithStopTimes = new TripWithStopTimesV2Bean();
        tripWithStopTimes.setTripId(tripId);
        tripWithStopTimes.setStopTimes(stopTimesForTrip);
        return tripWithStopTimes;
    }

    private int getIndexOfFirstStopTimeMatchForTrip(List<StopTimeInstanceBeanExtendedWithStopId> sortedStoptimesList, String trip) {
        int i = this.getIndexStopTimesByTrip(sortedStoptimesList, trip);
        if (i == 0) {
            return i;
        }
        while (sortedStoptimesList.get(--i).getTripId().equals(trip)) {
        }
        return i + 1;
    }

    private int getIndexStopTimesByTrip(List<StopTimeInstanceBeanExtendedWithStopId> sortedStoptimesList, String trip) {
        int min = 0;
        int max = sortedStoptimesList.size() - 1;
        int i = 0;
        if (max == min) {
            return -1;
        }
        if (max == i) {
            return 0;
        }
        while (true) {
            int comparison;
            if ((comparison = sortedStoptimesList.get(i).getTripId().compareTo(trip)) < 0) {
                min = i;
                i = (min + max) / 2 + 1;
                continue;
            }
            if (comparison <= 0) break;
            max = i;
            i = (min + max) / 2;
        }
        return i;
    }

    public StopScheduleV2Bean getStopSchedule(StopScheduleBean stopSchedule) {
        StopScheduleV2Bean bean = new StopScheduleV2Bean();
        StopBean stop = stopSchedule.getStop();
        if (stop != null) {
            this.addToReferences(stop);
            bean.setStopId(stop.getId());
        }
        bean.setDate(stopSchedule.getDate().getTime());
        ArrayList<StopRouteScheduleV2Bean> stopRouteScheduleBeans = new ArrayList<StopRouteScheduleV2Bean>();
        for (StopRouteScheduleBean stopRouteSchedule : stopSchedule.getRoutes()) {
            StopRouteScheduleV2Bean stopRouteScheduleBean = this.getStopRouteSchedule(stopRouteSchedule);
            stopRouteScheduleBeans.add(stopRouteScheduleBean);
        }
        bean.setStopRouteSchedules(stopRouteScheduleBeans);
        return bean;
    }

    public StopRouteScheduleV2Bean getStopRouteSchedule(StopRouteScheduleBean stopRouteSchedule) {
        StopRouteScheduleV2Bean bean = new StopRouteScheduleV2Bean();
        bean.setRouteId(stopRouteSchedule.getRoute().getId());
        this.addToReferences(stopRouteSchedule.getRoute());
        List<StopRouteDirectionScheduleV2Bean> directions = bean.getStopRouteDirectionSchedules();
        for (StopRouteDirectionScheduleBean direction : stopRouteSchedule.getDirections()) {
            directions.add(this.getStopRouteDirectionSchedule(direction));
        }
        return bean;
    }

    public StopRouteDirectionScheduleV2Bean getStopRouteDirectionSchedule(StopRouteDirectionScheduleBean direction) {
        StopRouteDirectionScheduleV2Bean bean = new StopRouteDirectionScheduleV2Bean();
        bean.setTripHeadsign(direction.getTripHeadsign());
        ArrayList<ScheduleStopTimeInstanceV2Bean> stopTimes = new ArrayList<ScheduleStopTimeInstanceV2Bean>();
        for (StopTimeInstanceBean sti : direction.getStopTimes()) {
            ScheduleStopTimeInstanceV2Bean stiBean = new ScheduleStopTimeInstanceV2Bean();
            stiBean.setArrivalEnabled(sti.isArrivalEnabled());
            stiBean.setArrivalTime(sti.getArrivalTime());
            stiBean.setDepartureEnabled(sti.isDepartureEnabled());
            stiBean.setDepartureTime(sti.getDepartureTime());
            stiBean.setServiceId(sti.getServiceId());
            stiBean.setTripId(sti.getTripId());
            stiBean.setStopHeadsign(stiBean.getStopHeadsign());
            stopTimes.add(stiBean);
        }
        if (!stopTimes.isEmpty()) {
            bean.setScheduleStopTimes(stopTimes);
        }
        ArrayList<ScheduleFrequencyInstanceV2Bean> frequencies = new ArrayList<ScheduleFrequencyInstanceV2Bean>();
        for (FrequencyInstanceBean freq : direction.getFrequencies()) {
            ScheduleFrequencyInstanceV2Bean freqBean = new ScheduleFrequencyInstanceV2Bean();
            freqBean.setServiceDate(freq.getServiceDate());
            freqBean.setServiceId(freq.getServiceId());
            freqBean.setTripId(freq.getTripId());
            freqBean.setStartTime(freq.getStartTime());
            freqBean.setEndTime(freq.getEndTime());
            freqBean.setHeadway(freq.getHeadwaySecs());
            freqBean.setStopHeadsign(freq.getStopHeadsign());
            freqBean.setArrivalEnabled(freq.isArrivalEnabled());
            freqBean.setDepartureEnabled(freq.isDepartureEnabled());
            frequencies.add(freqBean);
        }
        if (!frequencies.isEmpty()) {
            bean.setScheduleFrequencies(frequencies);
        }
        return bean;
    }

    public StopCalendarDayV2Bean getStopCalendarDay(StopCalendarDayBean day) {
        StopCalendarDayV2Bean bean = new StopCalendarDayV2Bean();
        bean.setDate(day.getDate().getTime());
        bean.setGroup(day.getGroup());
        return bean;
    }

    public StopsForRouteV2Bean getStopsForRoute(StopsForRouteBean stopsForRoute, boolean includePolylines) {
        StopsForRouteV2Bean bean = new StopsForRouteV2Bean();
        RouteBean route = stopsForRoute.getRoute();
        if (route != null) {
            this.addToReferences(route);
            bean.setRouteId(route.getId());
        }
        ArrayList<String> stopIds = new ArrayList<String>();
        for (StopBean stop : stopsForRoute.getStops()) {
            stopIds.add(stop.getId());
            this.addToReferences(stop);
        }
        bean.setStopIds(stopIds);
        bean.setStopGroupings(stopsForRoute.getStopGroupings());
        if (!includePolylines) {
            for (StopGroupingBean grouping : stopsForRoute.getStopGroupings()) {
                for (StopGroupBean group : grouping.getStopGroups()) {
                    group.setPolylines(null);
                }
            }
        }
        if (includePolylines) {
            bean.setPolylines(stopsForRoute.getPolylines());
        }
        return bean;
    }

    public StopWithArrivalsAndDeparturesV2Bean getStopWithArrivalAndDepartures(StopWithArrivalsAndDeparturesBean sad) {
        StopWithArrivalsAndDeparturesV2Bean bean = new StopWithArrivalsAndDeparturesV2Bean();
        bean.setStopId(sad.getStop().getId());
        this.addToReferences(sad.getStop());
        ArrayList<ArrivalAndDepartureV2Bean> ads = new ArrayList<ArrivalAndDepartureV2Bean>();
        for (Object ad : sad.getArrivalsAndDepartures()) {
            ads.add(this.getArrivalAndDeparture((ArrivalAndDepartureBean)ad));
        }
        bean.setArrivalsAndDepartures(ads);
        ArrayList<String> nearbyStopIds = new ArrayList<String>();
        for (StopBean nearbyStop : sad.getNearbyStops()) {
            nearbyStopIds.add(nearbyStop.getId());
            this.addToReferences(nearbyStop);
        }
        bean.setNearbyStopIds(nearbyStopIds);
        List situations = sad.getSituations();
        if (!CollectionsLibrary.isEmpty((Collection)situations)) {
            ArrayList<String> situationIds = new ArrayList<String>();
            for (ServiceAlertBean situation : situations) {
                this.addToReferences(situation);
                situationIds.add(situation.getId());
            }
            bean.setSituationIds(situationIds);
        }
        return bean;
    }

    public StopsWithArrivalsAndDeparturesV2Bean getStopsWithArrivalAndDepartures(StopsWithArrivalsAndDeparturesBean sad) {
        StopsWithArrivalsAndDeparturesV2Bean bean = new StopsWithArrivalsAndDeparturesV2Bean();
        bean.setStopIds(new ArrayList<String>());
        for (Object sb : sad.getStops()) {
            bean.getStopIds().add(sb.getId());
        }
        ArrayList<ArrivalAndDepartureV2Bean> ads = new ArrayList<ArrivalAndDepartureV2Bean>();
        for (Object ad : sad.getArrivalsAndDepartures()) {
            ads.add(this.getArrivalAndDeparture((ArrivalAndDepartureBean)ad));
        }
        bean.setArrivalsAndDepartures(ads);
        ArrayList<StopWithDistance> nearbyStopIds = new ArrayList<StopWithDistance>();
        for (StopBean nearbyStop : sad.getNearbyStops()) {
            if (nearbyStop.getDistanceAwayFromQuery() == null) continue;
            nearbyStopIds.add(new StopWithDistance(nearbyStop.getId(), nearbyStop.getDistanceAwayFromQuery()));
            this.addToReferences(nearbyStop);
        }
        bean.setNearbyStopIds(nearbyStopIds);
        List situations = sad.getSituations();
        if (!CollectionsLibrary.isEmpty((Collection)situations)) {
            ArrayList<String> situationIds = new ArrayList<String>();
            for (ServiceAlertBean situation : situations) {
                this.addToReferences(situation);
                situationIds.add(situation.getId());
            }
            bean.setSituationIds(situationIds);
        }
        bean.setLimitExceeded(sad.isLimitExceeded());
        return bean;
    }

    public ArrivalAndDepartureV2Bean getArrivalAndDeparture(ArrivalAndDepartureBean ad) {
        TripBean trip = ad.getTrip();
        RouteBean route = trip.getRoute();
        StopBean stop = ad.getStop();
        ArrivalAndDepartureV2Bean bean = new ArrivalAndDepartureV2Bean();
        bean.setTripId(trip.getId());
        this.addToReferences(trip);
        bean.setServiceDate(ad.getServiceDate());
        bean.setVehicleId(ad.getVehicleId());
        bean.setStopId(stop.getId());
        this.addToReferences(stop);
        bean.setStopSequence(ad.getStopSequence());
        bean.setBlockTripSequence(ad.getBlockTripSequence());
        bean.setTotalStopsInTrip(ad.getTotalStopsInTrip());
        bean.setRouteId(route.getId());
        this.addToReferences(route);
        String routeShortName = ad.getRouteShortName();
        if (routeShortName == null || routeShortName.isEmpty()) {
            routeShortName = trip.getRouteShortName();
        }
        if (routeShortName == null || routeShortName.isEmpty()) {
            routeShortName = route.getShortName();
        }
        bean.setRouteShortName(routeShortName);
        bean.setRouteLongName(route.getLongName());
        String tripHeadsign = ad.getTripHeadsign();
        if (tripHeadsign == null || tripHeadsign.isEmpty()) {
            tripHeadsign = trip.getTripHeadsign();
        }
        bean.setTripHeadsign(tripHeadsign);
        bean.setArrivalEnabled(ad.isArrivalEnabled());
        bean.setDepartureEnabled(ad.isDepartureEnabled());
        bean.setScheduledArrivalTime(ad.getScheduledArrivalTime());
        bean.setScheduledDepartureTime(ad.getScheduledDepartureTime());
        bean.setPredictedArrivalTime(ad.getPredictedArrivalTime());
        bean.setPredictedDepartureTime(ad.getPredictedDepartureTime());
        bean.setHistoricalOccupancy(ad.getHistoricalOccupancy());
        bean.setOccupancyStatus(ad.getOccupancyStatus());
        bean.setScheduledArrivalInterval(this.getTimeInterval(ad.getScheduledArrivalInterval()));
        bean.setScheduledDepartureInterval(this.getTimeInterval(ad.getScheduledDepartureInterval()));
        bean.setPredictedArrivalInterval(this.getTimeInterval(ad.getPredictedArrivalInterval()));
        bean.setPredictedDepartureInterval(this.getTimeInterval(ad.getPredictedDepartureInterval()));
        bean.setScheduledTrack(ad.getScheduledTrack());
        bean.setActualTrack(ad.getActualTrack());
        bean.setStatus(ad.getStatus());
        if (ad.getFrequency() != null) {
            bean.setFrequency(this.getFrequency(ad.getFrequency()));
        }
        bean.setStatus(ad.getStatus());
        if (ad.isDistanceFromStopSet()) {
            bean.setDistanceFromStop(ad.getDistanceFromStop());
        }
        bean.setNumberOfStopsAway(ad.getNumberOfStopsAway());
        TripStatusBean tripStatus = ad.getTripStatus();
        if (tripStatus != null) {
            bean.setTripStatus(this.getTripStatus(tripStatus));
        }
        bean.setPredicted(ad.isPredicted());
        bean.setLastUpdateTime(ad.getLastUpdateTime());
        List situations = ad.getSituations();
        if (situations != null && !situations.isEmpty()) {
            ArrayList<String> situationIds = new ArrayList<String>();
            for (ServiceAlertBean situation : situations) {
                situationIds.add(situation.getId());
                this.addToReferences(situation);
            }
            bean.setSituationIds(situationIds);
        }
        return bean;
    }

    public FrequencyV2Bean getFrequency(FrequencyBean frequency) {
        FrequencyV2Bean bean = new FrequencyV2Bean();
        bean.setStartTime(frequency.getStartTime());
        bean.setEndTime(frequency.getEndTime());
        bean.setHeadway(frequency.getHeadway());
        bean.setExactTimes(frequency.getExactTimes());
        return bean;
    }

    public FrequencyBean reverseFrequency(FrequencyV2Bean frequency) {
        FrequencyBean bean = new FrequencyBean();
        bean.setStartTime(frequency.getStartTime());
        bean.setEndTime(frequency.getEndTime());
        bean.setHeadway(frequency.getHeadway());
        bean.setExactTimes(frequency.getExactTimes());
        return bean;
    }

    public boolean isSituationExcludedForApplication(ServiceAlertBean situation) {
        List affects = situation.getAllAffects();
        if (affects == null) {
            return false;
        }
        HashSet<String> applicationIds = new HashSet<String>();
        for (SituationAffectsBean affect : affects) {
            if (affect.getApplicationId() == null) continue;
            applicationIds.add(affect.getApplicationId());
        }
        if (CollectionsLibrary.isEmpty(applicationIds)) {
            return false;
        }
        if (this._applicationKey == null) {
            return true;
        }
        return !this._applicationKey.contains(this._applicationKey);
    }

    public SituationV2Bean getSituation(ServiceAlertBean situation) {
        SituationV2Bean bean = new SituationV2Bean();
        bean.setId(situation.getId());
        bean.setCreationTime(situation.getCreationTime());
        if (!CollectionsLibrary.isEmpty((Collection)situation.getActiveWindows())) {
            ArrayList<TimeRangeV2Bean> activeWindows = new ArrayList<TimeRangeV2Bean>();
            for (TimeRangeBean activeWindow : situation.getActiveWindows()) {
                activeWindows.add(this.getTimeRange(activeWindow));
            }
            bean.setActiveWindows(activeWindows);
        }
        if (!CollectionsLibrary.isEmpty((Collection)situation.getPublicationWindows())) {
            ArrayList<TimeRangeV2Bean> publicationWindows = new ArrayList<TimeRangeV2Bean>();
            for (TimeRangeBean publicationWindow : situation.getPublicationWindows()) {
                publicationWindows.add(this.getTimeRange(publicationWindow));
            }
            bean.setPublicationWindows(publicationWindows);
        }
        if (!CollectionsLibrary.isEmpty((Collection)situation.getAllAffects())) {
            ArrayList<SituationAffectsV2Bean> affects = new ArrayList<SituationAffectsV2Bean>();
            for (SituationAffectsBean affect : situation.getAllAffects()) {
                affects.add(this.getSituationAffects(affect));
            }
            bean.setAllAffects(affects);
        }
        if (!CollectionsLibrary.isEmpty((Collection)situation.getConsequences())) {
            ArrayList<SituationConsequenceV2Bean> beans = new ArrayList<SituationConsequenceV2Bean>();
            for (SituationConsequenceBean consequence : situation.getConsequences()) {
                SituationConsequenceV2Bean consequenceBean = this.getSituationConsequence(consequence);
                beans.add(consequenceBean);
            }
            bean.setConsequences(beans);
        }
        bean.setReason(situation.getReason());
        bean.setConsequenceMessage(situation.getConsequenceMessage());
        bean.setSummary(this.getBestString(situation.getSummaries()));
        bean.setDescription(this.getBestString(situation.getDescriptions()));
        bean.setUrl(this.getBestString(situation.getUrls()));
        ESeverity severity = situation.getSeverity();
        if (severity != null) {
            String[] codes = severity.getTpegCodes();
            bean.setSeverity(codes[0]);
        }
        return bean;
    }

    public SituationAffectsV2Bean getSituationAffects(SituationAffectsBean affects) {
        SituationAffectsV2Bean bean = new SituationAffectsV2Bean();
        bean.setAgencyId(affects.getAgencyId());
        bean.setApplicationId(affects.getApplicationId());
        bean.setDirectionId(affects.getDirectionId());
        bean.setRouteId(affects.getRouteId());
        bean.setStopId(affects.getStopId());
        bean.setTripId(affects.getTripId());
        return bean;
    }

    private SituationConsequenceV2Bean getSituationConsequence(SituationConsequenceBean consequence) {
        SituationConsequenceV2Bean bean = new SituationConsequenceV2Bean();
        if (consequence.getEffect() != null) {
            bean.setCondition(consequence.getEffect().toString().toLowerCase());
        }
        if (this._includeConditionDetails && (consequence.getDetourPath() != null || !CollectionsLibrary.isEmpty((Collection)consequence.getDetourStopIds()))) {
            SituationConditionDetailsV2Bean detailsBean = new SituationConditionDetailsV2Bean();
            if (consequence.getDetourPath() != null) {
                EncodedPolylineBean poly = new EncodedPolylineBean();
                poly.setPoints(consequence.getDetourPath());
                detailsBean.setDiversionPath(poly);
            }
            detailsBean.setDiversionStopIds(consequence.getDetourStopIds());
            bean.setConditionDetails(detailsBean);
        }
        return bean;
    }

    public AgencyWithCoverageV2Bean getAgencyWithCoverage(AgencyWithCoverageBean awc) {
        AgencyWithCoverageV2Bean bean = new AgencyWithCoverageV2Bean();
        bean.setAgencyId(awc.getAgency().getId());
        bean.setLat(awc.getLat());
        bean.setLon(awc.getLon());
        bean.setLatSpan(awc.getLatSpan());
        bean.setLonSpan(awc.getLonSpan());
        this.addToReferences(awc.getAgency());
        return bean;
    }

    public NaturalLanguageStringV2Bean getBestString(List<NaturalLanguageStringBean> strings) {
        if (strings == null || strings.isEmpty()) {
            return null;
        }
        NaturalLanguageStringBean noLang = null;
        for (NaturalLanguageStringBean nls : strings) {
            String lang = nls.getLang();
            if (lang == null) {
                noLang = nls;
                continue;
            }
            Locale locale = new Locale(lang);
            if (!locale.getLanguage().equals(this._locale.getLanguage())) continue;
            return this.getString(nls);
        }
        if (noLang != null) {
            return this.getString(noLang);
        }
        return null;
    }

    public NaturalLanguageStringV2Bean getString(NaturalLanguageStringBean nls) {
        if (nls == null) {
            return null;
        }
        if (nls.getValue() == null || nls.getValue().isEmpty()) {
            return null;
        }
        NaturalLanguageStringV2Bean bean = new NaturalLanguageStringV2Bean();
        bean.setLang(nls.getLang());
        bean.setValue(nls.getValue());
        return bean;
    }

    public TimeRangeV2Bean getTimeRange(TimeRangeBean range) {
        if (range == null) {
            return null;
        }
        TimeRangeV2Bean bean = new TimeRangeV2Bean();
        if (range.getFrom() > 0L) {
            bean.setFrom(range.getFrom());
        }
        if (range.getTo() > 0L) {
            bean.setTo(range.getTo());
        }
        return bean;
    }

    public CoordinatePointV2Bean getPoint(CoordinatePoint point) {
        if (point == null) {
            return null;
        }
        CoordinatePointV2Bean bean = new CoordinatePointV2Bean();
        bean.setLat(point.getLat());
        bean.setLon(point.getLon());
        return bean;
    }

    public CoordinatePoint reversePoint(CoordinatePointV2Bean bean) {
        if (bean == null) {
            return null;
        }
        return new CoordinatePoint(bean.getLat(), bean.getLon());
    }

    public void addToReferences(AgencyBean agency) {
        if (!this.shouldAddReferenceWithId(this._references.getAgencies(), agency.getId())) {
            return;
        }
        AgencyV2Bean bean = this.getAgency(agency);
        this._references.addAgency(bean);
    }

    public void addToReferences(RouteBean route) {
        if (!this.shouldAddReferenceWithId(this._references.getRoutes(), route.getId())) {
            return;
        }
        RouteV2Bean bean = this.getRoute(route);
        this._references.addRoute(bean);
    }

    public void addToReferences(StopBean stop) {
        if (!this.shouldAddReferenceWithId(this._references.getStops(), stop.getId())) {
            return;
        }
        StopV2Bean bean = this.getStop(stop);
        this._references.addStop(bean);
    }

    public void addToReferences(TripBean trip) {
        if (!this.shouldAddReferenceWithId(this._references.getTrips(), trip.getId())) {
            return;
        }
        TripV2Bean bean = this.getTrip(trip);
        this._references.addTrip(bean);
    }

    public void addToReferences(ServiceAlertBean situation) {
        if (this.isSituationExcludedForApplication(situation)) {
            return;
        }
        if (!this.shouldAddReferenceWithId(this._references.getSituations(), situation.getId())) {
            return;
        }
        SituationV2Bean bean = this.getSituation(situation);
        this._references.addSituation(bean);
    }

    public <T> EntryWithReferencesBean<T> entry(T entry) {
        return new EntryWithReferencesBean<T>(entry, this._references);
    }

    public <T> ListWithReferencesBean<T> list(List<T> list, boolean limitExceeded) {
        return new ListWithReferencesBean<T>(list, limitExceeded, this._references);
    }

    public <T> ListWithReferencesBean<T> list(List<T> list, boolean limitExceeded, boolean outOfRange) {
        return new ListWithRangeAndReferencesBean<T>(list, limitExceeded, outOfRange, this._references);
    }

    public boolean isStringSet(String value) {
        return value != null && !value.isEmpty();
    }

    private <T> List<T> filter(List<T> beans) {
        if (this._maxCount == null) {
            return beans;
        }
        return this._maxCount.filter(beans, false);
    }

    private <T extends HasId> boolean shouldAddReferenceWithId(Iterable<T> entities, String id) {
        if (!this._includeReferences) {
            return false;
        }
        if (entities == null) {
            return true;
        }
        for (HasId entity : entities) {
            if (!entity.getId().equals(id)) continue;
            return false;
        }
        return true;
    }

    private Properties getGitProperties() {
        Properties properties = new Properties();
        try {
            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("git.properties");
            if (inputStream != null) {
                properties.load(inputStream);
            }
            return properties;
        }
        catch (IOException ioe) {
            return null;
        }
    }
}

