/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class DetachInstancesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private SdkInternalList<String> instanceIds;
    private String autoScalingGroupName;
    private Boolean shouldDecrementDesiredCapacity;

    public List<String> getInstanceIds() {
        if (this.instanceIds == null) {
            this.instanceIds = new SdkInternalList();
        }
        return this.instanceIds;
    }

    public void setInstanceIds(Collection<String> instanceIds) {
        if (instanceIds == null) {
            this.instanceIds = null;
            return;
        }
        this.instanceIds = new SdkInternalList(instanceIds);
    }

    public DetachInstancesRequest withInstanceIds(String ... instanceIds) {
        if (this.instanceIds == null) {
            this.setInstanceIds((Collection<String>)new SdkInternalList(instanceIds.length));
        }
        for (String ele : instanceIds) {
            this.instanceIds.add((Object)ele);
        }
        return this;
    }

    public DetachInstancesRequest withInstanceIds(Collection<String> instanceIds) {
        this.setInstanceIds(instanceIds);
        return this;
    }

    public void setAutoScalingGroupName(String autoScalingGroupName) {
        this.autoScalingGroupName = autoScalingGroupName;
    }

    public String getAutoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public DetachInstancesRequest withAutoScalingGroupName(String autoScalingGroupName) {
        this.setAutoScalingGroupName(autoScalingGroupName);
        return this;
    }

    public void setShouldDecrementDesiredCapacity(Boolean shouldDecrementDesiredCapacity) {
        this.shouldDecrementDesiredCapacity = shouldDecrementDesiredCapacity;
    }

    public Boolean getShouldDecrementDesiredCapacity() {
        return this.shouldDecrementDesiredCapacity;
    }

    public DetachInstancesRequest withShouldDecrementDesiredCapacity(Boolean shouldDecrementDesiredCapacity) {
        this.setShouldDecrementDesiredCapacity(shouldDecrementDesiredCapacity);
        return this;
    }

    public Boolean isShouldDecrementDesiredCapacity() {
        return this.shouldDecrementDesiredCapacity;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getInstanceIds() != null) {
            sb.append("InstanceIds: ").append(this.getInstanceIds()).append(",");
        }
        if (this.getAutoScalingGroupName() != null) {
            sb.append("AutoScalingGroupName: ").append(this.getAutoScalingGroupName()).append(",");
        }
        if (this.getShouldDecrementDesiredCapacity() != null) {
            sb.append("ShouldDecrementDesiredCapacity: ").append(this.getShouldDecrementDesiredCapacity());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetachInstancesRequest)) {
            return false;
        }
        DetachInstancesRequest other = (DetachInstancesRequest)obj;
        if (other.getInstanceIds() == null ^ this.getInstanceIds() == null) {
            return false;
        }
        if (other.getInstanceIds() != null && !other.getInstanceIds().equals(this.getInstanceIds())) {
            return false;
        }
        if (other.getAutoScalingGroupName() == null ^ this.getAutoScalingGroupName() == null) {
            return false;
        }
        if (other.getAutoScalingGroupName() != null && !other.getAutoScalingGroupName().equals(this.getAutoScalingGroupName())) {
            return false;
        }
        if (other.getShouldDecrementDesiredCapacity() == null ^ this.getShouldDecrementDesiredCapacity() == null) {
            return false;
        }
        return other.getShouldDecrementDesiredCapacity() == null || other.getShouldDecrementDesiredCapacity().equals(this.getShouldDecrementDesiredCapacity());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getInstanceIds() == null ? 0 : this.getInstanceIds().hashCode());
        hashCode = 31 * hashCode + (this.getAutoScalingGroupName() == null ? 0 : this.getAutoScalingGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getShouldDecrementDesiredCapacity() == null ? 0 : this.getShouldDecrementDesiredCapacity().hashCode());
        return hashCode;
    }

    public DetachInstancesRequest clone() {
        return (DetachInstancesRequest)super.clone();
    }
}

