/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.factory;

import java.awt.RenderingHints;
import java.util.Map;
import java.util.Set;
import org.geotools.factory.Factory;
import org.geotools.util.Utilities;

final class FactoryComparator {
    private final Factory f1;
    private final Factory f2;

    FactoryComparator(Factory f1, Factory f2) {
        this.f1 = f1;
        this.f2 = f2;
    }

    boolean compare(Set<FactoryComparator> done) {
        if (done.add(this)) {
            Map<RenderingHints.Key, ?> m1 = this.f1.getImplementationHints();
            Map<RenderingHints.Key, ?> m2 = this.f2.getImplementationHints();
            if (m1.size() != m2.size()) {
                return false;
            }
            for (Map.Entry<RenderingHints.Key, ?> entry : m1.entrySet()) {
                Object v2;
                RenderingHints.Key key = entry.getKey();
                Object v1 = entry.getValue();
                if (v1 == (v2 = m2.get(key)) || !(v1 instanceof Factory ? v2 == null || !v1.getClass().equals(v2.getClass()) || !new FactoryComparator((Factory)v1, (Factory)v2).compare(done) : !Utilities.equals(v1, v2))) continue;
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object object) {
        if (object instanceof FactoryComparator) {
            FactoryComparator that = (FactoryComparator)object;
            return this.f1 == that.f1 && this.f2 == that.f2 || this.f1 == that.f2 && this.f2 == that.f1;
        }
        return false;
    }

    public int hashCode() {
        return System.identityHashCode(this.f1) + System.identityHashCode(this.f2);
    }
}

