/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.utility.collections;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class TreeUnionFind<T> {
    private Map<T, SentryImpl> _elementToSentry = new HashMap<T, SentryImpl>();

    public boolean contains(T target) {
        return this._elementToSentry.containsKey(target);
    }

    public Sentry find(T target) {
        SentryImpl s = this._elementToSentry.get(target);
        if (s == null) {
            s = new SentryImpl(target);
            this._elementToSentry.put(target, s);
        }
        return this.compress(s);
    }

    public Set<T> members(Sentry sentry) {
        HashSet m = new HashSet();
        this.addElements((SentryImpl)sentry, m);
        return m;
    }

    public Sentry union(T a, T b) {
        return this.unionWithSentries(this.find(a), this.find(b));
    }

    public Sentry unionWithSentry(Sentry sentry, T value) {
        return this.unionWithSentries(sentry, this.find(value));
    }

    public Sentry unionWithSentries(Sentry a, Sentry b) {
        SentryImpl sa = (SentryImpl)a;
        SentryImpl sb = (SentryImpl)b;
        if (sa == sb) {
            return sa;
        }
        if (Math.random() < 0.5) {
            sa.root = sb;
            sb.children.add(sa);
            return sb;
        }
        sb.root = sa;
        sa.children.add(sb);
        return sa;
    }

    public Collection<Sentry> getSets() {
        HashSet<Sentry> retro = new HashSet<Sentry>();
        for (SentryImpl sentry : this._elementToSentry.values()) {
            SentryImpl root = this.compress(sentry);
            retro.add(root);
        }
        return retro;
    }

    public Iterable<Set<T>> getSetMembers() {
        return new Iterable<Set<T>>(){

            @Override
            public Iterator<Set<T>> iterator() {
                return new SetIterator();
            }
        };
    }

    public int size() {
        return this._elementToSentry.size();
    }

    public boolean isEmpty() {
        return this._elementToSentry.isEmpty();
    }

    public Set<T> getElements() {
        return Collections.unmodifiableSet(this._elementToSentry.keySet());
    }

    public Iterator<T> iterator() {
        return this.getElements().iterator();
    }

    public boolean isSameSet(T a, T b) {
        if (a.equals(b)) {
            return true;
        }
        if (!this.contains(a) || !this.contains(b)) {
            return false;
        }
        Sentry sa = this.find(a);
        Sentry sb = this.find(b);
        return sa != null && sb != null && sa.equals(sb);
    }

    private SentryImpl compress(SentryImpl sentry) {
        SentryImpl root;
        if (sentry.root == sentry) {
            return sentry;
        }
        sentry.root = root = this.compress(sentry.root);
        return root;
    }

    private void addElements(SentryImpl sentry, Set<T> elements) {
        elements.addAll(sentry.elements);
        for (SentryImpl s : sentry.children) {
            this.addElements(s, elements);
        }
    }

    private class SetIterator
    implements Iterator<Set<T>> {
        private Iterator<Sentry> _sentries;

        public SetIterator() {
            this._sentries = TreeUnionFind.this.getSets().iterator();
        }

        @Override
        public boolean hasNext() {
            return this._sentries.hasNext();
        }

        @Override
        public Set<T> next() {
            return TreeUnionFind.this.members(this._sentries.next());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class SentryImpl
    implements Sentry {
        public SentryImpl root;
        public Set<T> elements = new HashSet();
        public Set<SentryImpl> children = new HashSet<SentryImpl>();

        public SentryImpl(T target) {
            this.elements.add(target);
            this.root = this;
        }
    }

    public static interface Sentry {
    }
}

