/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.utility;

import java.util.Arrays;
import java.util.Iterator;
import java.util.SortedMap;
import org.onebusaway.utility.EInRangeStrategy;
import org.onebusaway.utility.EOutOfRangeStrategy;
import org.onebusaway.utility.InterpolationStrategy;

public class InterpolationLibrary {
    private static final String OUT_OF_RANGE = "attempt to interpolate key outside range of key-value data";
    private static final NumberInterpolationStrategy _numberInterpolation = new NumberInterpolationStrategy();

    public static <K extends Number, V extends Number> double interpolate(SortedMap<K, V> values, K target) {
        return InterpolationLibrary.interpolate(values, target, EOutOfRangeStrategy.INTERPOLATE);
    }

    public static <K extends Number, V extends Number> double interpolate(SortedMap<K, V> values, K target, EOutOfRangeStrategy outOfRangeStrategy) {
        Number result = InterpolationLibrary.interpolate(_numberInterpolation, outOfRangeStrategy, values, target);
        return result.doubleValue();
    }

    public static <K extends Number, V> V nearestNeighbor(SortedMap<K, V> values, K target) {
        if (values.isEmpty()) {
            return null;
        }
        SortedMap<K, V> before = values.headMap(target);
        SortedMap<K, V> after = values.tailMap(target);
        if (before.isEmpty()) {
            return after.get(after.firstKey());
        }
        if (after.isEmpty()) {
            return before.get(before.lastKey());
        }
        Number a = (Number)before.lastKey();
        Number b = (Number)after.firstKey();
        if (Math.abs(b.doubleValue() - target.doubleValue()) < Math.abs(a.doubleValue() - target.doubleValue())) {
            return after.get(b);
        }
        return before.get(a);
    }

    public static double interpolate(double[] keys, double[] values, double target, EOutOfRangeStrategy outOfRangeStrategy) {
        return InterpolationLibrary.interpolate(keys, values, target, outOfRangeStrategy, null);
    }

    public static double interpolate(double[] keys, double[] values, double target, EOutOfRangeStrategy outOfRangeStrategy, EInRangeStrategy inRangeStrategy) {
        if (values.length == 0) {
            throw new IndexOutOfBoundsException(OUT_OF_RANGE);
        }
        int index = Arrays.binarySearch(keys, target);
        if (index >= 0) {
            return values[index];
        }
        if ((index = -(index + 1)) == values.length) {
            switch (outOfRangeStrategy) {
                case INTERPOLATE: {
                    if (values.length > 1) {
                        return InterpolationLibrary.interpolatePair(keys[index - 2], values[index - 2], keys[index - 1], values[index - 1], target);
                    }
                    return values[index - 1];
                }
                case LAST_VALUE: {
                    return values[index - 1];
                }
                case EXCEPTION: {
                    throw new IndexOutOfBoundsException(OUT_OF_RANGE);
                }
            }
        }
        if (index == 0) {
            switch (outOfRangeStrategy) {
                case INTERPOLATE: {
                    if (values.length > 1) {
                        return InterpolationLibrary.interpolatePair(keys[0], values[0], keys[1], values[1], target);
                    }
                    return values[0];
                }
                case LAST_VALUE: {
                    return values[0];
                }
                case EXCEPTION: {
                    throw new IndexOutOfBoundsException(OUT_OF_RANGE);
                }
            }
        }
        if (inRangeStrategy == null) {
            inRangeStrategy = EInRangeStrategy.INTERPOLATE;
        }
        switch (inRangeStrategy) {
            case PREVIOUS_VALUE: {
                return values[index - 1];
            }
        }
        return InterpolationLibrary.interpolatePair(keys[index - 1], values[index - 1], keys[index], values[index], target);
    }

    public static double interpolatePair(double fromValue, double toValue, double ratio) {
        return ratio * (toValue - fromValue) + fromValue;
    }

    public static double interpolatePair(double keyA, double valueA, double keyB, double valueB, double targetKey) {
        double ratio = (targetKey - keyA) / (keyB - keyA);
        return InterpolationLibrary.interpolatePair(valueA, valueB, ratio);
    }

    public static <KEY extends Number, VALUE, ANY_KEY extends KEY, ANY_VALUE extends VALUE> VALUE interpolate(InterpolationStrategy<KEY, VALUE> interpolationStrategy, EOutOfRangeStrategy outOfRangeStrategy, SortedMap<ANY_KEY, ANY_VALUE> values, ANY_KEY target) {
        if (values.containsKey(target)) {
            return (VALUE)values.get(target);
        }
        SortedMap<Object, ANY_VALUE> before = values.headMap(target);
        SortedMap<ANY_KEY, ANY_VALUE> after = values.tailMap(target);
        Number prevKey = null;
        Number nextKey = null;
        if (before.isEmpty()) {
            if (after.isEmpty()) {
                throw new IndexOutOfBoundsException(OUT_OF_RANGE);
            }
            switch (outOfRangeStrategy) {
                case INTERPOLATE: {
                    if (after.size() == 1) {
                        return (VALUE)after.get(after.firstKey());
                    }
                    Iterator<ANY_KEY> it = after.keySet().iterator();
                    prevKey = (Number)it.next();
                    nextKey = (Number)it.next();
                    break;
                }
                case LAST_VALUE: {
                    return (VALUE)after.get(after.firstKey());
                }
                case EXCEPTION: {
                    throw new IndexOutOfBoundsException(OUT_OF_RANGE);
                }
            }
        } else if (after.isEmpty()) {
            if (before.isEmpty()) {
                throw new IndexOutOfBoundsException(OUT_OF_RANGE);
            }
            switch (outOfRangeStrategy) {
                case INTERPOLATE: {
                    if (before.size() == 1) {
                        return (VALUE)before.get(before.lastKey());
                    }
                    nextKey = (Number)before.lastKey();
                    before = before.headMap(nextKey);
                    prevKey = (Number)before.lastKey();
                    break;
                }
                case LAST_VALUE: {
                    return (VALUE)before.get(before.lastKey());
                }
                case EXCEPTION: {
                    throw new IndexOutOfBoundsException(OUT_OF_RANGE);
                }
            }
        } else {
            prevKey = (Number)before.lastKey();
            nextKey = (Number)after.firstKey();
        }
        Object prevValue = values.get(prevKey);
        Object nextValue = values.get(nextKey);
        double keyRatio = (((Number)target).doubleValue() - prevKey.doubleValue()) / (nextKey.doubleValue() - prevKey.doubleValue());
        VALUE result = interpolationStrategy.interpolate(prevKey, prevValue, nextKey, nextValue, keyRatio);
        return result;
    }

    private static class NumberInterpolationStrategy
    implements InterpolationStrategy<Number, Number> {
        private NumberInterpolationStrategy() {
        }

        @Override
        public Number interpolate(Number prevKey, Number prevValue, Number nextKey, Number nextValue, double ratio) {
            double result = InterpolationLibrary.interpolatePair(prevValue.doubleValue(), nextValue.doubleValue(), ratio);
            return new Double(result);
        }
    }
}

