/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.guice.jsr250;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.Matchers;
import com.google.inject.spi.InjectionListener;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.onebusaway.guice.jsr250.LifecycleService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSR250Module
extends AbstractModule {
    private static final Logger _log = LoggerFactory.getLogger(JSR250Module.class);

    public static void addModuleAndDependencies(Set<Module> modules) {
        modules.add((Module)new JSR250Module());
    }

    protected void configure() {
        final ArrayList<ObjectAndMethod> postConstructActions = new ArrayList<ObjectAndMethod>();
        final ArrayList<ObjectAndMethod> preDestroyActions = new ArrayList<ObjectAndMethod>();
        this.bindListener(Matchers.any(), new TypeListener(){

            public <I> void hear(TypeLiteral<I> injectableType, TypeEncounter<I> encounter) {
                for (Class type = injectableType.getRawType(); type != null; type = type.getSuperclass()) {
                    Method[] methods;
                    for (Method method : methods = type.getDeclaredMethods()) {
                        PreDestroy preDestory;
                        PostConstruct postConstruct = method.getAnnotation(PostConstruct.class);
                        if (postConstruct != null) {
                            encounter.register(new RegisterMethodCallback(postConstructActions, method));
                        }
                        if ((preDestory = method.getAnnotation(PreDestroy.class)) == null) continue;
                        encounter.register(new RegisterMethodCallback(preDestroyActions, method));
                    }
                }
            }
        });
        LifecycleServiceImpl service = new LifecycleServiceImpl(postConstructActions, preDestroyActions);
        this.bind(LifecycleService.class).toInstance((Object)service);
        Runtime runtime = Runtime.getRuntime();
        PreDestroyShutdownHook hook = new PreDestroyShutdownHook(service);
        runtime.addShutdownHook(new Thread(hook));
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        return ((Object)((Object)this)).getClass().equals(o.getClass());
    }

    private static class PreDestroyShutdownHook
    implements Runnable {
        private LifecycleService _service;

        public PreDestroyShutdownHook(LifecycleService service) {
            this._service = service;
        }

        @Override
        public void run() {
            this._service.stop();
        }
    }

    private static class LifecycleServiceImpl
    implements LifecycleService {
        private final List<ObjectAndMethod> _postConstructActions;
        private final List<ObjectAndMethod> _preDestroyActions;
        private boolean _started = false;

        public LifecycleServiceImpl(List<ObjectAndMethod> postConstructActions, List<ObjectAndMethod> preDestroyActions) {
            this._postConstructActions = postConstructActions;
            this._preDestroyActions = preDestroyActions;
        }

        @Override
        public synchronized void start() {
            if (this._started) {
                return;
            }
            this._started = true;
            for (ObjectAndMethod target : this._postConstructActions) {
                target.execute();
            }
            for (ObjectAndMethod target : this._preDestroyActions) {
                target.reset();
            }
        }

        @Override
        public void stop() {
            if (!this._started) {
                return;
            }
            this._started = false;
            for (int i = this._preDestroyActions.size() - 1; i >= 0; --i) {
                ObjectAndMethod target = this._preDestroyActions.get(i);
                target.execute();
            }
            for (ObjectAndMethod target : this._postConstructActions) {
                target.reset();
            }
        }
    }

    private static class RegisterMethodCallback<I>
    implements InjectionListener<I> {
        private final List<ObjectAndMethod> _actions;
        private final Method _method;

        public RegisterMethodCallback(List<ObjectAndMethod> preDestroyActions, Method method) {
            this._actions = preDestroyActions;
            this._method = method;
        }

        public void afterInjection(I injectee) {
            this._actions.add(new ObjectAndMethod(injectee, this._method));
        }
    }

    private static class ObjectAndMethod {
        private final Object object;
        private final Method method;
        private boolean hasBeenRun = false;

        public ObjectAndMethod(Object object, Method method) {
            this.object = object;
            this.method = method;
        }

        public synchronized void reset() {
            this.hasBeenRun = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute() {
            ObjectAndMethod objectAndMethod = this;
            synchronized (objectAndMethod) {
                if (this.hasBeenRun) {
                    return;
                }
                this.hasBeenRun = true;
            }
            try {
                this.method.setAccessible(true);
                this.method.invoke(this.object, new Object[0]);
            }
            catch (Throwable ex) {
                try {
                    _log.warn("error invoking method " + this.method + " on target " + this.object, ex);
                }
                catch (Exception ex2) {
                    System.err.println("error invoking method " + this.method + " on target " + this.object);
                    ex.printStackTrace();
                }
            }
        }

        public String toString() {
            return this.object + " " + this.method;
        }
    }
}

