/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data.services;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.onebusaway.exceptions.ServiceException;
import org.onebusaway.federations.FederatedService;
import org.onebusaway.federations.annotations.FederatedByAgencyIdMethod;
import org.onebusaway.federations.annotations.FederatedByAggregateMethod;
import org.onebusaway.federations.annotations.FederatedByAnyEntityIdMethod;
import org.onebusaway.federations.annotations.FederatedByCoordinateBoundsMethod;
import org.onebusaway.federations.annotations.FederatedByCoordinatePointsMethod;
import org.onebusaway.federations.annotations.FederatedByCustomMethod;
import org.onebusaway.federations.annotations.FederatedByEntityIdMethod;
import org.onebusaway.federations.annotations.FederatedByEntityIdsMethod;
import org.onebusaway.geospatial.model.EncodedPolylineBean;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.calendar.AgencyServiceInterval;
import org.onebusaway.realtime.api.TimepointPredictionRecord;
import org.onebusaway.realtime.api.VehicleOccupancyRecord;
import org.onebusaway.transit_data.OccupancyStatusBean;
import org.onebusaway.transit_data.model.AgencyBean;
import org.onebusaway.transit_data.model.AgencyWithCoverageBean;
import org.onebusaway.transit_data.model.ArrivalAndDepartureBean;
import org.onebusaway.transit_data.model.ArrivalAndDepartureForStopQueryBean;
import org.onebusaway.transit_data.model.ArrivalsAndDeparturesQueryBean;
import org.onebusaway.transit_data.model.ConsolidatedStopMapBean;
import org.onebusaway.transit_data.model.HistoricalOccupancyByStopQueryBean;
import org.onebusaway.transit_data.model.ListBean;
import org.onebusaway.transit_data.model.RegisterAlarmQueryBean;
import org.onebusaway.transit_data.model.RouteBean;
import org.onebusaway.transit_data.model.RouteGroupingBean;
import org.onebusaway.transit_data.model.RouteScheduleBean;
import org.onebusaway.transit_data.model.RoutesBean;
import org.onebusaway.transit_data.model.SearchQueryBean;
import org.onebusaway.transit_data.model.StopBean;
import org.onebusaway.transit_data.model.StopDirectionSwap;
import org.onebusaway.transit_data.model.StopScheduleBean;
import org.onebusaway.transit_data.model.StopWithArrivalsAndDeparturesBean;
import org.onebusaway.transit_data.model.StopsBean;
import org.onebusaway.transit_data.model.StopsForRouteBean;
import org.onebusaway.transit_data.model.StopsWithArrivalsAndDeparturesBean;
import org.onebusaway.transit_data.model.VehicleStatusBean;
import org.onebusaway.transit_data.model.blocks.BlockBean;
import org.onebusaway.transit_data.model.blocks.BlockInstanceBean;
import org.onebusaway.transit_data.model.blocks.ScheduledBlockLocationBean;
import org.onebusaway.transit_data.model.config.BundleMetadata;
import org.onebusaway.transit_data.model.problems.ETripProblemGroupBy;
import org.onebusaway.transit_data.model.problems.StopProblemReportBean;
import org.onebusaway.transit_data.model.problems.StopProblemReportQueryBean;
import org.onebusaway.transit_data.model.problems.StopProblemReportSummaryBean;
import org.onebusaway.transit_data.model.problems.TripProblemReportBean;
import org.onebusaway.transit_data.model.problems.TripProblemReportQueryBean;
import org.onebusaway.transit_data.model.problems.TripProblemReportSummaryBean;
import org.onebusaway.transit_data.model.realtime.CurrentVehicleEstimateBean;
import org.onebusaway.transit_data.model.realtime.CurrentVehicleEstimateQueryBean;
import org.onebusaway.transit_data.model.realtime.VehicleLocationRecordBean;
import org.onebusaway.transit_data.model.realtime.VehicleLocationRecordQueryBean;
import org.onebusaway.transit_data.model.service_alerts.ServiceAlertBean;
import org.onebusaway.transit_data.model.service_alerts.ServiceAlertRecordBean;
import org.onebusaway.transit_data.model.service_alerts.SituationQueryBean;
import org.onebusaway.transit_data.model.service_alerts.SituationQueryBeanFederatedServiceMethodInvocationHandler;
import org.onebusaway.transit_data.model.trips.TripBean;
import org.onebusaway.transit_data.model.trips.TripDetailsBean;
import org.onebusaway.transit_data.model.trips.TripDetailsQueryBean;
import org.onebusaway.transit_data.model.trips.TripForVehicleQueryBean;
import org.onebusaway.transit_data.model.trips.TripStatusBean;
import org.onebusaway.transit_data.model.trips.TripsForAgencyQueryBean;
import org.onebusaway.transit_data.model.trips.TripsForBoundsQueryBean;
import org.onebusaway.transit_data.model.trips.TripsForRouteQueryBean;

public interface TransitDataService
extends FederatedService {
    @FederatedByAggregateMethod
    public List<AgencyWithCoverageBean> getAgenciesWithCoverage() throws ServiceException;

    @FederatedByAgencyIdMethod
    public AgencyBean getAgency(String var1) throws ServiceException;

    @FederatedByCoordinateBoundsMethod(propertyExpression="bounds")
    public RoutesBean getRoutes(SearchQueryBean var1) throws ServiceException;

    @FederatedByEntityIdMethod
    public RouteBean getRouteForId(String var1) throws ServiceException;

    @FederatedByAgencyIdMethod
    public ListBean<String> getRouteIdsForAgencyId(String var1);

    @FederatedByAgencyIdMethod
    public ListBean<RouteBean> getRoutesForAgencyId(String var1);

    @FederatedByEntityIdMethod
    public StopsForRouteBean getStopsForRoute(String var1) throws ServiceException;

    @FederatedByEntityIdMethod
    public StopsForRouteBean getStopsForRouteForServiceInterval(String var1, AgencyServiceInterval var2) throws ServiceException;

    @FederatedByEntityIdMethod
    public TripBean getTrip(String var1) throws ServiceException;

    @FederatedByEntityIdMethod(propertyExpression="tripId")
    public TripDetailsBean getSingleTripDetails(TripDetailsQueryBean var1) throws ServiceException;

    @FederatedByEntityIdMethod(propertyExpression="tripId")
    public ListBean<TripDetailsBean> getTripDetails(TripDetailsQueryBean var1) throws ServiceException;

    @FederatedByCoordinateBoundsMethod(propertyExpression="bounds")
    public ListBean<TripDetailsBean> getTripsForBounds(TripsForBoundsQueryBean var1);

    @FederatedByEntityIdMethod(propertyExpression="routeId")
    public ListBean<TripDetailsBean> getTripsForRoute(TripsForRouteQueryBean var1);

    @FederatedByAgencyIdMethod(propertyExpression="agencyId")
    public ListBean<TripDetailsBean> getTripsForAgency(TripsForAgencyQueryBean var1);

    @FederatedByEntityIdMethod
    public BlockBean getBlockForId(String var1);

    @FederatedByEntityIdMethod
    public BlockInstanceBean getBlockInstance(String var1, long var2);

    @FederatedByEntityIdMethod
    public ScheduledBlockLocationBean getScheduledBlockLocationFromScheduledTime(String var1, long var2, int var4);

    @FederatedByEntityIdMethod
    public List<BlockInstanceBean> getActiveBlocksForRoute(AgencyAndId var1, long var2, long var4);

    @FederatedByEntityIdMethod
    public VehicleStatusBean getVehicleForAgency(String var1, long var2);

    @FederatedByAgencyIdMethod
    public ListBean<VehicleStatusBean> getAllVehiclesForAgency(String var1, long var2);

    @FederatedByAgencyIdMethod
    public ListBean<VehicleStatusBean> getFilteredVehiclesForAgency(String var1, long var2, Integer var4);

    @FederatedByEntityIdMethod
    public VehicleLocationRecordBean getVehicleLocationRecordForVehicleId(String var1, long var2);

    @FederatedByEntityIdMethod
    public VehicleLocationRecordBean getVehiclePositionForVehicleId(String var1);

    @FederatedByAnyEntityIdMethod(properties={"blockId", "tripId", "vehicleId"})
    public ListBean<VehicleLocationRecordBean> getVehicleLocationRecords(VehicleLocationRecordQueryBean var1);

    @FederatedByEntityIdMethod(propertyExpression="vehicleId")
    public void submitVehicleLocation(VehicleLocationRecordBean var1);

    @FederatedByEntityIdMethod
    public void resetVehicleLocation(String var1);

    @FederatedByEntityIdMethod
    public VehicleOccupancyRecord getVehicleOccupancyRecordForVehicleIdAndRoute(AgencyAndId var1, String var2, String var3);

    @FederatedByEntityIdMethod(propertyExpression="vehicleId")
    public TripDetailsBean getTripDetailsForVehicleAndTime(TripForVehicleQueryBean var1);

    @FederatedByEntityIdMethod
    public StopWithArrivalsAndDeparturesBean getStopWithArrivalsAndDepartures(String var1, ArrivalsAndDeparturesQueryBean var2, AgencyServiceInterval var3) throws ServiceException;

    @FederatedByEntityIdsMethod
    public StopsWithArrivalsAndDeparturesBean getStopsWithArrivalsAndDepartures(Collection<String> var1, ArrivalsAndDeparturesQueryBean var2, AgencyServiceInterval var3) throws ServiceException;

    @FederatedByEntityIdMethod(propertyExpression="stopId")
    public ArrivalAndDepartureBean getArrivalAndDepartureForStop(ArrivalAndDepartureForStopQueryBean var1) throws ServiceException;

    @FederatedByEntityIdMethod(propertyExpression="stopId")
    public String registerAlarmForArrivalAndDepartureAtStop(ArrivalAndDepartureForStopQueryBean var1, RegisterAlarmQueryBean var2);

    @FederatedByEntityIdMethod
    public void cancelAlarmForArrivalAndDepartureAtStop(String var1);

    @FederatedByEntityIdMethod
    public StopScheduleBean getScheduleForStop(String var1, Date var2) throws ServiceException;

    @FederatedByEntityIdMethod
    public RouteScheduleBean getScheduleForRoute(AgencyAndId var1, AgencyServiceInterval var2);

    @FederatedByCoordinateBoundsMethod(propertyExpression="bounds")
    public StopsBean getStops(SearchQueryBean var1) throws ServiceException;

    @FederatedByAggregateMethod
    public StopsBean getStopsByName(String var1) throws ServiceException;

    @FederatedByEntityIdMethod
    public StopBean getStop(String var1) throws ServiceException;

    @FederatedByEntityIdMethod
    public StopBean getStopForServiceDate(String var1, AgencyServiceInterval var2) throws ServiceException;

    @FederatedByAgencyIdMethod
    public ListBean<String> getStopIdsForAgencyId(String var1);

    public StopsBean getStopsForAgencyId(String var1);

    @FederatedByEntityIdMethod
    public EncodedPolylineBean getShapeForId(String var1);

    @FederatedByAgencyIdMethod
    public ListBean<String> getShapeIdsForAgencyId(String var1);

    @FederatedByCoordinatePointsMethod(propertyExpressions={"mostRecentLocation"})
    public ListBean<CurrentVehicleEstimateBean> getCurrentVehicleEstimates(CurrentVehicleEstimateQueryBean var1);

    public List<OccupancyStatusBean> getHistoricalRidershipForStop(HistoricalOccupancyByStopQueryBean var1);

    public List<OccupancyStatusBean> getAllHistoricalRiderships(long var1);

    public List<OccupancyStatusBean> getHistoricalRidershipsForTrip(AgencyAndId var1, long var2);

    public List<OccupancyStatusBean> getHistoricalRidershipsForRoute(AgencyAndId var1, long var2);

    public List<OccupancyStatusBean> getHistoricalRiderships(AgencyAndId var1, AgencyAndId var2, AgencyAndId var3, long var4);

    @FederatedByAgencyIdMethod
    public ServiceAlertBean createServiceAlert(String var1, ServiceAlertBean var2);

    @FederatedByEntityIdMethod(propertyExpression="id")
    public void updateServiceAlert(ServiceAlertBean var1);

    @FederatedByEntityIdMethod
    public ServiceAlertBean copyServiceAlert(String var1, ServiceAlertBean var2);

    @FederatedByEntityIdMethod
    public void removeServiceAlert(String var1);

    @FederatedByEntityIdMethod
    public ServiceAlertBean getServiceAlertForId(String var1);

    @FederatedByAgencyIdMethod
    public ListBean<ServiceAlertBean> getAllServiceAlertsForAgencyId(String var1);

    @FederatedByAgencyIdMethod
    public void removeAllServiceAlertsForAgencyId(String var1);

    @FederatedByCustomMethod(handler=SituationQueryBeanFederatedServiceMethodInvocationHandler.class)
    public ListBean<ServiceAlertBean> getServiceAlerts(SituationQueryBean var1);

    @FederatedByEntityIdMethod(propertyExpression="stopId")
    public void reportProblemWithStop(StopProblemReportBean var1);

    @FederatedByAgencyIdMethod(propertyExpression="agencyId")
    public ListBean<StopProblemReportSummaryBean> getStopProblemReportSummaries(StopProblemReportQueryBean var1);

    @FederatedByAgencyIdMethod(propertyExpression="agencyId")
    public ListBean<StopProblemReportBean> getStopProblemReports(StopProblemReportQueryBean var1);

    @FederatedByEntityIdMethod
    public List<StopProblemReportBean> getAllStopProblemReportsForStopId(String var1);

    @FederatedByEntityIdMethod
    public StopProblemReportBean getStopProblemReportForStopIdAndId(String var1, long var2);

    @FederatedByEntityIdMethod
    public void deleteStopProblemReportForStopIdAndId(String var1, long var2);

    @FederatedByEntityIdMethod(propertyExpression="tripId")
    public void reportProblemWithTrip(TripProblemReportBean var1);

    @FederatedByAgencyIdMethod(propertyExpression="agencyId")
    @Deprecated
    public ListBean<TripProblemReportSummaryBean> getTripProblemReportSummaries(TripProblemReportQueryBean var1);

    @FederatedByAnyEntityIdMethod(properties={"tripId"}, agencyIdProperties={"agencyId"})
    public ListBean<TripProblemReportSummaryBean> getTripProblemReportSummariesByGrouping(TripProblemReportQueryBean var1, ETripProblemGroupBy var2);

    @FederatedByAnyEntityIdMethod(properties={"tripId"}, agencyIdProperties={"agencyId"})
    public ListBean<TripProblemReportBean> getTripProblemReports(TripProblemReportQueryBean var1);

    @FederatedByEntityIdMethod
    @Deprecated
    public List<TripProblemReportBean> getAllTripProblemReportsForTripId(String var1);

    @FederatedByEntityIdMethod
    public TripProblemReportBean getTripProblemReportForTripIdAndId(String var1, long var2);

    @FederatedByEntityIdMethod(propertyExpression="tripId")
    public void updateTripProblemReport(TripProblemReportBean var1);

    @FederatedByEntityIdMethod
    public void deleteTripProblemReportForTripIdAndId(String var1, long var2);

    @FederatedByAggregateMethod
    public List<String> getAllTripProblemReportLabels();

    @FederatedByAgencyIdMethod(propertyExpression="agencyId")
    public String getActiveBundleId();

    @FederatedByAgencyIdMethod(propertyExpression="agencyId")
    public BundleMetadata getBundleMetadata();

    @FederatedByAgencyIdMethod
    public List<TimepointPredictionRecord> getPredictionRecordsForTrip(String var1, TripStatusBean var2);

    @FederatedByAgencyIdMethod
    public Boolean routeHasUpcomingScheduledService(String var1, long var2, String var4, String var5);

    @FederatedByAgencyIdMethod
    public Boolean stopHasUpcomingScheduledService(String var1, long var2, String var4, String var5, String var6);

    @FederatedByAgencyIdMethod
    public List<String> getSearchSuggestions(String var1, String var2);

    public ListBean<StopBean> getStopSuggestions(String var1, String var2, int var3);

    public ListBean<RouteBean> getRouteSuggestions(String var1, String var2, int var3);

    @FederatedByAgencyIdMethod
    public Boolean stopHasRevenueServiceOnRoute(String var1, String var2, String var3, String var4);

    @FederatedByAgencyIdMethod
    public Boolean stopHasRevenueService(String var1, String var2);

    @FederatedByAgencyIdMethod
    public List<StopBean> getAllRevenueStops(AgencyWithCoverageBean var1);

    @FederatedByAgencyIdMethod
    public ListBean<ConsolidatedStopMapBean> getAllConsolidatedStops();

    @FederatedByAgencyIdMethod
    public ListBean<ServiceAlertRecordBean> getAllServiceAlertRecordsForAgencyId(String var1);

    @FederatedByAgencyIdMethod
    public ListBean<RouteGroupingBean> getCanonicalRoute(AgencyServiceInterval var1, AgencyAndId var2);

    @FederatedByAgencyIdMethod
    public StopDirectionSwap findStopDirectionSwap(AgencyAndId var1, String var2, AgencyAndId var3);
}

