/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data.model.trips;

import java.io.Serializable;
import java.util.List;
import org.onebusaway.geospatial.model.CoordinatePoint;
import org.onebusaway.realtime.api.OccupancyStatus;
import org.onebusaway.transit_data.model.StopBean;
import org.onebusaway.transit_data.model.schedule.FrequencyBean;
import org.onebusaway.transit_data.model.service_alerts.ServiceAlertBean;
import org.onebusaway.transit_data.model.trips.TimepointPredictionBean;
import org.onebusaway.transit_data.model.trips.TripBean;

public final class TripStatusBean
implements Serializable {
    private static final long serialVersionUID = 3L;
    private TripBean activeTrip;
    private int blockTripSequence = -1;
    private long serviceDate;
    private int tripStartTime;
    private String occupancyStatus;
    private Integer occupancyCount = -1;
    private Integer occupancyCapacity = -1;
    private FrequencyBean frequency;
    private double scheduledDistanceAlongTrip = Double.NaN;
    private double totalDistanceAlongTrip = Double.NaN;
    private String phase;
    private String status;
    private String vehicleType;
    private double distanceAlongTrip = Double.NaN;
    private CoordinatePoint location;
    private double orientation = Double.NaN;
    private StopBean closestStop;
    private int closestStopTimeOffset;
    private StopBean nextStop;
    private int nextStopTimeOffset;
    private double nextStopDistanceFromVehicle;
    private StopBean previousStop;
    private int previousStopTimeOffset;
    private double previousStopDistanceFromVehicle;
    private boolean predicted = false;
    private long lastUpdateTime;
    private long lastLocationUpdateTime;
    private double lastKnownDistanceAlongTrip = Double.NaN;
    private CoordinatePoint lastKnownLocation;
    private double lastKnownOrientation = Double.NaN;
    private double scheduleDeviation;
    private String vehicleId;
    private List<ServiceAlertBean> situations;
    private List<TimepointPredictionBean> timepointPredictions;
    private List<String> vehicleFeatures;

    public TripBean getActiveTrip() {
        return this.activeTrip;
    }

    public void setActiveTrip(TripBean activeTrip) {
        this.activeTrip = activeTrip;
    }

    public int getBlockTripSequence() {
        return this.blockTripSequence;
    }

    public void setBlockTripSequence(int blockTripSequence) {
        this.blockTripSequence = blockTripSequence;
    }

    public long getServiceDate() {
        return this.serviceDate;
    }

    public void setServiceDate(long serviceDate) {
        this.serviceDate = serviceDate;
    }

    public int getTripStartTime() {
        return this.tripStartTime;
    }

    public void setTripStartTime(int tripStartTime) {
        this.tripStartTime = tripStartTime;
    }

    public String getOccupancyStatus() {
        return this.occupancyStatus;
    }

    public void setOccupancyStatus(OccupancyStatus occupancyStatus) {
        if (occupancyStatus != null) {
            this.occupancyStatus = occupancyStatus.name();
        }
    }

    public Integer getOccupancyCount() {
        return this.occupancyCount;
    }

    public void setOccupancyCount(Integer occupancyCount) {
        this.occupancyCount = occupancyCount;
    }

    public Integer getOccupancyCapacity() {
        return this.occupancyCapacity;
    }

    public void setOccupancyCapacity(Integer occupancyCapacity) {
        this.occupancyCapacity = occupancyCapacity;
    }

    public FrequencyBean getFrequency() {
        return this.frequency;
    }

    public void setFrequency(FrequencyBean frequency) {
        this.frequency = frequency;
    }

    public double getScheduledDistanceAlongTrip() {
        return this.scheduledDistanceAlongTrip;
    }

    public void setScheduledDistanceAlongTrip(double scheduledDistanceAlongTrip) {
        this.scheduledDistanceAlongTrip = scheduledDistanceAlongTrip;
    }

    public double getTotalDistanceAlongTrip() {
        return this.totalDistanceAlongTrip;
    }

    public void setTotalDistanceAlongTrip(double totalDistanceAlongTrip) {
        this.totalDistanceAlongTrip = totalDistanceAlongTrip;
    }

    public String getPhase() {
        return this.phase;
    }

    public void setPhase(String phase) {
        this.phase = phase;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getVehicleType() {
        return this.vehicleType;
    }

    public void setVehicleType(String vehicleType) {
        this.vehicleType = vehicleType;
    }

    public boolean isDistanceAlongTripSet() {
        return !Double.isNaN(this.distanceAlongTrip);
    }

    public void setDistanceAlongTrip(double distanceAlongTrip) {
        this.distanceAlongTrip = distanceAlongTrip;
    }

    public double getDistanceAlongTrip() {
        return this.distanceAlongTrip;
    }

    public CoordinatePoint getLocation() {
        return this.location;
    }

    public void setLocation(CoordinatePoint location) {
        this.location = location;
    }

    public boolean isOrientationSet() {
        return !Double.isNaN(this.orientation);
    }

    public double getOrientation() {
        return this.orientation;
    }

    public void setOrientation(double orientation) {
        this.orientation = orientation;
    }

    public StopBean getClosestStop() {
        return this.closestStop;
    }

    public void setClosestStop(StopBean closestStop) {
        this.closestStop = closestStop;
    }

    public int getClosestStopTimeOffset() {
        return this.closestStopTimeOffset;
    }

    public void setClosestStopTimeOffset(int closestStopTimeOffset) {
        this.closestStopTimeOffset = closestStopTimeOffset;
    }

    public StopBean getNextStop() {
        return this.nextStop;
    }

    public void setNextStop(StopBean nextStop) {
        this.nextStop = nextStop;
    }

    public int getNextStopTimeOffset() {
        return this.nextStopTimeOffset;
    }

    public void setNextStopTimeOffset(int nextStopTimeOffset) {
        this.nextStopTimeOffset = nextStopTimeOffset;
    }

    public double getNextStopDistanceFromVehicle() {
        return this.nextStopDistanceFromVehicle;
    }

    public void setNextStopDistanceFromVehicle(double d) {
        this.nextStopDistanceFromVehicle = d;
    }

    public StopBean getPreviousStop() {
        return this.previousStop;
    }

    public void setPreviousStop(StopBean previousStop) {
        this.previousStop = previousStop;
    }

    public int getPreviousStopTimeOffset() {
        return this.previousStopTimeOffset;
    }

    public void setPreviousStopTimeOffset(int previousStopTimeOffset) {
        this.previousStopTimeOffset = previousStopTimeOffset;
    }

    public double getPreviousStopDistanceFromVehicle() {
        return this.previousStopDistanceFromVehicle;
    }

    public void setPreviousStopDistanceFromVehicle(double previousStopDistanceFromVehicle) {
        this.previousStopDistanceFromVehicle = previousStopDistanceFromVehicle;
    }

    public boolean isPredicted() {
        return this.predicted;
    }

    public void setPredicted(boolean predicted) {
        this.predicted = predicted;
    }

    public void setLastUpdateTime(long time) {
        this.lastUpdateTime = time;
    }

    public long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public long getLastLocationUpdateTime() {
        return this.lastLocationUpdateTime;
    }

    public void setLastLocationUpdateTime(long lastLocationUpdateTime) {
        this.lastLocationUpdateTime = lastLocationUpdateTime;
    }

    public boolean isLastKnownDistanceAlongTripSet() {
        return !Double.isNaN(this.lastKnownDistanceAlongTrip);
    }

    public double getLastKnownDistanceAlongTrip() {
        return this.lastKnownDistanceAlongTrip;
    }

    public void setLastKnownDistanceAlongTrip(double lastKnownDistanceAlongTrip) {
        this.lastKnownDistanceAlongTrip = lastKnownDistanceAlongTrip;
    }

    public CoordinatePoint getLastKnownLocation() {
        return this.lastKnownLocation;
    }

    public void setLastKnownLocation(CoordinatePoint lastKnownLocation) {
        this.lastKnownLocation = lastKnownLocation;
    }

    public boolean isLastKnownOrientationSet() {
        return !Double.isNaN(this.lastKnownOrientation);
    }

    public double getLastKnownOrientation() {
        return this.lastKnownOrientation;
    }

    public void setLastKnownOrientation(double lastKnownOrientation) {
        this.lastKnownOrientation = lastKnownOrientation;
    }

    public boolean isScheduleDeviationSet() {
        return !Double.isNaN(this.scheduleDeviation);
    }

    public double getScheduleDeviation() {
        return this.scheduleDeviation;
    }

    public void setScheduleDeviation(double scheduleDeviation) {
        this.scheduleDeviation = scheduleDeviation;
    }

    public String getVehicleId() {
        return this.vehicleId;
    }

    public void setVehicleId(String vehicleId) {
        this.vehicleId = vehicleId;
    }

    public List<ServiceAlertBean> getSituations() {
        return this.situations;
    }

    public void setSituations(List<ServiceAlertBean> situations) {
        this.situations = situations;
    }

    public List<TimepointPredictionBean> getTimepointPredictions() {
        return this.timepointPredictions;
    }

    public void setTimepointPredictions(List<TimepointPredictionBean> timepointPredictions) {
        this.timepointPredictions = timepointPredictions;
    }

    public void setVehicleFeatures(List<String> vehicleFeatures) {
        this.vehicleFeatures = vehicleFeatures;
    }

    public List<String> getVehicleFeatures() {
        return this.vehicleFeatures;
    }
}

