/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data.model.service_alerts;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.onebusaway.exceptions.ServiceException;
import org.onebusaway.federations.FederatedService;
import org.onebusaway.federations.FederatedServiceCollection;
import org.onebusaway.federations.annotations.AgencyIdSupport;
import org.onebusaway.federations.annotations.FederatedServiceMethodInvocationHandler;
import org.onebusaway.transit_data.model.service_alerts.SituationQueryBean;

public class SituationQueryBeanFederatedServiceMethodInvocationHandler
implements FederatedServiceMethodInvocationHandler {
    public Object invoke(FederatedServiceCollection collection, Method method, Object[] args) throws ServiceException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (args.length == 0) {
            throw new ServiceException("unexpected number of arguments");
        }
        SituationQueryBean query = (SituationQueryBean)args[0];
        HashSet<String> agencyIds = new HashSet<String>();
        if (query.getAffects() != null) {
            for (SituationQueryBean.AffectsBean affects : query.getAffects()) {
                if (affects.getAgencyId() != null) {
                    agencyIds.add(affects.getAgencyId());
                }
                SituationQueryBeanFederatedServiceMethodInvocationHandler.addAgencyId(affects.getRouteId(), agencyIds);
                SituationQueryBeanFederatedServiceMethodInvocationHandler.addAgencyId(affects.getTripId(), agencyIds);
                SituationQueryBeanFederatedServiceMethodInvocationHandler.addAgencyId(affects.getStopId(), agencyIds);
            }
        }
        FederatedService service = collection.getServiceForAgencyIds(agencyIds);
        return method.invoke((Object)service, args);
    }

    private static void addAgencyId(String entityId, Set<String> agencyIds) {
        if (entityId == null || entityId.isEmpty()) {
            return;
        }
        agencyIds.add(AgencyIdSupport.getAgencyIdFromEntityId((String)entityId));
    }
}

