/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data.model;

import java.util.ArrayList;
import java.util.List;
import org.onebusaway.transit_data.model.RouteBean;
import org.onebusaway.transit_data.model.StopBean;
import org.onebusaway.transit_data.model.StopFilter;

public class StopFilterByRouteType
extends StopFilter {
    private List<Integer> routeTypes = new ArrayList<Integer>();

    public StopFilterByRouteType(String routeTypeCommaDelimited) {
        String[] types;
        for (String type : types = routeTypeCommaDelimited.split(",")) {
            try {
                this.routeTypes.add(Integer.parseInt(type));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public StopFilterByRouteType(List<Integer> types) {
        this.routeTypes.addAll(types);
    }

    @Override
    public boolean matches(StopBean bean) {
        if (this.routeTypes == null || this.routeTypes.isEmpty()) {
            return true;
        }
        for (Integer routeType : this.routeTypes) {
            if (bean.getRoutes() == null) continue;
            for (RouteBean route : bean.getRoutes()) {
                if (routeType.intValue() != route.getType()) continue;
                return true;
            }
        }
        return false;
    }
}

