/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.onebusaway.transit_data.model.RouteSorting;

public class RouteSort
implements RouteSorting,
Serializable {
    private final Map<String, String> agencySortConfiguration;
    private String primarySortAgency;
    private final Map<String, Map<String, Integer>> routeSortOrderMap = new HashMap<String, Map<String, Integer>>();
    private final String delimiter;

    RouteSort(Map<String, String> agencySortConfiguration, String primarySortAgency) {
        this.agencySortConfiguration = agencySortConfiguration;
        this.delimiter = ",";
        this.primarySortAgency = primarySortAgency;
        this.setOrderingToMap();
    }

    void setOrderingToMap() {
        for (String agencyId : this.agencySortConfiguration.keySet()) {
            String sortOrderString = this.agencySortConfiguration.get(agencyId);
            String[] sortOrderItems = sortOrderString.split(this.delimiter);
            HashMap<String, Integer> sortOrderMap = new HashMap<String, Integer>();
            for (int i = 0; i < sortOrderItems.length; ++i) {
                sortOrderMap.put(sortOrderItems[i].trim(), i);
            }
            this.routeSortOrderMap.put(agencyId, sortOrderMap);
        }
    }

    @Override
    public int compareRoutes(String a, String b) {
        if (a == null && b == null) {
            return 0;
        }
        if (a == null) {
            return 1;
        }
        if (b == null) {
            return -1;
        }
        Map<String, Integer> sortOrderMap = this.routeSortOrderMap.get(this.primarySortAgency);
        if (sortOrderMap == null) {
            return a.compareTo(b);
        }
        Integer o1 = sortOrderMap.get(a);
        Integer o2 = sortOrderMap.get(b);
        if (o1 == null && o2 == null) {
            return a.compareTo(b);
        }
        if (o1 == null) {
            return 1;
        }
        if (o2 == null) {
            return -1;
        }
        return Integer.compare(o1, o2);
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public Map<String, Map<String, Integer>> getRouteSortOrderMap() {
        return this.routeSortOrderMap;
    }

    @Override
    public String getPrimarySortAgency() {
        return this.primarySortAgency;
    }
}

