/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data.model;

import java.io.Serializable;
import org.onebusaway.transit_data.model.AgencyBean;

public final class RouteBean
implements Serializable {
    private static final long serialVersionUID = 2L;
    private String id;
    private String shortName;
    private String longName;
    private String description;
    private int type;
    private String url;
    private String color;
    private String textColor;
    private AgencyBean agency;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(RouteBean bean) {
        return new Builder(bean);
    }

    private RouteBean() {
        this(RouteBean.builder());
    }

    private RouteBean(Builder builder) {
        this.agency = builder.agency;
        this.color = builder.color;
        this.description = builder.description;
        this.id = builder.id;
        this.longName = builder.longName;
        this.shortName = builder.shortName;
        this.textColor = builder.textColor;
        this.type = builder.type;
        this.url = builder.url;
    }

    public String getId() {
        return this.id;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getLongName() {
        return this.longName;
    }

    public String getDescription() {
        return this.description;
    }

    public int getType() {
        return this.type;
    }

    public String getUrl() {
        return this.url;
    }

    public String getColor() {
        return this.color;
    }

    public String getTextColor() {
        return this.textColor;
    }

    public AgencyBean getAgency() {
        return this.agency;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof RouteBean)) {
            return false;
        }
        RouteBean other = (RouteBean)obj;
        return this.id.equals(other.id);
    }

    public static class Builder {
        private String id;
        private String shortName;
        private String longName;
        private String description;
        private int type;
        private String url;
        private String color;
        private String textColor;
        private AgencyBean agency;

        public Builder() {
        }

        public Builder(RouteBean bean) {
            this.agency = bean.agency;
            this.color = bean.color;
            this.description = bean.description;
            this.id = bean.id;
            this.longName = bean.longName;
            this.shortName = bean.shortName;
            this.textColor = bean.textColor;
            this.type = bean.type;
            this.url = bean.url;
        }

        public RouteBean create() {
            return new RouteBean(this);
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setShortName(String shortName) {
            this.shortName = shortName;
        }

        public void setLongName(String longName) {
            this.longName = longName;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public void setType(int type) {
            this.type = type;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public void setColor(String color) {
            this.color = color;
        }

        public void setTextColor(String textColor) {
            this.textColor = textColor;
        }

        public void setAgency(AgencyBean agency) {
            this.agency = agency;
        }
    }
}

