/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.onebusaway.transit_data.model.ArrivalAndDepartureBean;
import org.onebusaway.transit_data.model.ArrivalAndDepartureFilter;
import org.onebusaway.transit_data.model.StopBean;
import org.onebusaway.transit_data.model.StopFilter;

public class FilterChain
implements Serializable {
    private List<ArrivalAndDepartureFilter> arrivalAndDepartureFilters = new ArrayList<ArrivalAndDepartureFilter>();
    private List<StopFilter> stopFilters = new ArrayList<StopFilter>();

    public void setArrivalAndDepartureFilters(List<ArrivalAndDepartureFilter> arrivalAndDepartureFilters) {
        this.arrivalAndDepartureFilters = arrivalAndDepartureFilters;
    }

    public void setStopFilters(List<StopFilter> stopFilters) {
        this.stopFilters = stopFilters;
    }

    public void add(ArrivalAndDepartureFilter filter) {
        this.arrivalAndDepartureFilters.add(filter);
    }

    public void add(StopFilter filter) {
        this.stopFilters.add(filter);
    }

    public boolean matches(ArrivalAndDepartureBean bean) {
        if (this.arrivalAndDepartureFilters.isEmpty()) {
            return true;
        }
        boolean matches = true;
        for (ArrivalAndDepartureFilter filter : this.arrivalAndDepartureFilters) {
            matches = matches && filter.matches(bean);
        }
        return matches;
    }

    public boolean matches(StopBean bean) {
        if (this.stopFilters.isEmpty()) {
            return true;
        }
        for (StopFilter filter : this.stopFilters) {
            if (!filter.matches(bean)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilterChain)) {
            return false;
        }
        FilterChain fc = (FilterChain)obj;
        if (!this.arrivalAndDepartureFilters.equals(fc.arrivalAndDepartureFilters)) {
            return false;
        }
        return this.stopFilters.equals(fc.stopFilters);
    }

    public int hashCode() {
        int prime = 37;
        int result = 1;
        for (ArrivalAndDepartureFilter arrivalAndDepartureFilter : this.arrivalAndDepartureFilters) {
            result = 37 * result + arrivalAndDepartureFilter.hashCode();
        }
        for (StopFilter stopFilter : this.stopFilters) {
            result = 37 * result + stopFilter.hashCode();
        }
        return result;
    }
}

