/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data.model;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import org.onebusaway.geospatial.model.CoordinateBounds;
import org.onebusaway.gtfs.model.calendar.AgencyServiceInterval;
import org.onebusaway.transit_data.model.ArrivalAndDepartureFilterByRouteType;
import org.onebusaway.transit_data.model.FilterChain;
import org.onebusaway.transit_data.model.QueryBean;
import org.onebusaway.util.SystemTime;

@QueryBean
public final class ArrivalsAndDeparturesQueryBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long time = SystemTime.currentTimeMillis();
    private int minutesBefore = 5;
    private int minutesAfter = 35;
    private int frequencyMinutesBefore = 2;
    private int frequencyMinutesAfter = 30;
    private boolean includeInputIdsInNearby = false;
    private int maxCount = Integer.MAX_VALUE;
    private CoordinateBounds bounds;
    private HashSet<String> agenciesExcludingScheduled = new HashSet();
    private FilterChain systemFilterChain = new FilterChain();
    private FilterChain instanceFilterChain = new FilterChain();
    private AgencyServiceInterval serviceInterval;
    private List<Integer> routeTypes;

    public ArrivalsAndDeparturesQueryBean() {
    }

    public ArrivalsAndDeparturesQueryBean(ArrivalsAndDeparturesQueryBean bean) {
        this.time = bean.time;
        this.minutesBefore = bean.minutesBefore;
        this.minutesAfter = bean.minutesAfter;
        this.frequencyMinutesBefore = bean.frequencyMinutesBefore;
        this.frequencyMinutesAfter = bean.frequencyMinutesAfter;
        this.includeInputIdsInNearby = bean.includeInputIdsInNearby;
        this.bounds = bean.bounds;
        this.agenciesExcludingScheduled = bean.agenciesExcludingScheduled;
        this.maxCount = bean.maxCount;
        this.systemFilterChain = bean.systemFilterChain;
        this.instanceFilterChain = bean.instanceFilterChain;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public int getMinutesBefore() {
        return this.minutesBefore;
    }

    public void setMinutesBefore(int minutesBefore) {
        this.minutesBefore = minutesBefore;
    }

    public int getMinutesAfter() {
        return this.minutesAfter;
    }

    public void setMinutesAfter(int minutesAfter) {
        this.minutesAfter = minutesAfter;
    }

    public int getFrequencyMinutesBefore() {
        return this.frequencyMinutesBefore;
    }

    public void setFrequencyMinutesBefore(int frequencyMinutesBefore) {
        this.frequencyMinutesBefore = frequencyMinutesBefore;
    }

    public int getFrequencyMinutesAfter() {
        return this.frequencyMinutesAfter;
    }

    public void setFrequencyMinutesAfter(int frequencyMinutesAfter) {
        this.frequencyMinutesAfter = frequencyMinutesAfter;
    }

    public boolean getIncludeInputIdsInNearby() {
        return this.includeInputIdsInNearby;
    }

    public void setIncludeInputIdsInNearby(boolean flag) {
        this.includeInputIdsInNearby = flag;
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    public void setMaxCount(int maxCount) {
        this.maxCount = maxCount;
    }

    public CoordinateBounds getBounds() {
        return this.bounds;
    }

    public void setBounds(CoordinateBounds bounds) {
        this.bounds = bounds;
    }

    public void setRouteTypes(List<Integer> types) {
        if (types == null || types.isEmpty()) {
            return;
        }
        this.instanceFilterChain.add(new ArrivalAndDepartureFilterByRouteType(types));
    }

    public void setRouteType(String routeType) {
        if (routeType == null) {
            return;
        }
        ArrivalAndDepartureFilterByRouteType arrivalAndDepartureFilterByRouteType = new ArrivalAndDepartureFilterByRouteType(routeType);
        this.routeTypes = arrivalAndDepartureFilterByRouteType.getRouteTypes();
        this.instanceFilterChain.add(arrivalAndDepartureFilterByRouteType);
    }

    public List<Integer> getRouteTypes() {
        return this.routeTypes;
    }

    public void setAgenciesExcludingScheduled(HashSet<String> agencies) {
        this.agenciesExcludingScheduled = agencies;
    }

    public HashSet<String> getAgenciesExcludingScheduled() {
        return this.agenciesExcludingScheduled;
    }

    public FilterChain getSystemFilterChain() {
        return this.systemFilterChain;
    }

    public void setSystemFilterChain(FilterChain systemFilterChain) {
        this.systemFilterChain = systemFilterChain;
    }

    public FilterChain getInstanceFilterChain() {
        return this.instanceFilterChain;
    }

    public void setInstanceFilterChain(FilterChain instanceFilterChain) {
        this.instanceFilterChain = instanceFilterChain;
    }

    public AgencyServiceInterval getServiceInterval() {
        return this.serviceInterval;
    }

    public void setServiceInterval(AgencyServiceInterval serviceInterval) {
        this.serviceInterval = serviceInterval;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.frequencyMinutesAfter;
        result = 31 * result + this.frequencyMinutesBefore;
        result = 31 * result + this.minutesAfter;
        result = 31 * result + this.minutesBefore;
        result = 31 * result + (int)(this.time ^ this.time >>> 32);
        if (this.instanceFilterChain != null) {
            result = 31 * result + this.instanceFilterChain.hashCode();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArrivalsAndDeparturesQueryBean other = (ArrivalsAndDeparturesQueryBean)obj;
        if (this.frequencyMinutesAfter != other.frequencyMinutesAfter) {
            return false;
        }
        if (this.frequencyMinutesBefore != other.frequencyMinutesBefore) {
            return false;
        }
        if (this.minutesAfter != other.minutesAfter) {
            return false;
        }
        if (this.minutesBefore != other.minutesBefore) {
            return false;
        }
        if (this.time != other.time) {
            return false;
        }
        if ((this.instanceFilterChain == null || other.instanceFilterChain == null) && this.instanceFilterChain != other.instanceFilterChain) {
            return false;
        }
        return this.instanceFilterChain.equals(other.instanceFilterChain);
    }
}

