/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data.model;

import java.util.ArrayList;
import java.util.List;
import org.onebusaway.transit_data.model.ArrivalAndDepartureBean;
import org.onebusaway.transit_data.model.ArrivalAndDepartureFilter;
import org.onebusaway.transit_data.model.RouteBean;

public class ArrivalAndDepartureFilterByRouteType
extends ArrivalAndDepartureFilter {
    private List<Integer> routeTypes = new ArrayList<Integer>();

    public ArrivalAndDepartureFilterByRouteType(List<Integer> types) {
        this.routeTypes.addAll(types);
    }

    public ArrivalAndDepartureFilterByRouteType(String routeTypeCommaDelimited) {
        String[] types;
        for (String type : types = routeTypeCommaDelimited.split(",")) {
            try {
                this.routeTypes.add(Integer.parseInt(type));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public List<Integer> getRouteTypes() {
        return this.routeTypes;
    }

    @Override
    public boolean matches(ArrivalAndDepartureBean bean) {
        if (this.routeTypes == null || this.routeTypes.isEmpty()) {
            return true;
        }
        for (Integer routeType : this.routeTypes) {
            if (bean.getStop() == null || bean.getStop().getRoutes() == null) continue;
            for (RouteBean route : bean.getStop().getRoutes()) {
                if (routeType.intValue() != route.getType()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ArrivalAndDepartureFilterByRouteType)) {
            return false;
        }
        ArrivalAndDepartureFilterByRouteType other = (ArrivalAndDepartureFilterByRouteType)obj;
        return this.routeTypes.equals(other.routeTypes);
    }

    public int hashCode() {
        int prime = 37;
        int result = 1;
        for (Integer i : this.routeTypes) {
            result = 37 * result + i.hashCode();
        }
        return result;
    }
}

