/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data.model;

import java.util.ArrayList;
import java.util.List;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.transit_data.model.ArrivalAndDepartureBean;
import org.onebusaway.transit_data.model.ArrivalAndDepartureFilter;
import org.onebusaway.util.AgencyAndIdLibrary;

public class ArrivalAndDepartureFilterByRealtime
extends ArrivalAndDepartureFilter {
    List<String> realtimeOnlyAgencyIds = new ArrayList<String>();

    public ArrivalAndDepartureFilterByRealtime(List<String> realtimeOnlyAgencies) {
        this.realtimeOnlyAgencyIds.addAll(realtimeOnlyAgencies);
    }

    @Override
    public boolean matches(ArrivalAndDepartureBean bean) {
        if (this.realtimeOnlyAgencyIds == null || this.realtimeOnlyAgencyIds.isEmpty()) {
            return true;
        }
        if (bean.getTrip() == null) {
            return false;
        }
        AgencyAndId tripAgencyId = AgencyAndIdLibrary.convertFromString((String)bean.getTrip().getId());
        for (String testAgencyId : this.realtimeOnlyAgencyIds) {
            if (!tripAgencyId.getAgencyId().equals(testAgencyId)) continue;
            return this.isCancelled(bean) || this.hasRealtime(bean);
        }
        return true;
    }

    private boolean isCancelled(ArrivalAndDepartureBean bean) {
        return "CANCELED".equals(bean.getStatus());
    }

    private boolean hasRealtime(ArrivalAndDepartureBean bean) {
        return (bean.getPredictedArrivalTime() > 0L || bean.getPredictedDepartureTime() > 0L) && bean.isPredicted();
    }
}

