/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data.model;

import java.util.Date;
import java.util.List;
import org.onebusaway.realtime.api.OccupancyStatus;
import org.onebusaway.transit_data.model.ApplicationBean;
import org.onebusaway.transit_data.model.StopBean;
import org.onebusaway.transit_data.model.TimeIntervalBean;
import org.onebusaway.transit_data.model.realtime.HistogramBean;
import org.onebusaway.transit_data.model.schedule.FrequencyBean;
import org.onebusaway.transit_data.model.service_alerts.ServiceAlertBean;
import org.onebusaway.transit_data.model.trips.TripBean;
import org.onebusaway.transit_data.model.trips.TripStatusBean;

public class ArrivalAndDepartureBean
extends ApplicationBean {
    private static final long serialVersionUID = 4L;
    private TripBean trip;
    private long serviceDate;
    private String vehicleId;
    private StopBean stop;
    private int stopSequence;
    private int blockTripSequence;
    private boolean arrivalEnabled;
    private long scheduledArrivalTime;
    private TimeIntervalBean scheduledArrivalInterval;
    private long predictedArrivalTime;
    private TimeIntervalBean predictedArrivalInterval;
    private boolean departureEnabled;
    private long scheduledDepartureTime;
    private TimeIntervalBean scheduledDepartureInterval;
    private long predictedDepartureTime;
    private OccupancyStatus occupancyStatus;
    private OccupancyStatus historicalOccupancy;
    private OccupancyStatus predictedOccupancy;
    private TimeIntervalBean predictedDepartureInterval;
    private FrequencyBean frequency;
    private boolean predicted = false;
    private Long lastUpdateTime;
    private String status;
    private double distanceFromStop = Double.NaN;
    private int numberOfStopsAway;
    private String routeShortName;
    private String tripHeadsign;
    private TripStatusBean tripStatus;
    private List<ServiceAlertBean> situations;
    private HistogramBean scheduleDeviationHistogram;
    private int totalStopsInTrip;
    private String actualTrack;
    private String scheduledTrack;

    public TripBean getTrip() {
        return this.trip;
    }

    public void setTrip(TripBean trip) {
        this.trip = trip;
    }

    public long getServiceDate() {
        return this.serviceDate;
    }

    public void setServiceDate(long serviceDate) {
        this.serviceDate = serviceDate;
    }

    public String getVehicleId() {
        return this.vehicleId;
    }

    public void setVehicleId(String vehicleId) {
        this.vehicleId = vehicleId;
    }

    public StopBean getStop() {
        return this.stop;
    }

    public void setStop(StopBean stop) {
        this.stop = stop;
    }

    public int getStopSequence() {
        return this.stopSequence;
    }

    public void setStopSequence(int stopSequence) {
        this.stopSequence = stopSequence;
    }

    public int getBlockTripSequence() {
        return this.blockTripSequence;
    }

    public void setBlockTripSequence(int blockTripSequence) {
        this.blockTripSequence = blockTripSequence;
    }

    public boolean isArrivalEnabled() {
        return this.arrivalEnabled;
    }

    public void setArrivalEnabled(boolean arrivalEnabled) {
        this.arrivalEnabled = arrivalEnabled;
    }

    public long getScheduledArrivalTime() {
        return this.scheduledArrivalTime;
    }

    public void setScheduledArrivalTime(long scheduledArrivalTime) {
        this.scheduledArrivalTime = scheduledArrivalTime;
    }

    public TimeIntervalBean getScheduledArrivalInterval() {
        return this.scheduledArrivalInterval;
    }

    public void setScheduledArrivalInterval(TimeIntervalBean scheduledArrivalInterval) {
        this.scheduledArrivalInterval = scheduledArrivalInterval;
    }

    public long getPredictedArrivalTime() {
        return this.predictedArrivalTime;
    }

    public void setPredictedArrivalTime(long predictedArrivalTime) {
        this.predictedArrivalTime = predictedArrivalTime;
    }

    public TimeIntervalBean getPredictedArrivalInterval() {
        return this.predictedArrivalInterval;
    }

    public void setPredictedArrivalInterval(TimeIntervalBean predictedArrivalInterval) {
        this.predictedArrivalInterval = predictedArrivalInterval;
    }

    public boolean isDepartureEnabled() {
        return this.departureEnabled;
    }

    public void setDepartureEnabled(boolean departureEnabled) {
        this.departureEnabled = departureEnabled;
    }

    public long getScheduledDepartureTime() {
        return this.scheduledDepartureTime;
    }

    public void setScheduledDepartureTime(long scheduledDepartureTime) {
        this.scheduledDepartureTime = scheduledDepartureTime;
    }

    public TimeIntervalBean getScheduledDepartureInterval() {
        return this.scheduledDepartureInterval;
    }

    public void setScheduledDepartureInterval(TimeIntervalBean scheduledDepartureInterval) {
        this.scheduledDepartureInterval = scheduledDepartureInterval;
    }

    public long getPredictedDepartureTime() {
        return this.predictedDepartureTime;
    }

    public void setPredictedDepartureTime(long predictedDepartureTime) {
        this.predictedDepartureTime = predictedDepartureTime;
    }

    public OccupancyStatus getOccupancyStatus() {
        return this.occupancyStatus;
    }

    public void setOccupancyStatus(OccupancyStatus occupancyStatus) {
        this.occupancyStatus = occupancyStatus;
    }

    public OccupancyStatus getHistoricalOccupancy() {
        return this.historicalOccupancy;
    }

    public void setHistoricalOccupancy(OccupancyStatus histOccupancy) {
        this.historicalOccupancy = histOccupancy;
    }

    public OccupancyStatus getPredictedOccupancy() {
        return this.predictedOccupancy;
    }

    public void setPredictedOccupancy(OccupancyStatus predOccupancy) {
        this.predictedOccupancy = predOccupancy;
    }

    public TimeIntervalBean getPredictedDepartureInterval() {
        return this.predictedDepartureInterval;
    }

    public void setPredictedDepartureInterval(TimeIntervalBean predictedDepartureInterval) {
        this.predictedDepartureInterval = predictedDepartureInterval;
    }

    public FrequencyBean getFrequency() {
        return this.frequency;
    }

    public void setFrequency(FrequencyBean frequency) {
        this.frequency = frequency;
    }

    public boolean isPredicted() {
        return this.predicted;
    }

    public void setPredicted(boolean predicted) {
        this.predicted = predicted;
    }

    public Long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void setLastUpdateTime(Long lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public boolean isDistanceFromStopSet() {
        return !Double.isNaN(this.distanceFromStop);
    }

    public double getDistanceFromStop() {
        return this.distanceFromStop;
    }

    public void setDistanceFromStop(double distanceFromStop) {
        this.distanceFromStop = distanceFromStop;
    }

    public int getNumberOfStopsAway() {
        return this.numberOfStopsAway;
    }

    public void setNumberOfStopsAway(int numberOfStopsAway) {
        this.numberOfStopsAway = numberOfStopsAway;
    }

    public String getRouteShortName() {
        return this.routeShortName;
    }

    public void setRouteShortName(String routeShortName) {
        this.routeShortName = routeShortName;
    }

    public String getTripHeadsign() {
        return this.tripHeadsign;
    }

    public void setTripHeadsign(String tripHeadsign) {
        this.tripHeadsign = tripHeadsign;
    }

    public TripStatusBean getTripStatus() {
        return this.tripStatus;
    }

    public void setTripStatus(TripStatusBean tripStatus) {
        this.tripStatus = tripStatus;
    }

    public List<ServiceAlertBean> getSituations() {
        return this.situations;
    }

    public void setSituations(List<ServiceAlertBean> situations) {
        this.situations = situations;
    }

    public HistogramBean getScheduleDeviationHistogram() {
        return this.scheduleDeviationHistogram;
    }

    public void setScheduleDeviationHistogram(HistogramBean scheduleDeviationHistogram) {
        this.scheduleDeviationHistogram = scheduleDeviationHistogram;
    }

    public int getTotalStopsInTrip() {
        return this.totalStopsInTrip;
    }

    public void setTotalStopsInTrip(int totalStopsInTrip) {
        this.totalStopsInTrip = totalStopsInTrip;
    }

    public boolean hasPredictedArrivalTime() {
        return this.predictedArrivalTime > 0L;
    }

    public boolean hasPredictedDepartureTime() {
        return this.predictedDepartureTime > 0L;
    }

    public String getActualTrack() {
        return this.actualTrack;
    }

    public void setActualTrack(String actualTrack) {
        this.actualTrack = actualTrack;
    }

    public String getScheduledTrack() {
        return this.scheduledTrack;
    }

    public void setScheduledTrack(String scheduledTrack) {
        this.scheduledTrack = scheduledTrack;
    }

    public long computeBestArrivalTime() {
        return this.hasPredictedArrivalTime() ? this.getPredictedArrivalTime() : this.getScheduledArrivalTime();
    }

    public long computeBestDepartureTime() {
        return this.hasPredictedDepartureTime() ? this.getPredictedDepartureTime() : this.getScheduledDepartureTime();
    }

    public String toString() {
        return "trip=" + this.trip.getId() + " route=" + (this.trip.getRoute() != null ? this.trip.getRoute().getShortName() : "NuLl") + " scheduled=" + new Date(this.scheduledArrivalTime) + " predicted=" + new Date(this.predictedArrivalTime);
    }
}

