/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.csv_entities.schema;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Map;
import org.onebusaway.csv_entities.CsvEntityContext;
import org.onebusaway.csv_entities.exceptions.CsvEntityException;
import org.onebusaway.csv_entities.exceptions.IntrospectionException;
import org.onebusaway.csv_entities.schema.BeanWrapper;
import org.onebusaway.csv_entities.schema.DefaultFieldMapping;
import org.onebusaway.csv_entities.schema.EntitySchemaFactory;
import org.onebusaway.csv_entities.schema.FieldMapping;
import org.onebusaway.csv_entities.schema.FieldMappingFactory;

public class DecimalFieldMappingFactory
implements FieldMappingFactory {
    private String _format;
    private Locale _locale = Locale.getDefault();

    public DecimalFieldMappingFactory() {
    }

    public DecimalFieldMappingFactory(String format) {
        this._format = format;
    }

    public DecimalFieldMappingFactory(String format, Locale locale) {
        this._format = format;
        this._locale = locale;
    }

    @Override
    public FieldMapping createFieldMapping(EntitySchemaFactory schemaFactory, Class<?> entityType, String csvFieldName, String objFieldName, Class<?> objFieldType, boolean required) {
        NumberFormat numberFormat = this.getFormat(entityType, objFieldName);
        return new FieldMappingImpl(entityType, csvFieldName, objFieldName, objFieldType, required, numberFormat);
    }

    private NumberFormat getFormat(Class<?> entityType, String objFieldName) {
        String format = this.determineFormat(entityType, objFieldName);
        if (this._locale == null) {
            return new DecimalFormat(format);
        }
        return new DecimalFormat(format, new DecimalFormatSymbols(this._locale));
    }

    private String determineFormat(Class<?> entityType, String objFieldName) {
        if (this._format != null) {
            return this._format;
        }
        Field field = null;
        try {
            field = entityType.getDeclaredField(objFieldName);
        }
        catch (Exception ex) {
            throw new IntrospectionException(entityType, (Throwable)ex);
        }
        NumberFormatAnnotation formatAnnotation = field.getAnnotation(NumberFormatAnnotation.class);
        if (formatAnnotation == null) {
            throw new DateFieldMappingException(entityType, "missing required @DateFormatAnnotation for field " + objFieldName + " of type " + entityType);
        }
        return formatAnnotation.value();
    }

    private static class FieldMappingImpl
    extends DefaultFieldMapping {
        private NumberFormat _numberFormat;

        public FieldMappingImpl(Class<?> entityType, String csvFieldName, String objFieldName, Class<?> objFieldType, boolean required, NumberFormat numberFormat) {
            super(entityType, csvFieldName, objFieldName, objFieldType, required);
            this._numberFormat = numberFormat;
        }

        @Override
        public void translateFromObjectToCSV(CsvEntityContext context, BeanWrapper object, Map<String, Object> csvValues) throws CsvEntityException {
            if (this.isMissingAndOptional(object)) {
                return;
            }
            Number n = (Number)object.getPropertyValue(this._objFieldName);
            String dateAsString = this._numberFormat.format(n);
            csvValues.put(this._csvFieldName, dateAsString);
        }
    }

    public static class DateFieldMappingException
    extends CsvEntityException {
        private static final long serialVersionUID = 1L;

        public DateFieldMappingException(Class<?> entityType, String message) {
            super(entityType, message);
        }

        public DateFieldMappingException(Class<?> entityType, String message, Throwable cause) {
            super(entityType, message, cause);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface NumberFormatAnnotation {
        public String value();
    }
}

