/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.realtime.api;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.realtime.api.EVehiclePhase;
import org.onebusaway.realtime.api.TimepointPredictionRecord;

public class VehicleLocationRecord
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long serviceDate;
    private AgencyAndId blockId;
    private int blockStartTime;
    private AgencyAndId tripId;
    private AgencyAndId vehicleId;
    private long timeOfRecord;
    private long timeOfLocationUpdate;
    private double scheduleDeviation = Double.NaN;
    private double distanceAlongBlock = Double.NaN;
    private double currentLocationLat = Double.NaN;
    private double currentLocationLon = Double.NaN;
    private double currentOrientation = Double.NaN;
    private List<TimepointPredictionRecord> timepointPredictions;
    private EVehiclePhase phase;
    private String status;
    private List<String> vehicleFeatures;
    private boolean mutated;

    public VehicleLocationRecord() {
    }

    public VehicleLocationRecord(VehicleLocationRecord r) {
        this.blockId = r.blockId;
        this.currentLocationLat = r.currentLocationLat;
        this.currentLocationLon = r.currentLocationLon;
        this.currentOrientation = r.currentOrientation;
        this.timeOfRecord = r.timeOfRecord;
        this.timeOfLocationUpdate = r.timeOfLocationUpdate;
        this.distanceAlongBlock = r.distanceAlongBlock;
        this.scheduleDeviation = r.scheduleDeviation;
        this.serviceDate = r.serviceDate;
        this.tripId = r.tripId;
        this.vehicleId = r.vehicleId;
        this.mutated = r.mutated;
        List<TimepointPredictionRecord> timepointPredictions = r.getTimepointPredictions();
        if (timepointPredictions != null) {
            ArrayList<TimepointPredictionRecord> dup = new ArrayList<TimepointPredictionRecord>(timepointPredictions.size());
            for (TimepointPredictionRecord tpr : timepointPredictions) {
                dup.add(new TimepointPredictionRecord(tpr));
            }
            this.timepointPredictions = dup;
        }
    }

    public long getServiceDate() {
        return this.serviceDate;
    }

    public void setServiceDate(long serviceDate) {
        this.serviceDate = serviceDate;
    }

    public AgencyAndId getBlockId() {
        return this.blockId;
    }

    public void setBlockId(AgencyAndId blockId) {
        this.blockId = blockId;
    }

    public int getBlockStartTime() {
        return this.blockStartTime;
    }

    public void setBlockStartTime(int blockStartTime) {
        this.blockStartTime = blockStartTime;
    }

    public AgencyAndId getTripId() {
        return this.tripId;
    }

    public void setTripId(AgencyAndId tripId) {
        this.tripId = tripId;
    }

    public AgencyAndId getVehicleId() {
        return this.vehicleId;
    }

    public void setVehicleId(AgencyAndId vehicleId) {
        this.vehicleId = vehicleId;
    }

    public long getTimeOfRecord() {
        return this.timeOfRecord;
    }

    public void setTimeOfRecord(long timeOfRecord) {
        this.timeOfRecord = timeOfRecord;
    }

    public long getTimeOfLocationUpdate() {
        return this.timeOfLocationUpdate;
    }

    public void setTimeOfLocationUpdate(long timeOfLocationUpdate) {
        this.timeOfLocationUpdate = timeOfLocationUpdate;
    }

    public boolean isScheduleDeviationSet() {
        return !Double.isNaN(this.scheduleDeviation);
    }

    public double getScheduleDeviation() {
        return this.scheduleDeviation;
    }

    public void setScheduleDeviation(double scheduleDeviation) {
        this.scheduleDeviation = scheduleDeviation;
    }

    public boolean isDistanceAlongBlockSet() {
        return !Double.isNaN(this.distanceAlongBlock);
    }

    public double getDistanceAlongBlock() {
        return this.distanceAlongBlock;
    }

    public void setDistanceAlongBlock(double distanceAlongBlock) {
        this.distanceAlongBlock = distanceAlongBlock;
    }

    public boolean isCurrentLocationSet() {
        return !Double.isNaN(this.currentLocationLat) && !Double.isNaN(this.currentLocationLon);
    }

    public double getCurrentLocationLat() {
        return this.currentLocationLat;
    }

    public void setCurrentLocationLat(double currentLocationLat) {
        this.currentLocationLat = currentLocationLat;
    }

    public double getCurrentLocationLon() {
        return this.currentLocationLon;
    }

    public void setCurrentLocationLon(double currentLocationLon) {
        this.currentLocationLon = currentLocationLon;
    }

    public boolean isCurrentOrientationSet() {
        return !Double.isNaN(this.currentOrientation);
    }

    public double getCurrentOrientation() {
        return this.currentOrientation;
    }

    public void setCurrentOrientation(double currentOrientation) {
        this.currentOrientation = currentOrientation;
    }

    public List<TimepointPredictionRecord> getTimepointPredictions() {
        return this.timepointPredictions;
    }

    public void setTimepointPredictions(List<TimepointPredictionRecord> timepointPredictions) {
        this.timepointPredictions = timepointPredictions;
    }

    public EVehiclePhase getPhase() {
        return this.phase;
    }

    public void setPhase(EVehiclePhase phase) {
        this.phase = phase;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public boolean hasVehicleFeatures() {
        return this.vehicleFeatures != null && !this.vehicleFeatures.isEmpty();
    }

    public void addVehicleFeature(String feature) {
        if (this.vehicleFeatures == null) {
            this.vehicleFeatures = new ArrayList<String>();
        }
        this.vehicleFeatures.add(feature);
    }

    public List<String> getVehicleFeatures() {
        return this.vehicleFeatures;
    }

    public void setMutated(boolean mutated) {
        this.mutated = mutated;
    }

    public boolean getMutated() {
        return this.mutated;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("VehicleLocationRecord:");
        if (this.blockId != null) {
            b.append(" blockId=").append(this.blockId);
        }
        if (this.tripId != null) {
            b.append(" tripId").append(this.tripId);
        }
        if (this.serviceDate != 0L) {
            b.append(" serviceDate=").append(this.serviceDate);
        }
        if (this.timeOfRecord != 0L) {
            b.append(" time=").append(new Date(this.timeOfRecord));
        }
        if (this.vehicleId != null) {
            b.append(" vehicleId=").append(this.vehicleId);
        }
        if (this.isScheduleDeviationSet()) {
            b.append(" scheduleDeviation=").append(this.scheduleDeviation);
        }
        if (this.isDistanceAlongBlockSet()) {
            b.append(" distanceAlongBlock=").append(this.distanceAlongBlock);
        }
        if (this.isCurrentLocationSet()) {
            b.append(" currentLocation=").append(this.currentLocationLat).append(" ").append(this.currentLocationLon);
        }
        if (this.isCurrentOrientationSet()) {
            b.append(" currentOrientation=").append(this.currentOrientation);
        }
        if (this.phase != null) {
            b.append(" phase=").append((Object)this.phase);
        }
        if (this.status != null) {
            b.append(" status=").append(this.status);
        }
        return b.toString();
    }
}

