/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.realtime.api;

import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum OccupancyStatus implements Serializable
{
    UNKNOWN(-1),
    EMPTY(0),
    MANY_SEATS_AVAILABLE(1),
    FEW_SEATS_AVAILABLE(2),
    STANDING_ROOM_ONLY(3),
    CRUSHED_STANDING_ROOM_ONLY(4),
    FULL(5),
    NOT_ACCEPTING_PASSENGERS(6);

    private static Logger _log;
    private int _status;

    private OccupancyStatus() {
        this._status = -1;
    }

    private OccupancyStatus(int status) {
        this._status = status;
    }

    public int valueOf() {
        return this._status;
    }

    public static boolean contains(String status) {
        for (OccupancyStatus OccupancyStatus2 : OccupancyStatus.values()) {
            if (!OccupancyStatus2.name().equalsIgnoreCase(status)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.toCamelCase(this.name());
    }

    public static OccupancyStatus toEnum(int status) {
        if (status == UNKNOWN.valueOf() || status < 0) {
            return UNKNOWN;
        }
        if (status == EMPTY.valueOf()) {
            return EMPTY;
        }
        if (status == MANY_SEATS_AVAILABLE.valueOf()) {
            return MANY_SEATS_AVAILABLE;
        }
        if (status == FEW_SEATS_AVAILABLE.valueOf()) {
            return FEW_SEATS_AVAILABLE;
        }
        if (status == STANDING_ROOM_ONLY.valueOf()) {
            return STANDING_ROOM_ONLY;
        }
        if (status == CRUSHED_STANDING_ROOM_ONLY.valueOf()) {
            return CRUSHED_STANDING_ROOM_ONLY;
        }
        if (status == FULL.valueOf()) {
            return FULL;
        }
        if (status == NOT_ACCEPTING_PASSENGERS.valueOf()) {
            _log.warn("Occupancy Status set to NotAcceptingPassengers");
            return NOT_ACCEPTING_PASSENGERS;
        }
        throw new IllegalArgumentException("unexpected value " + status);
    }

    public static OccupancyStatus toEnum(double rid) {
        int status = rid < 0.0 ? -1 : (rid == 0.0 ? 0 : (rid <= 25.0 ? 1 : (rid <= 50.0 ? 2 : (rid <= 75.0 ? 3 : (rid <= 90.0 ? 4 : (rid <= 100.0 ? 5 : 6))))));
        return OccupancyStatus.toEnum(status);
    }

    private String toCamelCase(String upperCase) {
        if (upperCase == null || upperCase.length() == 0) {
            return upperCase;
        }
        String[] parts = upperCase.split("_");
        StringBuffer camelCase = new StringBuffer();
        for (String part : parts) {
            camelCase.append(part.substring(0, 1).toUpperCase());
            camelCase.append(part.substring(1).toLowerCase());
        }
        String result = camelCase.substring(0, 1).toLowerCase() + camelCase.substring(1);
        return result;
    }

    static {
        _log = LoggerFactory.getLogger(OccupancyStatus.class);
    }
}

