/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.realtime.api;

import java.util.EnumSet;

public enum EVehiclePhase {
    AT_BASE,
    DEADHEAD_BEFORE,
    LAYOVER_BEFORE,
    IN_PROGRESS,
    DEADHEAD_DURING,
    LAYOVER_DURING,
    DEADHEAD_AFTER,
    LAYOVER_AFTER,
    UNKNOWN;

    private static EnumSet<EVehiclePhase> _activeBeforeBlock;
    private static EnumSet<EVehiclePhase> _activeDuringBlock;
    private static EnumSet<EVehiclePhase> _activeAfterBlock;
    private static EnumSet<EVehiclePhase> _activeLayovers;
    private static EnumSet<EVehiclePhase> _layovers;

    public static boolean isActiveBeforeBlock(EVehiclePhase phase) {
        return _activeBeforeBlock.contains((Object)phase);
    }

    public static boolean isActiveDuringBlock(EVehiclePhase phase) {
        return _activeDuringBlock.contains((Object)phase);
    }

    public static boolean isActiveAfterBlock(EVehiclePhase phase) {
        return _activeAfterBlock.contains((Object)phase);
    }

    public static boolean isActiveLayover(EVehiclePhase phase) {
        return _activeLayovers.contains((Object)phase);
    }

    public static boolean isLayover(EVehiclePhase phase) {
        return _layovers.contains((Object)phase);
    }

    public String toLabel() {
        return this.toString().toLowerCase();
    }

    static {
        _activeBeforeBlock = EnumSet.of(AT_BASE, DEADHEAD_BEFORE, LAYOVER_BEFORE);
        _activeDuringBlock = EnumSet.of(IN_PROGRESS, DEADHEAD_DURING, LAYOVER_DURING);
        _activeAfterBlock = EnumSet.of(DEADHEAD_AFTER, LAYOVER_AFTER);
        _activeLayovers = EnumSet.of(LAYOVER_BEFORE, LAYOVER_DURING);
        _layovers = EnumSet.of(LAYOVER_BEFORE, LAYOVER_DURING, LAYOVER_AFTER);
    }
}

