/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.util.logging.impl;

import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.Level;
import org.onebusaway.util.logging.LoggingService;
import org.onebusaway.util.services.configuration.ConfigurationServiceClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class LoggingServiceImpl
implements LoggingService {
    private ConfigurationServiceClient configurationServiceClient;
    private static final Logger log = LoggerFactory.getLogger(LoggingServiceImpl.class);

    @Override
    public String log(String component, Level priority, String message) {
        log.info("Starting to log message : {}", (Object)message);
        if (StringUtils.isBlank((String)message)) {
            throw new IllegalArgumentException("Message to log cannot be blank");
        }
        String responseText = this.configurationServiceClient.log("log", component, priority.intLevel(), message);
        log.info("Returning response from server");
        return responseText;
    }

    @Autowired
    public void setConfigurationServiceClient(ConfigurationServiceClient configurationServiceClient) {
        this.configurationServiceClient = configurationServiceClient;
    }
}

