/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.util.impl.configuration;

import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.onebusaway.container.refresh.RefreshService;
import org.onebusaway.util.impl.configuration.ConfigParameter;
import org.onebusaway.util.services.configuration.ConfigurationService;
import org.onebusaway.util.services.configuration.ConfigurationServiceClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

public class ConfigurationServiceImpl
implements ConfigurationService {
    private static Logger _log = LoggerFactory.getLogger(ConfigurationServiceImpl.class);
    @Autowired
    private ThreadPoolTaskScheduler _taskScheduler;
    private RefreshService _refreshService = null;
    private ConfigurationServiceClient _configurationServiceClient = null;
    private ConcurrentMap<String, String> _configurationKeyToValueMap = new ConcurrentHashMap<String, String>();
    private HashMap<String, Object> _localConfiguration = null;
    private HashMap<String, HashMap<String, String>> agencies;

    @Autowired
    public void setRefreshService(RefreshService refreshService) {
        this._refreshService = refreshService;
    }

    @Autowired
    public void setConfigurationServiceClient(ConfigurationServiceClient configServiceClient) {
        this._configurationServiceClient = configServiceClient;
    }

    @Autowired
    public void setTaskScheduler(ThreadPoolTaskScheduler taskScheduler) {
        this._taskScheduler = taskScheduler;
    }

    private void updateConfigurationMap(String configKey, String configValue) {
        if (!this._configurationServiceClient.isLocal()) {
            String currentValue = (String)this._configurationKeyToValueMap.get(configKey);
            this._configurationKeyToValueMap.put(configKey, configValue);
            if (currentValue == null || !configValue.equals(currentValue)) {
                _log.info("Invoking refresh method for config key " + configKey);
                this._refreshService.refresh(configKey);
            }
        }
    }

    public void refreshConfiguration() throws Exception {
        if (!this._configurationServiceClient.isLocal()) {
            List<JsonObject> configurationItems = this._configurationServiceClient.getItemsForRequest("config", "list");
            if (configurationItems == null) {
                _log.debug("no config values present!");
                return;
            }
            for (JsonObject configItem : configurationItems) {
                String configKey = configItem.get("key").getAsString();
                String configValue = configItem.get("value").getAsString();
                this.updateConfigurationMap(configKey, configValue);
            }
        } else {
            List<Map<String, String>> items = this._configurationServiceClient.getItems(null, null);
            if (items == null) {
                return;
            }
            for (Map<String, String> item : items) {
                String component = item.get("component");
                String key = item.get("key");
                String value = item.get("value");
                this._configurationKeyToValueMap.put(component + "." + key, value);
            }
        }
    }

    @PostConstruct
    private void startUpdateProcess() {
        if (this._configurationServiceClient.isLocal()) {
            _log.info("using local oba configuration");
        } else {
            _log.info("using tdm configuration");
        }
        this._taskScheduler.scheduleWithFixedDelay((Runnable)new UpdateThread(), 300000L);
    }

    @Override
    public String getConfigurationValueAsString(String configurationItemKey, String defaultValue) {
        String value = null;
        if (this._configurationServiceClient.isLocal()) {
            _log.debug("using localConfiguration=" + this._localConfiguration);
            try {
                value = this.getLocalConfigurationValue(configurationItemKey);
            }
            catch (Exception e) {
                _log.error("lookup up local config failed:", (Throwable)e);
            }
            _log.debug("for key=" + configurationItemKey + " found " + value);
            if (value == null) {
                return defaultValue;
            }
            return value;
        }
        if (this._configurationKeyToValueMap.size() == 0) {
            _log.warn("No configuration values are present!");
        } else {
            _log.debug("Have " + this._configurationKeyToValueMap.size() + " configuration parameters.");
        }
        value = (String)this._configurationKeyToValueMap.get(configurationItemKey);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    @Override
    public Float getConfigurationValueAsFloat(String configurationItemKey, Float defaultValue) {
        try {
            String defaultValueAsString = defaultValue != null ? defaultValue.toString() : null;
            return Float.valueOf(Float.parseFloat(this.getConfigurationValueAsString(configurationItemKey, defaultValueAsString)));
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    @Override
    public Integer getConfigurationValueAsInteger(String configurationItemKey, Integer defaultValue) {
        try {
            String defaultValueAsString = defaultValue != null ? defaultValue.toString() : null;
            return Integer.parseInt(this.getConfigurationValueAsString(configurationItemKey, defaultValueAsString));
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    @Override
    public Boolean getConfigurationValueAsBoolean(String configurationItemKey, Boolean defaultValue) {
        try {
            String defaultValueAsString = defaultValue != null ? defaultValue.toString() : null;
            String valueAsString = this.getConfigurationValueAsString(configurationItemKey, defaultValueAsString);
            if (valueAsString == null) {
                return defaultValue;
            }
            return Boolean.parseBoolean(valueAsString);
        }
        catch (Exception any) {
            return defaultValue;
        }
    }

    @Override
    public Double getConfigurationValueAsDouble(String configurationItemKey, Double defaultValue) {
        try {
            String defaultValueAsString = defaultValue != null ? defaultValue.toString() : null;
            return Double.parseDouble(this.getConfigurationValueAsString(configurationItemKey, defaultValueAsString));
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    @Override
    public void setConfigurationValue(String component, String configurationItemKey, String value) throws Exception {
        if (StringUtils.isBlank((String)value) || value.equals("null")) {
            throw new Exception("Configuration values cannot be null (or 'null' as a string!).");
        }
        if (StringUtils.isBlank((String)configurationItemKey)) {
            throw new Exception("Configuration item key cannot be null.");
        }
        String currentValue = (String)this._configurationKeyToValueMap.get(configurationItemKey);
        if (StringUtils.isNotBlank((String)currentValue) && currentValue.equals(value)) {
            return;
        }
        if (this._localConfiguration != null) {
            _log.error("setConfigurationValue not supported for _localConfiguration!");
            throw new UnsupportedOperationException();
        }
        this._configurationServiceClient.setConfigItem("config", component, configurationItemKey, value);
        this.updateConfigurationMap(configurationItemKey, value);
    }

    @Override
    public Map<String, String> getConfiguration() {
        try {
            this.refreshConfiguration();
        }
        catch (Exception e) {
            _log.error("Error updating configuration from TDM: " + e.getMessage());
            e.printStackTrace();
        }
        return this._configurationKeyToValueMap;
    }

    @Override
    public boolean getConfigurationFlagForAgency(String agencyId, String configurationItemKey) {
        try {
            String item = this._configurationServiceClient.getItem("agency_" + agencyId, configurationItemKey);
            return "true".equalsIgnoreCase(item);
        }
        catch (Exception any) {
            _log.error("exception for (" + agencyId + ", " + configurationItemKey + ")", (Throwable)any);
            return false;
        }
    }

    @Override
    public Map<String, List<ConfigParameter>> getParametersFromLocalFile() {
        return this._configurationServiceClient.getParametersFromLocalFile();
    }

    private String getLocalConfigurationValue(String configurationItemKey) throws Exception {
        return this._configurationServiceClient.getItem(null, configurationItemKey);
    }

    private class UpdateThread
    implements Runnable {
        private UpdateThread() {
        }

        @Override
        public void run() {
            try {
                ConfigurationServiceImpl.this.refreshConfiguration();
            }
            catch (Exception e) {
                _log.error("Error updating configuration from TDM: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }
}

