/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.util.impl.configuration;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.commons.io.FileUtils;
import org.onebusaway.util.impl.configuration.ConfigFileStructure;
import org.onebusaway.util.impl.configuration.ConfigItem;
import org.onebusaway.util.impl.configuration.ConfigParameter;
import org.onebusaway.util.services.configuration.ConfigurationServiceClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationServiceClientFileImpl
implements ConfigurationServiceClient {
    private static Logger _log = LoggerFactory.getLogger(ConfigurationServiceClientFileImpl.class);
    private static long CACHE_TIME_MILLIS = 60000L;
    private static int DEFAULT_TIMEOUT = 1000;
    private long lastCacheTime = 0L;
    private int connectionTimeout = DEFAULT_TIMEOUT;
    private int readTimeout = DEFAULT_TIMEOUT;
    private HashMap<String, Object> cachedMergeConfig = null;
    private String externalConfigurationApiUrl;
    private HashMap<String, Object> _config = null;
    private boolean isLocal = true;
    private String configFile = "/var/lib/oba/config.json";

    @Override
    public void setExternalConfigurationApiUrl(String url) {
        this.externalConfigurationApiUrl = url;
    }

    @Override
    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    @Override
    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setConfig(HashMap<String, Object> config) {
        this._config = config;
    }

    public void setConfigFile(String file) {
        _log.info("config service override of configFile=" + file);
        this.configFile = file;
    }

    public ConfigurationServiceClientFileImpl() {
        if (System.getProperty("config.json") != null) {
            this.configFile = System.getProperty("config.json");
            _log.info("config service using system override configFile=" + this.configFile);
            return;
        }
        _log.info("using default configuration file=" + this.configFile);
    }

    public ConfigurationServiceClientFileImpl(String configFile) {
        if (System.getProperty("config.json") != null) {
            this.configFile = System.getProperty("config.json");
            _log.info("config service using system override configFile=" + this.configFile);
            return;
        }
        _log.info("config service using configFile=" + configFile);
        this.configFile = configFile;
    }

    @PostConstruct
    private void checkConfig() {
        if (this.getConfig() == null) {
            this.isLocal = false;
        }
    }

    @Override
    public URL buildUrl(String baseObject, String ... params) throws Exception {
        _log.info("empty buildUrl");
        return null;
    }

    @Override
    public void setConfigItem(String baseObject, String component, String configurationKey, String value) throws Exception {
        String key = configurationKey.substring(configurationKey.indexOf(".") + 1);
        try {
            ObjectMapper mapper = new ObjectMapper();
            ConfigFileStructure cfs = (ConfigFileStructure)mapper.readValue(new File(this.configFile), ConfigFileStructure.class);
            boolean found = false;
            for (ConfigItem item : cfs.getConfig()) {
                if (!item.getComponent().equals(component) || !item.getKey().equals(key)) continue;
                item.setValue(value);
                found = true;
            }
            if (!found) {
                _log.warn("Could not find an existing configuration item for " + component + ":" + key + " so one will be created");
                cfs.getConfig().add(new ConfigItem(component, key, value));
            }
            mapper.writerWithDefaultPrettyPrinter().writeValue(new File(this.configFile), (Object)cfs);
            _log.debug(mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)cfs));
        }
        catch (Exception e) {
            _log.error("exception writing config:", (Object)e, (Object)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public String log(String baseObject, String component, Integer priority, String message) {
        _log.info("empty log");
        return null;
    }

    @Override
    public List<JsonObject> getItemsForRequest(String baseObject, String ... params) throws Exception {
        _log.info("empty getItemsForRequest");
        return null;
    }

    @Override
    public List<Map<String, String>> getItems(String baseObject, String ... params) throws Exception {
        _log.debug("getItems(" + baseObject + ", " + params + ")");
        if (this.getConfig() == null) {
            return null;
        }
        return (List)this.getConfig().get("config");
    }

    @Override
    public String getItem(String component, String key) throws Exception {
        List<Map<String, String>> settings = this.getItems("config", "list");
        if (settings == null) {
            return null;
        }
        for (Map<String, String> setting : settings) {
            if (component == null) {
                if (!setting.containsKey("key") || !key.equals(setting.get("key"))) continue;
                _log.debug("getItem(no-component)(" + component + ", " + key + ")=" + setting.get("value"));
                return setting.get("value");
            }
            if (!setting.containsKey("component") || !component.equals(setting.get("component")) || !setting.containsKey("key") || !key.equals(setting.get("key"))) continue;
            _log.debug("getItem(" + component + ", " + key + ")=" + setting.get("value"));
            return setting.get("value");
        }
        return null;
    }

    private HashMap<String, Object> getConfig() {
        if (this._config != null) {
            return this.mergeConfig(this._config);
        }
        try {
            HashMap o;
            String config = FileUtils.readFileToString((File)new File(this.configFile));
            this._config = o = (HashMap)new ObjectMapper(new JsonFactory()).readValue(config, (TypeReference)new TypeReference<HashMap<String, Object>>(){});
        }
        catch (Exception e) {
            _log.info("Failed to get configuration out of " + this.configFile + ", continuing without it.");
        }
        return this.mergeConfig(this._config);
    }

    synchronized HashMap<String, Object> mergeConfig(HashMap<String, Object> staticConfig) {
        if (this.cachedMergeConfig == null || this.cacheExpired()) {
            HashMap<String, Object> dynamicContent = this.getConfigFromApi();
            this.cachedMergeConfig = staticConfig;
            this.lastCacheTime = System.currentTimeMillis();
            if (dynamicContent == null || dynamicContent.isEmpty()) {
                return staticConfig;
            }
        }
        return this.cachedMergeConfig;
    }

    private boolean cacheExpired() {
        return System.currentTimeMillis() - this.lastCacheTime > CACHE_TIME_MILLIS;
    }

    HashMap<String, Object> mergeConfig(HashMap<String, Object> staticConfig, HashMap<String, Object> dynamicConfig) {
        ArrayList<HashMap<String, String>> mergedItems = new ArrayList<HashMap<String, String>>();
        ArrayList staticItems = (ArrayList)staticConfig.get("config");
        ArrayList dynamicItems = (ArrayList)dynamicConfig.get("config");
        for (HashMap staticItem : staticItems) {
            HashMap<String, String> dynamicItem = this.getConfigItem(this.getItemKey(staticItem), dynamicItems);
            mergedItems.add(this.mergeComponent(staticItem, dynamicItem));
        }
        for (HashMap dynamicItem : dynamicItems) {
            mergedItems.add(this.mergeComponent(dynamicItem, null));
        }
        staticConfig.put("config", mergedItems);
        return staticConfig;
    }

    private HashMap<String, String> getConfigItem(String searchItemKey, ArrayList<HashMap> configItems) {
        if (configItems == null) {
            return new HashMap<String, String>();
        }
        for (HashMap configItem : configItems) {
            String itemKey = this.getItemKey(configItem);
            if (!itemKey.equals(searchItemKey)) continue;
            return configItem;
        }
        return null;
    }

    String getItemKey(HashMap<String, String> configItem) {
        if (configItem == null) {
            return null;
        }
        return configItem.get("component") + "." + configItem.get("key");
    }

    private HashMap<String, String> mergeComponent(HashMap<String, String> staticMap, HashMap<String, String> dynamicMap) {
        if (dynamicMap == null) {
            return staticMap;
        }
        if (staticMap == null) {
            return dynamicMap;
        }
        String component = dynamicMap.get("component");
        String key = dynamicMap.get("key");
        String value = dynamicMap.get("value");
        staticMap.put("component", component);
        staticMap.put("key", key);
        staticMap.put("value", value);
        return staticMap;
    }

    @Override
    public Map<String, List<ConfigParameter>> getParametersFromLocalFile() {
        try {
            ObjectMapper mapper = new ObjectMapper();
            ConfigFileStructure cfs = (ConfigFileStructure)mapper.readValue(new File(this.configFile), ConfigFileStructure.class);
            return cfs.getAgencies();
        }
        catch (IOException e) {
            _log.error("problem converting file config file contents to config map", (Object)e, (Object)e);
            return null;
        }
    }

    private HashMap<String, String> getParametersFromCFS(ConfigFileStructure cfs) {
        HashMap<String, String> config = new HashMap<String, String>();
        for (ConfigItem item : cfs.getConfig()) {
            config.put(item.getComponent() + "." + item.getKey(), item.getValue());
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, Object> getConfigFromApi() {
        if (this.externalConfigurationApiUrl == null || this.externalConfigurationApiUrl.length() == 0) {
            return null;
        }
        InputStream in = null;
        URL url = null;
        String urlString = this.externalConfigurationApiUrl;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            _log.info("external configuration failed: ", (Object)e, (Object)e);
            return null;
        }
        try {
            URLConnection urlConnection = url.openConnection();
            urlConnection.setConnectTimeout(this.connectionTimeout);
            urlConnection.setReadTimeout(this.readTimeout);
            in = urlConnection.getInputStream();
            ObjectMapper mapper = new ObjectMapper();
            HashMap config = (HashMap)mapper.readValue(in, (TypeReference)new TypeReference<HashMap<String, Object>>(){});
            _log.info("refreshing configuration with {}", (Object)config);
            HashMap hashMap = config;
            return hashMap;
        }
        catch (SocketTimeoutException e) {
            _log.info("timeout issue with url " + url + ", ex=" + e);
            HashMap<String, Object> hashMap = null;
            return hashMap;
        }
        catch (IOException ex) {
            _log.info("connection issue with url " + url + ", ex=" + ex);
            HashMap<String, Object> hashMap = null;
            return hashMap;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {
                _log.error("error closing url stream " + url);
            }
        }
    }

    @Override
    public boolean isLocal() {
        return this.isLocal;
    }
}

