/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.util.git;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.onebusaway.util.git.GitRepositoryState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitRepositoryHelper {
    private static Logger _log = LoggerFactory.getLogger(GitRepositoryHelper.class);

    public Properties getProperties() {
        Properties properties = new Properties();
        try {
            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("git.properties");
            if (inputStream != null) {
                properties.load(inputStream);
            } else {
                _log.error("git.properties file not found");
            }
        }
        catch (IOException ioe) {
            _log.error("properties file not found:", (Throwable)ioe);
        }
        try {
            return properties;
        }
        catch (Exception any) {
            _log.error("exception creating properties:", (Throwable)any);
            return null;
        }
    }

    public GitRepositoryState getGitRepositoryState() {
        Properties properties = new Properties();
        try {
            InputStream stream = this.getClass().getClassLoader().getResourceAsStream("git.properties");
            if (stream == null) {
                return null;
            }
            properties.load(stream);
        }
        catch (IOException ioe) {
            _log.error("properties file not found:", (Throwable)ioe);
        }
        try {
            return new GitRepositoryState(properties);
        }
        catch (Exception any) {
            _log.error("exception creating properties:", (Throwable)any);
            return null;
        }
    }
}

