/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.util;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemTime {
    public static final String TIME_ADJUSTMENT_KEY = "org.onebusaway.util.SystemTime.enabled";
    private static final String TDS_PATH_KEY = "tds.path";
    private static final String API_CALL = "/adjustment.do";
    private static final int POLL_INTERVAL = 10;
    private static final int CONNECT_TIMEOUT = 5000;
    private static final int READ_TIMEOUT = 5000;
    private static SystemTime INSTANCE = new SystemTime();
    private static Logger _log = LoggerFactory.getLogger(SystemTime.class);
    private String _endpoint = null;
    private String _enabled = "false";
    private long adjustment = 0L;

    private SystemTime() {
        UpdateWorker uw = new UpdateWorker();
        new Thread(uw).start();
    }

    public static long currentTimeMillis() {
        return System.currentTimeMillis() + SystemTime.INSTANCE.adjustment;
    }

    public static void setEndpoint(String url) {
        SystemTime.INSTANCE._endpoint = url;
    }

    public static void setEnabled(String enabledFlag) {
        SystemTime.INSTANCE._enabled = enabledFlag;
    }

    public static void setAdjustment(long adjustmentFromNowInMillis) {
        SystemTime.INSTANCE.adjustment = adjustmentFromNowInMillis;
        _log.info("updated adjustment to " + adjustmentFromNowInMillis);
    }

    public static long getAdjustment() {
        return SystemTime.INSTANCE.adjustment;
    }

    private long refreshAdjustment() throws Exception {
        String responseString;
        if (!SystemTime.isEnabled()) {
            return 0L;
        }
        if (this.getEndpointUrl() == null) {
            return 0L;
        }
        String endpoint = this.getEndpointUrl();
        URL url = new URL(endpoint);
        URLConnection connection = url.openConnection();
        HttpURLConnection httpConnection = (HttpURLConnection)connection;
        httpConnection.setRequestMethod("GET");
        httpConnection.setDoInput(true);
        httpConnection.setDoOutput(false);
        httpConnection.setConnectTimeout(5000);
        httpConnection.setReadTimeout(5000);
        InputStreamReader isr = new InputStreamReader(httpConnection.getInputStream());
        BufferedReader in = new BufferedReader(isr);
        StringBuffer sb = new StringBuffer();
        while ((responseString = in.readLine()) != null) {
            sb.append(responseString);
        }
        return Long.parseLong(sb.toString());
    }

    private String getEndpointUrl() {
        String endpoint = null;
        endpoint = this.getEndpointUrlFromSystemProperty();
        if (StringUtils.isNotBlank((String)endpoint)) {
            return endpoint + API_CALL;
        }
        if (StringUtils.isNotBlank((String)this._endpoint)) {
            return this._endpoint;
        }
        return null;
    }

    private String getEndpointUrlFromSystemProperty() {
        return System.getProperty(TDS_PATH_KEY);
    }

    public static boolean isEnabled() {
        String systemProperty = System.getProperty(TIME_ADJUSTMENT_KEY);
        if (systemProperty != null) {
            return "true".equals(systemProperty);
        }
        return "true".equalsIgnoreCase(SystemTime.INSTANCE._enabled);
    }

    public class UpdateWorker
    implements Runnable {
        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            if (!INSTANCE.isEnabled()) {
                _log.info("SystemTime Adjustment disabled.  Exiting.");
                return;
            }
            if (!StringUtils.isNotBlank((String)SystemTime.this.getEndpointUrl())) {
                _log.error("SystemTime Adjustment enabled but no endpoint ULR configured!  Please set -Dtds.path=http://localhost:8080/onebusaway-transit-data-federation-webapp or equivalent.  Exiting.");
                return;
            }
            _log.warn("SystemTime Adjustment enabled.  Polling " + SystemTime.this.getEndpointUrl() + " every 10 seconds");
            while (!Thread.interrupted()) {
                try {
                    int rc = this.sleep(10);
                    if (rc < 0) {
                        _log.info("caught SIGHUP, exiting");
                        return;
                    }
                    _log.debug("check for instance=" + INSTANCE.toString());
                    long adj = SystemTime.this.refreshAdjustment();
                    if (adj == SystemTime.this.adjustment) continue;
                    _log.info("updated adjustment to " + adj);
                    SystemTime.this.adjustment = adj;
                }
                catch (Exception e) {
                    _log.error("refresh failed:" + e);
                    continue;
                }
                break;
            }
            return;
        }

        private int sleep(int i) {
            try {
                Thread.sleep(i * 1000);
            }
            catch (InterruptedException e) {
                return -1;
            }
            return 0;
        }
    }
}

